package cz.cuni.pogamut.posh.widget.structure;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.DocString;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.elements.Triggers;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Exceptions;

/**
 * Factory for creating
 * @author Honza
 */
class StrWidgetFactory {

	private static Map<Class, Class> map = new HashMap<Class, Class>();


	static {
		// Yay for Java stupidity, C# has inicialization of collections right after constructor
		//map.put(PoshTreeRoot.class, RootWidget.class);
		map.put(DriveCollection.class, StrDriveCollectionWidget.class);
		map.put(DocString.class, StrDocumentationWidget.class);
		map.put(ActionPattern.class, StrAPWidget.class);
		map.put(Competence.class, StrCompNodeWidget.class);
		map.put(CompetencePriorityElement.class, StrCompElementWidget.class);
		map.put(CompetenceElement.class, StrCompAtomWidget.class);
		map.put(Goal.class, StrGoalWidget.class);
		map.put(DrivePriorityElement.class, StrDriveWidget.class);
		map.put(DriveElement.class, StrDriveElementWidget.class);
		map.put(TriggeredAction.class, StrTriggeredActionWidget.class);
		map.put(Triggers.class, StrTriggersWidget.class);
		map.put(Sense.class, StrSenseWidget.class);
	}

	static PoshWidget createWidgetFromDN(PoshScene scene, PoshElement dataNode, PoshWidget parent) {
		Class dnClass = dataNode.getClass();

		if (!map.containsKey(dnClass)) {
			throw new RuntimeException("No widget for class " + dataNode.getClass().getCanonicalName());
		}

		Class widgetClass = map.get(dnClass);

		Constructor[] constructors = widgetClass.getConstructors();

		for (Constructor c : constructors) {
			Class[] param = c.getParameterTypes();
			if (param.length == 3 &&
					PoshScene.class.isAssignableFrom(param[0]) &&
					PoshElement.class.isAssignableFrom(param[1]) &&
					PoshWidget.class.isAssignableFrom(param[2])) {
				try {
					return (PoshWidget) c.newInstance(new Object[]{scene, dataNode, parent});
				} catch (InstantiationException ex) {
					Exceptions.printStackTrace(ex);
				} catch (IllegalAccessException ex) {
					Exceptions.printStackTrace(ex);
				} catch (IllegalArgumentException ex) {
					Exceptions.printStackTrace(ex);
				} catch (InvocationTargetException ex) {
					Exceptions.printStackTrace(ex);
				}
			}
		}
		throw new RuntimeException("No constructor found for class " + widgetClass.getCanonicalName());
	}
}
