package cz.cuni.pogamut.posh.widget.structure;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author Honza
 */
public class StrSenseWidget extends StrBasicWidget<Sense> {

	public StrSenseWidget(PoshScene poshScene, Sense dataNode, PoshWidget parent) {
		super(poshScene, dataNode, parent);
	}

	@Override
	protected List<AbstractMenuAction> createMenuActions() {
            LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();

            if (getDataNode().getParent().getNumberOfChildInstances(getDataNode().getClass()) > 1) {
                list.add(new DeleteNodeAction("Delete", getDataNode()));
            }
            
            return list;
	}

	@Override
	protected void addChildWidget(PoshElement dataNode) {
		synchronizeDataNodeWidgets(dataNode);
	}

	@Override
	protected List<AbstractAcceptAction> getAcceptProviders() {
		// toto: implement
		return new LinkedList<AbstractAcceptAction>();
	}

	@Override
	protected PoshNodeType getType() {
		return PoshNodeType.SENSE;
	}

        @Override
	public void propertyChange(PropertyChangeEvent evt) {
		Sense sense = (Sense) evt.getSource();
                this.setHeadlineText(sense.getRepresentation());
                this.doRepaint();
	}
}
