package cz.cuni.pogamut.posh.widget.structure;

import cz.cuni.amis.pogamut.sposh.elements.DocString;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import org.openide.nodes.Node.Property;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

/**
 *
 * @author Honza
 */
public class StrDocumentationWidget extends StrBasicWidget<DocString> {
	public StrDocumentationWidget(PoshScene poshScene, DocString dataNode, PoshWidget parent) {
		super(poshScene, dataNode, parent);
	}

	@Override
	protected List<AbstractMenuAction> createMenuActions() {
                LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();

                list.add(new DeleteNodeAction("Delete", getDataNode()));

                return list;
	}

	@Override
	protected void addChildWidget(PoshElement dataNode) {
		synchronizeDataNodeWidgets(dataNode);
	}

	@Override
	protected List<AbstractAcceptAction> getAcceptProviders() {
		// todo: implement
		return new LinkedList<AbstractAcceptAction>();
	}

	@Override
	protected PoshNodeType getType() {
		return PoshNodeType.DOCSTRING;
	}

        @Override
	public void propertyChange(PropertyChangeEvent evt) {
		throw new UnsupportedOperationException("Not supported yet.");
	}

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);

        try {
            Property planNameProp = new PropertySupport.Reflection<String>(getDataNode(), String.class, "getNodePlanName", "setNodePlanName");
            Property authorProp = new PropertySupport.Reflection<String>(getDataNode(), String.class, "getNodeAuthor", "setNodeAuthor");
            Property commentProp = new PropertySupport.Reflection<String>(getDataNode(), String.class, "getNodeComment", "setNodeComment");

            planNameProp.setName(DocString.docName);
            authorProp.setName(DocString.docAuthor);
            commentProp.setName(DocString.docComment);

            planNameProp.setDisplayName("Name of POSH plan");
            authorProp.setDisplayName("Author");
            commentProp.setDisplayName("Comment about node");

            commentProp.setShortDescription("It is difficult to keep track about what part of POSH plan does what ant hat is where comments come in.");

            set.put(new Property[]{planNameProp, authorProp, commentProp});
        } catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace(ex);
        }
        return sheet;
    }
}
