package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

/**
 * AcceptProvider when DrivePriorityElement is dropped on the SimpleDriveWidget.
 * Add it in the list before DrivePriorityElement this widget is representing
 */
public class AcceptDrive2Drive extends AbstractAcceptAction<DrivePriorityElement> {

    public AcceptDrive2Drive(DrivePriorityElement drive) {
        super(DrivePriorityElement.dataFlavor, drive, null);
    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        DrivePriorityElement newDrive = (DrivePriorityElement) tr.getTransferData(dataFlavor);
        if (newDrive == null) {
            return;
        }

        DriveCollection dc = (DriveCollection) this.dataNode.getParent();

        dc.addChildDataNode(newDrive);

        int newlyAddedElementIndex =
                this.getIndexInList(dc.getChildDataNodes(), newDrive);

        // find index, where should dropped sense be =
        //    index of sense new sense was dropped on
        int assignedCElementIndex =
                this.getIndexInList(dc.getChildDataNodes(), dataNode);

        int relativePositionChange =
                assignedCElementIndex - newlyAddedElementIndex;

        dc.moveChild(newDrive, relativePositionChange);
    }
}
