package cz.cuni.pogamut.posh.view;

import cz.cuni.pogamut.posh.PoshEditorSupport;
import java.awt.EventQueue;
import java.awt.Image;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

/**
 * Description of MV element that will show structure of the plan.
 * @author Honza
 */
public class StructureDesc implements MultiViewDescription {

    private PoshEditorSupport support;
    private StructureEditor editor;

    public StructureDesc(PoshEditorSupport support) {
        this.support = support;
    }

    @Override
    public String getDisplayName() {
        return "Structure view";
    }

    @Override
    public String preferredID() {
        return "StructureView";
    }

    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ONLY_OPENED;
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    public MultiViewElement createElement() {
        return getEditor();
    }

    private StructureEditor getEditor() {
        assert EventQueue.isDispatchThread();
        if (editor == null) {
            editor = new StructureEditor(support);
        }
        return editor;
    }
}
