/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentSuite;
import java.util.List;

/**
 * A simple implementation of experiment suite.
 * @author Martin Cerny
 */
public class ExperimentSuite<RESULT,PARAMETERS> implements IExperimentSuite<RESULT, PARAMETERS> {

    List<? extends IExperiment<RESULT, PARAMETERS>> experiments;

    public ExperimentSuite(List<? extends IExperiment<RESULT, PARAMETERS>> experiments) {
        this.experiments = experiments;
    }
    
    
    
    @Override
    public void afterAllExperiments() {
    }

    @Override
    public void afterExperiment(IExperiment<RESULT, PARAMETERS> experiment) {
    }

    @Override
    public void beforeAllExperiments() {
    }

    @Override
    public void beforeExperiment(IExperiment<RESULT, PARAMETERS> experiment) {
    }

    @Override
    public List<? extends IExperiment<RESULT, PARAMETERS>> getExperiments() {
        return experiments;
    }
    
}
