/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentFilter;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunResult;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentSuite;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import java.util.List;
import java.util.logging.Level;

/**
 * Helper class for all experiment suite runners that need only one thread
 * @author Martin Cerny
 */
public abstract class AbstractSingleThreadExperimentSuiteRunner<RESULT, PARAMETERS> extends AbstractExperimentSuiteRunner<RESULT, PARAMETERS> {

    public AbstractSingleThreadExperimentSuiteRunner(LogCategory log) {
        super(log);
    }

    
    
    
    protected abstract IExperimentRunResult<RESULT> runSingleExperiment(IExperiment<RESULT,PARAMETERS> experiment);
    
    protected abstract void handleExperimentResult(int experimentNumber, IExperiment<RESULT,PARAMETERS> experiment, IExperimentRunResult<RESULT> result);
    
    @Override
    public void runExperimentSuite(IExperimentSuite<RESULT, PARAMETERS> suite, int startExperiment, int stopAfter, IExperimentFilter<PARAMETERS> filter) {
        log.info("Running beforeAllExperiments()");
        suite.beforeAllExperiments();
        
        int numExperimentsRun = 0;
        
        List<? extends IExperiment<RESULT,PARAMETERS>> experiments = suite.getExperiments();
        for(int i = startExperiment; i < experiments.size(); i++){
            if(stopAfter > 0 && numExperimentsRun >= stopAfter){
                break;
            }
            IExperiment<RESULT,PARAMETERS> experiment = experiments.get(i);
            if(filter == null || filter.accept(experiment.getParameters())){
                suite.beforeExperiment(experiment);
                log.info("Running experiment no.: " + i);
                IExperimentRunResult<RESULT> result = runSingleExperiment(experiment);
                handleExperimentResult(i,experiment, result);
                suite.afterExperiment(experiment);
                Pogamut.getPlatform().close();
                System.gc();
                numExperimentsRun++;
            } else if(log.isLoggable(Level.FINE)){
                log.fine("Experiment no." + i + " was filtered out.");
            }
        }
        
        log.info("All exepriments done, running afterAllExperiments().");
        suite.afterAllExperiments();
    }
    
}
