/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments;

/**
 *
 * @author Martin Cerny
 */
public interface IExperimentRunResult<RESULT> {
    enum State { SUCCESS, FAILURE, EXCEPTION, TIMEOUT }
    
    State getState();
    
    /**
     * Result of the experiment if state was {@link State#SUCCESS} or null otherwise.
     * @return 
     */
    RESULT getResult();
    
    /**
     * Exception that terminated the experiment or null if the experiment
     * terminated for another reason.
     * @return 
     */
    Exception getException();
    
    /**
     * Any further information about experiment result for logging purposes, or null
     * if there is no such info.
     * @return 
     */
    String getMessage();

    long getRunningTime();
    
    long getStartTime();
}
