/*
 * Decompiled with CFR 0.152.
 */
package JSHOP2;

import JSHOP2.CompileTimeObject;
import JSHOP2.JSHOP2;
import JSHOP2.Term;
import JSHOP2.TermList;

public class Predicate
extends CompileTimeObject {
    private int head;
    private Term param;
    private int varCount;
    private int varIdx;

    public Predicate(int headIn, int varCountIn, Term paramIn) {
        this.head = headIn;
        this.varCount = varCountIn;
        this.param = paramIn;
        this.varIdx = -1;
    }

    public Predicate(int varIdxIn, int varCountIn) {
        this.head = -1;
        this.varCount = varCountIn;
        this.param = TermList.NIL;
        this.varIdx = varIdxIn;
    }

    public Predicate applySubstitution(Term[] bindings) {
        if (this.isVar()) {
            if (bindings[this.varIdx] == null) {
                return this;
            }
            return ((TermList)bindings[this.varIdx]).toPredicate(this.varCount);
        }
        return new Predicate(this.head, this.varCount, this.param.bind(bindings));
    }

    public boolean equals(Term t) {
        if (this.isVar()) {
            return false;
        }
        return this.param.equals(t);
    }

    public Term[] findUnifier(Term t) {
        Term[] retVal = new Term[this.varCount];
        for (int i = 0; i < this.varCount; ++i) {
            retVal[i] = null;
        }
        if (this.isVar()) {
            retVal[this.varIdx] = t;
            return retVal;
        }
        if (this.param.findUnifier(t, retVal)) {
            return retVal;
        }
        return null;
    }

    public int getHead() {
        return this.head;
    }

    public Term getParam() {
        return this.param;
    }

    public int getVarCount() {
        return this.varCount;
    }

    public boolean isGround() {
        if (this.isVar()) {
            return false;
        }
        return this.param.isGround();
    }

    public boolean isVar() {
        return this.varIdx != -1;
    }

    public void print() {
        System.out.println(this);
    }

    public void print(String[] constants) {
        System.out.println(this.toString(constants));
    }

    public void setVarCount(int varCountIn) {
        this.varCount = varCountIn;
    }

    public String toCode() {
        if (this.isVar()) {
            return "new Predicate(" + this.varIdx + ", " + this.varCount + ")";
        }
        return "new Predicate(" + this.head + ", " + this.varCount + ", " + this.param.toCode() + ")";
    }

    public String toString() {
        if (this.isVar()) {
            return "VAR" + this.varIdx;
        }
        String s = "(" + JSHOP2.getDomain().getConstant(this.head);
        if (this.param instanceof TermList) {
            if (this.param.isNil()) {
                return s + ")";
            }
            return s + " " + ((TermList)this.param).getList() + ")";
        }
        return s + "." + this.param + ")";
    }

    public String toString(String[] constants) {
        if (this.isVar()) {
            return "VAR" + this.varIdx;
        }
        String s = "(" + constants[this.head];
        if (this.param instanceof TermList) {
            if (this.param.isNil()) {
                return s + ")";
            }
            return s + " " + ((TermList)this.param).getList() + ")";
        }
        return s + "." + this.param + ")";
    }
}

