/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Node;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Match2CaptureNode
extends Match2Node {
    private int[] scopeOffsets;

    public Match2CaptureNode(ISourcePosition position, Node receiverNode, Node valueNode, int[] scopeOffsets) {
        super(position, receiverNode, valueNode);
        this.scopeOffsets = scopeOffsets;
    }

    public int[] getScopeOffsets() {
        return this.scopeOffsets;
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = super.interpret(runtime2, context, self, aBlock);
        DynamicScope scope = context.getCurrentScope();
        RuntimeHelpers.updateScopeWithCaptures(context, scope, this.scopeOffsets, result);
        return result;
    }
}

