/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.session;

import org.sonar.api.database.DatabaseSession;
import org.sonar.jpa.session.DatabaseConnector;
import org.sonar.jpa.session.DatabaseSessionFactory;
import org.sonar.jpa.session.JpaDatabaseSession;

public class ThreadLocalDatabaseSessionFactory
implements DatabaseSessionFactory {
    private final ThreadLocal<JpaDatabaseSession> threadSession = new ThreadLocal();
    private final DatabaseConnector connector;

    public ThreadLocalDatabaseSessionFactory(DatabaseConnector connector) {
        this.connector = connector;
    }

    public DatabaseSession getSession() {
        JpaDatabaseSession session = this.threadSession.get();
        if (session == null) {
            session = new JpaDatabaseSession(this.connector);
            session.start();
            this.threadSession.set(session);
        }
        return session;
    }

    public void clear() {
        JpaDatabaseSession session = this.threadSession.get();
        if (session != null) {
            session.stop();
        }
        this.threadSession.set(null);
    }

    public void stop() {
        this.clear();
    }
}

