/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.session;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.sonar.jpa.entity.SchemaMigration;
import org.sonar.jpa.session.DatabaseException;
import org.sonar.jpa.session.DriverDatabaseConnector;

public class MemoryDatabaseConnector
extends DriverDatabaseConnector {
    public static final String DRIVER = "org.hsqldb.jdbcDriver";
    public static final String URL = "jdbc:hsqldb:mem:sonar";
    public static final String USER = "sa";
    public static final String PASSWORD = "";
    public static final int ISOLATION = 1;
    private int version = 170;

    public MemoryDatabaseConnector(Configuration config) {
        super(config);
    }

    public MemoryDatabaseConnector() {
        this(MemoryDatabaseConnector.getInMemoryConfiguration(true));
    }

    public MemoryDatabaseConnector(int version) {
        this(MemoryDatabaseConnector.getInMemoryConfiguration(true));
        this.version = version;
    }

    protected static Configuration getInMemoryConfiguration(boolean createSchema) {
        PropertiesConfiguration conf = new PropertiesConfiguration();
        conf.setProperty("sonar.jdbc.url", (Object)URL);
        conf.setProperty("sonar.jdbc.driverClassName", (Object)DRIVER);
        conf.setProperty("sonar.jdbc.username", (Object)USER);
        conf.setProperty("sonar.jdbc.password", (Object)PASSWORD);
        conf.setProperty("sonar.jdbc.defaultTransactionIsolation", (Object)1);
        if (createSchema) {
            conf.setProperty("sonar.jdbc.hibernate.hbm2ddl", (Object)"create-drop");
        }
        return conf;
    }

    public void start() {
        try {
            super.start();
        }
        catch (DatabaseException ex) {
            if (!this.isStarted()) {
                throw ex;
            }
            this.setEntityManagerFactory(this.createEntityManagerFactory());
            this.setupSchemaVersion(this.version);
        }
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        return super.createEntityManagerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupSchemaVersion(int version) {
        SchemaMigration migration = new SchemaMigration();
        migration.setVersion(version);
        EntityManager manager = null;
        try {
            manager = this.createEntityManager();
            manager.getTransaction().begin();
            manager.persist((Object)migration);
            manager.getTransaction().commit();
        }
        finally {
            if (manager != null) {
                manager.close();
            }
        }
    }
}

