/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.entity;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="schema_migrations", uniqueConstraints={@UniqueConstraint(columnNames={"version"})})
public class SchemaMigration {
    public static final int VERSION_UNKNOWN = -1;
    public static final int LAST_VERSION = 170;
    public static final String TABLE_NAME = "schema_migrations";
    @Id
    @Column(name="version", updatable=true)
    private String version;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String s) {
        this.version = s;
    }

    public void setVersion(int i) {
        this.version = String.valueOf(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getCurrentVersion(Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        int version = -1;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SELECT version FROM schema_migrations");
            while (rs.next()) {
                int i = Integer.parseInt(rs.getString(1));
                if (i <= version) continue;
                version = i;
            }
        }
        catch (SQLException e) {
            SchemaMigration.close(rs);
            SchemaMigration.close(stmt);
            catch (Throwable throwable) {
                SchemaMigration.close(rs);
                SchemaMigration.close(stmt);
                throw throwable;
            }
        }
        SchemaMigration.close(rs);
        SchemaMigration.close(stmt);
        return version;
    }

    private static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

