/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dao;

import java.util.Iterator;
import java.util.List;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.RuleFailureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.jpa.dao.BaseDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesDao
extends BaseDao {
    public RulesDao(DatabaseSession session) {
        super(session);
    }

    public List<Rule> getRules() {
        return this.getSession().getResults(Rule.class, new Object[]{"enabled", true});
    }

    public List<Rule> getRulesByRepository(String repositoryKey) {
        return this.getSession().getResults(Rule.class, new Object[]{"pluginName", repositoryKey, "enabled", true});
    }

    @Deprecated
    public List<Rule> getRulesByPlugin(String pluginKey) {
        return this.getRulesByRepository(pluginKey);
    }

    public Rule getRuleByKey(String repositoryKey, String ruleKey) {
        return (Rule)this.getSession().getSingleResult(Rule.class, new Object[]{"key", ruleKey, "pluginName", repositoryKey, "enabled", true});
    }

    public Long countRules(List<String> plugins) {
        return (Long)this.getSession().createQuery("SELECT COUNT(r) FROM Rule r WHERE r.pluginName IN (:pluginNames) AND r.enabled=true").setParameter("pluginNames", plugins).getSingleResult();
    }

    public List<RuleParam> getRuleParams() {
        return this.getSession().getResults(RuleParam.class);
    }

    public RuleParam getRuleParam(Rule rule, String paramKey) {
        return (RuleParam)this.getSession().getSingleResult(RuleParam.class, new Object[]{"rule", rule, "key", paramKey});
    }

    public void addActiveRulesToProfile(List<ActiveRule> activeRules, int profileId, String pluginKey) {
        RulesProfile rulesProfile = this.getProfileById(profileId);
        for (ActiveRule activeRule : activeRules) {
            this.synchronizeRuleOfActiveRule(activeRule, pluginKey);
            activeRule.setRulesProfile(rulesProfile);
            this.getSession().save((Object)activeRule);
        }
    }

    public List<RuleFailureModel> getViolations(Snapshot snapshot) {
        return this.getSession().getResults(RuleFailureModel.class, new Object[]{"snapshotId", snapshot.getId()});
    }

    public void synchronizeRuleOfActiveRule(ActiveRule activeRule, String pluginKey) {
        Rule rule = activeRule.getRule();
        Rule ruleFromDataBase = this.getRuleByKey(pluginKey, rule.getKey());
        activeRule.setRule(ruleFromDataBase);
        List<RuleParam> ruleParamsFromDataBase = this.getRuleParams();
        for (ActiveRuleParam activeRuleParam : activeRule.getActiveRuleParams()) {
            boolean found = false;
            Iterator<RuleParam> iterator = ruleParamsFromDataBase.iterator();
            while (iterator.hasNext() && !found) {
                RuleParam ruleParamFromDataBase = iterator.next();
                if (!this.isRuleParamEqual(activeRuleParam.getRuleParam(), ruleParamFromDataBase, rule.getKey(), pluginKey)) continue;
                activeRuleParam.setRuleParam(ruleParamFromDataBase);
                found = true;
            }
        }
    }

    public boolean isRuleParamEqual(RuleParam ruleParam, RuleParam ruleParamFromDatabase, String ruleKey, String pluginKey) {
        return ruleParam.getKey().equals(ruleParamFromDatabase.getKey()) && ruleKey.equals(ruleParamFromDatabase.getRule().getKey()) && ruleParamFromDatabase.getRule().getPluginName().equals(pluginKey);
    }

    public RulesProfile getProfileById(int profileId) {
        return (RulesProfile)this.getSession().getEntityManager().getReference(RulesProfile.class, (Object)profileId);
    }
}

