/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceWhereCommand {
    private ScmLogger logger = null;
    private PerforceScmProviderRepository repo = null;

    public PerforceWhereCommand(ScmLogger log, PerforceScmProviderRepository repos) {
        this.logger = log;
        this.repo = repos;
    }

    public String getDepotLocation(File file) {
        return this.getDepotLocation(file.getAbsolutePath());
    }

    public String getDepotLocation(String filepath) {
        if (!PerforceScmProvider.isLive()) {
            return null;
        }
        try {
            String line;
            Commandline command = PerforceScmProvider.createP4Command(this.repo, null);
            command.createArgument().setValue("where");
            command.createArgument().setValue(filepath);
            this.logger.debug(PerforceScmProvider.clean("Executing: " + command.toString()));
            Process proc = command.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader brErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String path = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf("not in client view") != -1) {
                    this.logger.error(line);
                    return null;
                }
                if (line.indexOf("is not under") != -1) {
                    this.logger.error(line);
                    return null;
                }
                this.logger.debug(line);
                path = line.substring(0, line.lastIndexOf("//") - 1);
            }
            while ((line = brErr.readLine()) != null) {
                if (line.indexOf("not in client view") != -1) {
                    this.logger.error(line);
                    return null;
                }
                if (line.indexOf("is not under") != -1) {
                    this.logger.error(line);
                    return null;
                }
                this.logger.debug(line);
            }
            return path;
        }
        catch (CommandLineException e) {
            this.logger.error((Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

