/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.File;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.ArtifactScanningListener;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.ScanningResult;
import org.sonatype.nexus.index.context.IndexingContext;

public class RepositoryIndexerListener
implements ArtifactScanningListener {
    private final IndexingContext indexingContext;
    private final NexusIndexer nexusIndexer;
    private long tstart;
    private int count;
    private ProgressHandle handle;
    private RepositoryInfo ri;
    private final boolean DEBUG = false;
    private InputOutput io;
    private OutputWriter writer;

    public RepositoryIndexerListener(NexusIndexer nexusIndexer, IndexingContext indexingContext) {
        this.indexingContext = indexingContext;
        this.nexusIndexer = nexusIndexer;
        this.ri = RepositoryPreferences.getInstance().getRepositoryInfoById(indexingContext.getId());
    }

    public void scanningStarted(IndexingContext ctx) {
        this.handle = ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(RepositoryIndexerListener.class, (String)"LBL_Indexing") + (this.ri != null ? this.ri.getName() : this.indexingContext.getId())));
        this.handle.start();
        this.handle.switchToIndeterminate();
        this.tstart = System.currentTimeMillis();
    }

    public void artifactDiscovered(ArtifactContext ac) {
        ++this.count;
        ArtifactInfo ai = ac.getArtifactInfo();
        this.handle.progress(ac.getArtifactInfo().groupId + ":" + ac.getArtifactInfo().artifactId + ":" + ac.getArtifactInfo().version);
    }

    public void artifactError(ArtifactContext ac, Exception e) {
    }

    private String formatFile(File file) {
        return file.getAbsolutePath().substring(this.indexingContext.getRepository().getAbsolutePath().length() + 1);
    }

    public void scanningFinished(IndexingContext ctx, ScanningResult result) {
        this.handle.finish();
    }
}

