/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class RemoteIndexTransferListener
implements TransferListener {
    private ProgressHandle handle;
    private RepositoryInfo info;
    private int lastunit;
    private boolean debug;
    private InputOutput io;
    private OutputWriter writer;
    private int units;
    private static Map<Thread, Integer> transfers = new HashMap<Thread, Integer>();
    private static final Object TRANSFERS_LOCK = new Object();

    public RemoteIndexTransferListener(RepositoryInfo info) {
        this.info = info;
        if (this.debug) {
            this.io = IOProvider.getDefault().getIO(NbBundle.getMessage(RemoteIndexTransferListener.class, (String)"LBL_Transfer_TAG") + info.getName(), true);
            this.writer = this.io.getOut();
        }
    }

    public void transferInitiated(TransferEvent arg0) {
    }

    public void transferStarted(TransferEvent arg0) {
        long contentLength = arg0.getResource().getContentLength();
        this.handle = ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(RemoteIndexTransferListener.class, (String)"LBL_Transfer_TAG") + this.info.getName()));
        this.units = (int)contentLength / 1024;
        this.handle.start(this.units);
        if (this.debug) {
            this.writer.println("File Size :" + (int)contentLength / 1024);
        }
    }

    public void transferProgress(TransferEvent arg0, byte[] arg1, int arg2) {
        int work = arg2 / 1024;
        if (this.handle != null) {
            this.handle.progress(Math.min(this.units, this.lastunit += work));
        }
        if (this.debug) {
            this.writer.println("Units completed :" + this.lastunit);
        }
    }

    public void transferCompleted(TransferEvent arg0) {
        if (this.handle != null) {
            this.handle.finish();
        }
        if (this.debug) {
            this.writer.println("Completed");
        }
    }

    public void transferError(TransferEvent arg0) {
        if (this.debug) {
            this.writer.println("Finish with Errors");
        }
    }

    public void debug(String arg0) {
        if (this.debug) {
            this.writer.println(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToActive(Thread t) {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            Integer count = transfers.get(t);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            transfers.put(t, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromActive(Thread t) {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            Integer count = transfers.get(t);
            if (count == null) {
                return;
            }
            if (count <= 1) {
                transfers.remove(t);
            } else {
                count = count - 1;
                transfers.put(t, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Thread> getActiveTransfersOrScans() {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            return transfers.keySet();
        }
    }
}

