/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.artifact.AttachedArtifact;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Input;
import org.apache.tools.ant.taskdefs.PathConvert;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.mojo.nbm.AbstractNbmMojo;
import org.codehaus.mojo.nbm.ExamineManifest;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class PopulateRepositoryMojo
extends AbstractNbmMojo {
    private String deployUrl;
    private boolean skipLocalInstall;
    protected File netbeansInstallDirectory;
    protected File netbeansJavadocDirectory;
    protected File netbeansSourcesDirectory;
    protected File netbeansNbmDirectory;
    protected String forcedVersion;
    private File nexusIndexDirectory;
    protected ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactInstaller artifactInstaller;
    private ArtifactDeployer artifactDeployer;
    private ArtifactHandlerManager artifactHandlerManager;
    private ArtifactRepositoryFactory repositoryFactory;
    private static Pattern PATTERN_CLUSTER = Pattern.compile("([a-zA-Z]+)[0-9\\.]*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        File rootDir;
        this.getLog().info((CharSequence)"Populate repository with netbeans modules");
        Project antProject = this.registerNbmAntTasks();
        ArtifactRepository deploymentRepository = null;
        if (this.deployUrl != null) {
            DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
            deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository("netbeans", this.deployUrl, (ArtifactRepositoryLayout)layout, true);
        } else if (this.skipLocalInstall) {
            throw new MojoExecutionException("When skipping install to local repository, one shall define the deploUrl parameter");
        }
        if (this.netbeansInstallDirectory == null) {
            Input input = (Input)antProject.createTask("input");
            input.setMessage("Please enter netbeans installation directory:");
            input.setAddproperty("installDir");
            try {
                input.execute();
            }
            catch (BuildException e) {
                this.getLog().error((CharSequence)"Cannot run ant:input");
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            String prop = antProject.getProperty("installDir");
            this.netbeansInstallDirectory = new File(prop);
        }
        if (!(rootDir = this.netbeansInstallDirectory).exists()) {
            this.getLog().error((CharSequence)"Netbeans installation doesn't exist.");
            throw new MojoExecutionException("Netbeans installation doesn't exist.");
        }
        this.getLog().info((CharSequence)("Copying Netbeans artifacts from " + this.netbeansInstallDirectory));
        PathConvert convert = (PathConvert)antProject.createTask("pathconvert");
        convert.setPathSep(",");
        convert.setProperty("netbeansincludes");
        FileSet set = new FileSet();
        set.setDir(rootDir);
        set.createInclude().setName("**/modules/*.jar");
        set.createInclude().setName("*/core/*.jar");
        set.createInclude().setName("platform*/lib/*.jar");
        convert.createPath().addFileset(set);
        try {
            convert.execute();
        }
        catch (BuildException e) {
            this.getLog().error((CharSequence)"Cannot run ant:pathconvert");
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        String prop = antProject.getProperty("netbeansincludes");
        StringTokenizer tok = new StringTokenizer(prop, ",");
        HashMap<ModuleWrapper, Artifact> moduleDefinitions = new HashMap<ModuleWrapper, Artifact>();
        HashMap<String, ArrayList<ModuleWrapper>> clusters = new HashMap<String, ArrayList<ModuleWrapper>>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            File module = new File(token);
            String clust = module.getAbsolutePath().substring(rootDir.getAbsolutePath().length() + 1);
            clust = clust.substring(0, clust.indexOf(File.separator));
            ExamineManifest examinator = new ExamineManifest(this.getLog());
            examinator.setPopulateDependencies(true);
            examinator.setJarFile(module);
            examinator.checkFile();
            if (!examinator.isNetbeansModule()) continue;
            String artifact = module.getName().substring(0, module.getName().indexOf(".jar"));
            if ("boot".equals(artifact)) {
                artifact = "org-netbeans-bootstrap";
            }
            if ("core".equals(artifact)) {
                artifact = "org-netbeans-core-startup";
            }
            String version = this.forcedVersion == null ? examinator.getSpecVersion() : this.forcedVersion;
            String group = "org.netbeans." + (examinator.hasPublicPackages() ? "api" : "modules");
            Artifact art = this.createArtifact(artifact, version, group);
            ModuleWrapper wr = new ModuleWrapper(artifact, version, group, examinator, module);
            wr.setCluster(clust);
            moduleDefinitions.put(wr, art);
            ArrayList<ModuleWrapper> col = (ArrayList<ModuleWrapper>)clusters.get(clust);
            if (col == null) {
                col = new ArrayList<ModuleWrapper>();
                clusters.put(clust, col);
            }
            col.add(wr);
        }
        ArrayList<ModuleWrapper> wrapperList = new ArrayList<ModuleWrapper>(moduleDefinitions.keySet());
        int count = wrapperList.size() + 1;
        int index = 0;
        File javadocRoot = null;
        if (this.netbeansJavadocDirectory != null && !(javadocRoot = this.netbeansJavadocDirectory).exists()) {
            javadocRoot = null;
            throw new MojoExecutionException("The netbeansJavadocDirectory parameter doesn't point to an existing folder");
        }
        File sourceRoot = null;
        if (this.netbeansSourcesDirectory != null && !(sourceRoot = this.netbeansSourcesDirectory).exists()) {
            sourceRoot = null;
            throw new MojoExecutionException("The netbeansSourceDirectory parameter doesn't point to an existing folder");
        }
        File nbmRoot = null;
        if (this.netbeansNbmDirectory != null && !(nbmRoot = this.netbeansNbmDirectory).exists()) {
            nbmRoot = null;
            throw new MojoExecutionException("The nbmDirectory parameter doesn't point to an existing folder");
        }
        ArrayList<ExternalsWrapper> externals = new ArrayList<ExternalsWrapper>();
        IndexSearcher searcher = null;
        if (this.nexusIndexDirectory != null && this.nexusIndexDirectory.exists()) {
            try {
                FSDirectory nexusDir = FSDirectory.getDirectory((File)this.nexusIndexDirectory);
                IndexReader nexusReader = IndexReader.open((Directory)nexusDir);
                searcher = new IndexSearcher(nexusReader);
            }
            catch (IOException ex) {
                Logger.getLogger(PopulateRepositoryMojo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            for (Map.Entry elem : moduleDefinitions.entrySet()) {
                File zip;
                File zip2;
                ModuleWrapper man = (ModuleWrapper)elem.getKey();
                Artifact art = (Artifact)elem.getValue();
                this.getLog().info((CharSequence)("Processing " + ++index + "/" + count));
                File pom = this.createMavenProject(man, wrapperList, externals, searcher);
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(art, pom);
                art.addMetadata((ArtifactMetadata)metadata);
                File javadoc = null;
                Artifact javadocArt = null;
                if (javadocRoot != null && (zip2 = new File(javadocRoot, art.getArtifactId() + ".zip")).exists()) {
                    javadoc = zip2;
                    javadocArt = this.createAttachedArtifact(art, javadoc, "jar", "javadoc");
                }
                File source = null;
                Artifact sourceArt = null;
                if (sourceRoot != null && (zip = new File(sourceRoot, art.getArtifactId() + ".zip")).exists()) {
                    source = zip;
                    sourceArt = this.createAttachedArtifact(art, source, "jar", "sources");
                }
                File nbm = null;
                Artifact nbmArt = null;
                if (nbmRoot != null) {
                    File zip3 = new File(nbmRoot, art.getArtifactId() + ".nbm");
                    if (!zip3.exists()) {
                        zip3 = new File(nbmRoot, man.getCluster() + File.separator + art.getArtifactId() + ".nbm");
                    }
                    if (zip3.exists()) {
                        nbm = zip3;
                        nbmArt = this.createAttachedArtifact(art, nbm, "nbm-file", null);
                        if (nbmArt.getArtifactHandler().getExtension().equals("nbm-file")) {
                            nbmArt = this.createAttachedArtifact(art, nbm, "nbm", null);
                        }
                        assert (nbmArt.getArtifactHandler().getExtension().equals("nbm"));
                    }
                }
                File moduleJar = man.getFile();
                File moduleJarMinusCP = null;
                if (!man.getModuleManifest().getClasspath().isEmpty()) {
                    try {
                        moduleJarMinusCP = File.createTempFile(man.getArtifact(), ".jar");
                        moduleJarMinusCP.deleteOnExit();
                        FileInputStream is = new FileInputStream(moduleJar);
                        try {
                            FileOutputStream os = new FileOutputStream(moduleJarMinusCP);
                            try {
                                JarEntry entry;
                                JarInputStream jis = new JarInputStream(is);
                                Manifest mani = new Manifest(jis.getManifest());
                                mani.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
                                if (!man.deps.isEmpty()) {
                                    StringBuilder b = new StringBuilder();
                                    for (Dependency dep : man.deps) {
                                        if (b.length() > 0) {
                                            b.append(' ');
                                        }
                                        b.append(dep.getGroupId()).append(':').append(dep.getArtifactId()).append(':').append(dep.getVersion());
                                    }
                                    mani.getMainAttributes().putValue("Maven-Class-Path", b.toString());
                                } else {
                                    this.getLog().warn((CharSequence)("did not find any external artifacts for " + man.getModule()));
                                }
                                JarOutputStream jos = new JarOutputStream((OutputStream)os, mani);
                                while ((entry = jis.getNextJarEntry()) != null) {
                                    if (entry.getName().matches("META-INF/.+[.]SF")) {
                                        throw new IOException("cannot handle signed JARs");
                                    }
                                    jos.putNextEntry(entry);
                                    byte[] buf = new byte[(int)entry.getSize()];
                                    int read = jis.read(buf, 0, buf.length);
                                    if (read != buf.length) {
                                        throw new IOException("read wrong amount");
                                    }
                                    jos.write(buf);
                                }
                                jos.close();
                            }
                            finally {
                                ((OutputStream)os).close();
                            }
                        }
                        finally {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException x) {
                        this.getLog().warn((CharSequence)("Could not process " + moduleJar + ": " + x), (Throwable)x);
                        moduleJarMinusCP.delete();
                        moduleJarMinusCP = null;
                    }
                }
                try {
                    if (!this.skipLocalInstall) {
                        this.install(moduleJarMinusCP != null ? moduleJarMinusCP : moduleJar, art);
                        if (javadoc != null) {
                            this.install(javadoc, javadocArt);
                        }
                        if (source != null) {
                            this.install(source, sourceArt);
                        }
                        if (nbm != null) {
                            this.install(nbm, nbmArt);
                        }
                    }
                    try {
                        if (deploymentRepository == null) continue;
                        this.artifactDeployer.deploy(moduleJarMinusCP != null ? moduleJarMinusCP : moduleJar, art, deploymentRepository, this.localRepository);
                        if (javadoc != null) {
                            this.artifactDeployer.deploy(javadoc, javadocArt, deploymentRepository, this.localRepository);
                        }
                        if (source != null) {
                            this.artifactDeployer.deploy(source, sourceArt, deploymentRepository, this.localRepository);
                        }
                        if (nbm == null) continue;
                        this.artifactDeployer.deploy(nbm, nbmArt, deploymentRepository, this.localRepository);
                    }
                    catch (ArtifactDeploymentException ex) {
                        throw new MojoExecutionException("Error Deploying artifact", (Exception)((Object)ex));
                    }
                }
                finally {
                    if (moduleJarMinusCP == null) continue;
                    moduleJarMinusCP.delete();
                }
            }
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(PopulateRepositoryMojo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (externals.size() > 0) {
            index = 0;
            count = externals.size();
            for (ExternalsWrapper ex : externals) {
                Artifact art = this.createArtifact(ex.getArtifact(), ex.getVersion(), ex.getGroupid());
                this.getLog().info((CharSequence)("Processing external " + ++index + "/" + count));
                File pom = this.createExternalProject(ex);
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(art, pom);
                art.addMetadata((ArtifactMetadata)metadata);
                if (!this.skipLocalInstall) {
                    this.install(ex.getFile(), art);
                }
                try {
                    if (deploymentRepository == null) continue;
                    this.artifactDeployer.deploy(ex.getFile(), art, deploymentRepository, this.localRepository);
                }
                catch (ArtifactDeploymentException exc) {
                    throw new MojoExecutionException("Error Deploying artifact", (Exception)((Object)exc));
                }
            }
        }
        if (this.forcedVersion == null) {
            this.getLog().warn((CharSequence)"Version not specified, cannot create cluster POMs.");
        } else {
            for (Map.Entry elem : clusters.entrySet()) {
                String cluster = PopulateRepositoryMojo.stripClusterName((String)elem.getKey());
                Collection modules = (Collection)elem.getValue();
                this.getLog().info((CharSequence)("Processing cluster " + cluster));
                Artifact art = this.createClusterArtifact(cluster, this.forcedVersion);
                File pom = this.createClusterProject(art, modules);
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(art, pom);
                art.addMetadata((ArtifactMetadata)metadata);
                if (!this.skipLocalInstall) {
                    this.install(pom, art);
                }
                try {
                    if (deploymentRepository == null) continue;
                    this.artifactDeployer.deploy(pom, art, deploymentRepository, this.localRepository);
                }
                catch (ArtifactDeploymentException ex) {
                    throw new MojoExecutionException("Error Deploying artifact", (Exception)((Object)ex));
                }
            }
        }
    }

    void install(File file, Artifact art) throws MojoExecutionException {
        assert (this.localRepository != null);
        try {
            this.artifactInstaller.install(file, art, this.localRepository);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Error installing artifact", (Exception)((Object)e));
        }
    }

    Artifact createAttachedArtifact(Artifact primary, File file, String type, String classifier) {
        assert (type != null);
        ArtifactHandler handler = null;
        handler = this.artifactHandlerManager.getArtifactHandler(type);
        if (handler == null) {
            this.getLog().warn((CharSequence)("No artifact handler for " + type));
            handler = this.artifactHandlerManager.getArtifactHandler("jar");
        }
        AttachedArtifact artifact = new AttachedArtifact(primary, type, classifier, handler);
        artifact.setFile(file);
        artifact.setResolved(true);
        return artifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createMavenProject(ModuleWrapper wrapper, List<ModuleWrapper> wrapperList, List<ExternalsWrapper> externalsList, IndexSearcher searcher) {
        String cp;
        Model mavenModel = new Model();
        mavenModel.setGroupId(wrapper.getGroup());
        mavenModel.setArtifactId(wrapper.getArtifact());
        mavenModel.setVersion(wrapper.getVersion());
        mavenModel.setPackaging("jar");
        mavenModel.setModelVersion("4.0.0");
        ExamineManifest man = wrapper.getModuleManifest();
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        if (!man.getDependencyTokens().isEmpty()) {
            for (String elem : man.getDependencyTokens()) {
                ModuleWrapper wr = new ModuleWrapper(elem);
                int index = wrapperList.indexOf(wr);
                if (index > -1) {
                    wr = wrapperList.get(index);
                    Dependency dep = new Dependency();
                    dep.setArtifactId(wr.getArtifact());
                    dep.setGroupId(wr.getGroup());
                    dep.setVersion(wr.getVersion());
                    dep.setType("jar");
                    if (wrapper.getModuleManifest().hasPublicPackages() && !wr.getModuleManifest().hasPublicPackages()) {
                        dep.setScope("runtime");
                    }
                    deps.add(dep);
                    continue;
                }
                this.getLog().warn((CharSequence)("No module found for dependency '" + elem + "'"));
            }
        }
        if (!(cp = wrapper.getModuleManifest().getClasspath()).isEmpty()) {
            StringTokenizer tok = new StringTokenizer(cp);
            while (tok.hasMoreTokens()) {
                String path = tok.nextToken();
                File f = new File(wrapper.getFile().getParentFile(), path);
                if (!f.exists()) continue;
                FileInputStream fis = null;
                DigestOutputStream os = null;
                boolean added = false;
                if (searcher != null) {
                    try {
                        Document doc;
                        Field idField;
                        MessageDigest shaDig = MessageDigest.getInstance("SHA1");
                        fis = new FileInputStream(f);
                        os = new DigestOutputStream(new NullOutputStream(), shaDig);
                        IOUtil.copy((InputStream)fis, (OutputStream)os);
                        IOUtil.close((InputStream)fis);
                        IOUtil.close((OutputStream)os);
                        String sha = PopulateRepositoryMojo.encode(shaDig.digest());
                        TermQuery q = new TermQuery(new Term("1", sha));
                        Hits hits = searcher.search((Query)q);
                        if (hits.length() == 1 && (idField = (doc = hits.doc(0)).getField("u")) != null) {
                            String id = idField.stringValue();
                            String[] splits = StringUtils.split((String)id, (String)"|");
                            Dependency dep = new Dependency();
                            dep.setArtifactId(splits[1]);
                            dep.setGroupId(splits[0]);
                            dep.setVersion(splits[2]);
                            dep.setType("jar");
                            if (splits.length > 3 && !"NA".equals(splits[3])) {
                                dep.setClassifier(splits[3]);
                            }
                            deps.add(dep);
                            added = true;
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
                if (added) continue;
                ExternalsWrapper ex = new ExternalsWrapper();
                ex.setFile(f);
                String artId = f.getName();
                if (artId.endsWith(".jar")) {
                    artId = artId.substring(0, artId.length() - ".jar".length());
                }
                ex.setVersion(wrapper.getVersion());
                ex.setArtifact(artId);
                ex.setGroupid("org.netbeans.external");
                externalsList.add(ex);
                Dependency dep = new Dependency();
                dep.setArtifactId(artId);
                dep.setGroupId("org.netbeans.external");
                dep.setVersion(wrapper.getVersion());
                dep.setType("jar");
                deps.add(dep);
            }
        }
        wrapper.deps = deps;
        mavenModel.setDependencies(deps);
        OutputStreamWriter writer = null;
        File fil = null;
        try {
            MavenXpp3Writer xpp = new MavenXpp3Writer();
            fil = File.createTempFile("maven", ".pom");
            fil.deleteOnExit();
            writer = new FileWriter(fil);
            xpp.write((Writer)writer, mavenModel);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
            }
        }
        return fil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File createExternalProject(ExternalsWrapper wrapper) {
        Model mavenModel = new Model();
        mavenModel.setGroupId(wrapper.getGroupid());
        mavenModel.setArtifactId(wrapper.getArtifact());
        mavenModel.setVersion(wrapper.getVersion());
        mavenModel.setPackaging("jar");
        mavenModel.setModelVersion("4.0.0");
        mavenModel.setName("Maven definition for " + wrapper.getFile().getName() + " - external part of NetBeans module.");
        mavenModel.setDescription("POM and identification for artifact that was not possible to uniquely identify as a maven dependency.");
        OutputStreamWriter writer = null;
        File fil = null;
        try {
            MavenXpp3Writer xpp = new MavenXpp3Writer();
            fil = File.createTempFile("maven", ".pom");
            fil.deleteOnExit();
            writer = new FileWriter(fil);
            xpp.write((Writer)writer, mavenModel);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
            }
        }
        return fil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createClusterProject(Artifact cluster, Collection<ModuleWrapper> mods) {
        Model mavenModel = new Model();
        mavenModel.setGroupId(cluster.getGroupId());
        mavenModel.setArtifactId(cluster.getArtifactId());
        mavenModel.setVersion(cluster.getVersion());
        mavenModel.setPackaging("pom");
        mavenModel.setModelVersion("4.0.0");
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (ModuleWrapper wr : mods) {
            Dependency dep = new Dependency();
            dep.setArtifactId(wr.getArtifact());
            dep.setGroupId(wr.getGroup());
            dep.setVersion(wr.getVersion());
            dep.setType("nbm-file");
            deps.add(dep);
        }
        mavenModel.setDependencies(deps);
        FileWriter writer = null;
        File fil = null;
        try {
            MavenXpp3Writer xpp = new MavenXpp3Writer();
            fil = File.createTempFile("maven", ".pom");
            fil.deleteOnExit();
            writer = new FileWriter(fil);
            xpp.write((Writer)writer, mavenModel);
            IOUtil.close((Writer)writer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            IOUtil.close(writer);
        }
        return fil;
    }

    Artifact createArtifact(String artifact, String version, String group) {
        return this.artifactFactory.createBuildArtifact(group, artifact, version, "jar");
    }

    private Artifact createClusterArtifact(String artifact, String version) {
        return this.artifactFactory.createBuildArtifact("org.netbeans.cluster", artifact, version, "pom");
    }

    static String stripClusterName(String key) {
        Matcher m = PATTERN_CLUSTER.matcher(key);
        if (m.matches()) {
            return m.group(1);
        }
        return key;
    }

    private static String encode(byte[] binaryData) {
        if (binaryData.length != 16 && binaryData.length != 20) {
            int bitLength = binaryData.length * 8;
            throw new IllegalArgumentException("Unrecognised length for binary data: " + bitLength + " bits");
        }
        String retValue = "";
        for (int i = 0; i < binaryData.length; ++i) {
            String t = Integer.toHexString(binaryData[i] & 0xFF);
            retValue = t.length() == 1 ? retValue + "0" + t : retValue + t;
        }
        return retValue.trim();
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    private class ModuleWrapper {
        ExamineManifest man;
        private String artifact;
        private String version;
        private String group;
        private File file;
        private String cluster;
        String module;
        List<Dependency> deps;

        public ModuleWrapper(String module) {
            this.module = module;
        }

        public ModuleWrapper(String art, String ver, String grp, ExamineManifest manifest, File fil) {
            this.man = manifest;
            this.artifact = art;
            this.version = ver;
            this.group = grp;
            this.file = fil;
        }

        public int hashCode() {
            return this.getModule().hashCode();
        }

        public boolean equals(Object obj) {
            return this.getModule().equals(((ModuleWrapper)obj).getModule());
        }

        public String getModule() {
            return this.module != null ? this.module : this.getModuleManifest().getModule();
        }

        public ExamineManifest getModuleManifest() {
            return this.man;
        }

        private String getArtifact() {
            return this.artifact;
        }

        private String getVersion() {
            return this.version;
        }

        private String getGroup() {
            return this.group;
        }

        private File getFile() {
            return this.file;
        }

        void setCluster(String clust) {
            this.cluster = clust;
        }

        String getCluster() {
            return this.cluster;
        }
    }

    private class ExternalsWrapper {
        private File file;
        private String artifact;
        private String groupid;
        private String version;

        private ExternalsWrapper() {
        }

        public String getArtifact() {
            return this.artifact;
        }

        public void setArtifact(String artifact) {
            this.artifact = artifact;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getGroupid() {
            return this.groupid;
        }

        public void setGroupid(String groupid) {
            this.groupid = groupid;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

