/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:nbm-maven-plugin:3.6", 0);
        this.append(sb, "", 0);
        this.append(sb, "NBM Maven Plugin", 0);
        this.append(sb, "Maven plugin for creating NetBeans modules. It defines a custom lifecycle called 'nbm'. During packaging, the module JAR is enhanced with NetBeans-specific manifest entries and, along with other required files, packed into a *.nbm file, ready for distribution. Additionally the plugin provides aggregator goals to create an update site or cluster for your module projects.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 12 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "autoupdate".equals(this.goal)) {
            this.append(sb, "nbm:autoupdate", 0);
            this.append(sb, "Create the Netbeans autopdate site definition.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "distBase (Default: .)", 2);
                this.append(sb, "A custom distribution base for the nbms in the update site. If NOT defined, the update site will use a simple relative URL, which is generally what you want. Defining it as 'auto' will pick up the distribution URL from each NBM, which is generally wrong.\nThe value is either a direct http protocol based URL that points to the location under which all nbm files are located, or\n\nallows to create an update site based on maven repository content. The resulting autoupdate site document can be uploaded as tar.gz to repository as well as attached artifact to the 'nbm-application' project.\nFormat: id::layout::url same as in maven-deploy-plugin\nwith the 'default' and 'legacy' layouts. (maven2 vs maven1 layout)\nIf the value doesn't contain :: characters, it's assumed to be the flat structure and the value is just the URL.\n", 3);
                this.append(sb, "Expression: ${maven.nbm.customDistBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileName (Default: updates.xml)", 2);
                this.append(sb, "autoupdate site xml file name.", 3);
                this.append(sb, "Expression: ${maven.nbm.updatesitexml}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "output directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "branding".equals(this.goal)) {
            this.append(sb, "nbm:branding", 0);
            this.append(sb, "Package branding resources for NetBeans platform/IDE based application. The format of branding resources is the same as in NetBeans Ant-based projects. The src/main/nbm-branding folder of the project is assumed to contain the branding content. Within the directory, the following folder structure is assumed:\n-\t1. pick the IDE/platform module which contents you want to brand. eg. org-openide-windows.jar\n-\t2. locate the jar within the IDE/platform installation and it's cluster, eg. modules/org-openide-windows.jar\n-\t3. create the same folder structure in src/main/nbm-branding, make folder with the module's jar name as well. eg. create folder by name modules/org-openide-windows.jar\n-\t4. within that folder place your branding modifications at the same location, as if they were withn the jar, eg. org/openide/windows/ui/Bundle.properties and place the changed bundle keys there.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "brandingSources", 2);
                this.append(sb, "Location of the branded resources.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}/src/main/nbm-branding", 3);
                this.append(sb, "", 0);
                this.append(sb, "brandingToken", 2);
                this.append(sb, "The branding token used by the application. Required unless nbmBuildDir does not exist and the mojo is thus skipped.", 3);
                this.append(sb, "Expression: ${netbeans.branding.token}", 3);
                this.append(sb, "", 0);
                this.append(sb, "cluster (Default: extra)", 2);
                this.append(sb, "cluster of the branding.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "nbmBuildDir", 2);
                this.append(sb, "directory where the the binary content is created.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}/nbm", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "cluster".equals(this.goal)) {
            this.append(sb, "nbm:cluster", 0);
            this.append(sb, "Create the Netbeans module clusters from reactor", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "defaultCluster (Default: extra)", 2);
                this.append(sb, "default cluster value for reactor projects without cluster information, typically OSGi bundles", 3);
                this.append(sb, "", 0);
                this.append(sb, "nbmBuildDir (Default: ${project.build.directory}/netbeans_clusters)", 2);
                this.append(sb, "directory where the the netbeans cluster will be created.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "cluster-app".equals(this.goal)) {
            this.append(sb, "nbm:cluster-app", 0);
            this.append(sb, "Create the Netbeans module clusters/application for the 'nbm-application' packaging projects", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "Directory which contains the executables that will be copied to the final application's bin/ directory. Please note that the name of the executables shall generally match the brandingToken parameter. Otherwise the application can be wrongly branded.", 3);
                this.append(sb, "Expression: ${netbeans.bin.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "brandingToken", 2);
                this.append(sb, "The branding token for the application based on NetBeans platform.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${netbeans.branding.token}", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultCluster (Default: extra)", 2);
                this.append(sb, "If the depending NBM file doesn't contain any application cluster information, use this value as default location for such module NBMs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "etcClustersFile", 2);
                this.append(sb, "Optional path to custom etc/${brandingToken}.clusters file. If not defined, a default one will be generated.", 3);
                this.append(sb, "Expression: ${netbeans.clusters.file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "etcConfFile", 2);
                this.append(sb, "Optional path to custom etc/${brandingToken}.conf file. If not defined, a default template will be used.", 3);
                this.append(sb, "Expression: ${netbeans.conf.file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "output directory where the the netbeans application will be created.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "useOSGiDependencies (Default: false)", 2);
                this.append(sb, "Process OSGi dependencies. These will all go into defaultCluster.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "nbm:help", 0);
            this.append(sb, "Display help information on nbm-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0nbm:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "manifest".equals(this.goal)) {
            this.append(sb, "nbm:manifest", 0);
            this.append(sb, "Goal for generating NetBeans module system specific manifest entries, part of 'nbm' lifecycle/packaging. In order to have the generated manifest picked up by the maven-jar-plugin, one shall add the following configuration snippet to maven-jar-plugin.\n<plugin>\n<groupId>org.apache.maven.plugins</groupId>\n<artifactId>maven-jar-plugin</artifactId>\n<version>2.2</version>\n<configuration>\n<useDefaultManifestFile>true</useDefaultManifestFile>\n</configuration>\n</plugin>\n\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "descriptor (Default: ${basedir}/src/main/nbm/module.xml)", 2);
                this.append(sb, "a netbeans module descriptor containing dependency information and more", 3);
                this.append(sb, "", 0);
                this.append(sb, "nbmBuildDir (Default: ${project.build.directory}/nbm)", 2);
                this.append(sb, "Netbeans module assembly build directory. directory where the the netbeans jar and nbm file get constructed.", 3);
                this.append(sb, "Expression: ${maven.nbm.buildDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "nbmJavahelpSource (Default: ${basedir}/src/main/javahelp)", 2);
                this.append(sb, "The location of JavaHelp sources for the project. The documentation itself is expected to be in the directory structure based on codenamebase of the module. eg. if your codenamebase is 'org.netbeans.modules.apisupport', then the actual docs files shall go to ${basedir}/src/main/javahelp/org/netbeans/modules/apisupport/docs. Obsolete as of NetBeans 7.0 with @HelpSetRegistration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "publicPackages", 2);
                this.append(sb, "A list of module's public packages. If not defined, no packages are exported as public. Allowed values are single package names or package names ending with .* which represent the package and all subpackages.\nEg. 'org.kleint.milos.api' designates just the one package, while 'org.kleint.milos.spi.*' denotes the spi package an all it's subpackages.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceManifestFile (Default: ${basedir}/src/main/nbm/manifest.mf)", 2);
                this.append(sb, "Path to manifest file that will be used as base for the", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "useOSGiDependencies (Default: false)", 2);
                this.append(sb, "When encountering an OSGi bundle among dependencies, the plugin will generate a direct dependency on the bundle and will not include the bundle's jar into the nbm. Will only work with Netbeans 6.9+ runtime. Therefore it is off by default. WARNING: Additionally existing applications/modules need to check modules wrapping external libraries for library jars that are also OSGi bundles. Such modules will no longer include the OSGi bundles as part of the module but will include a modular dependency on the bundle. Modules depending on these old wrappers shall depend directly on the bundle, eventually rendering the old library wrapper module obsolete.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyRuntime (Default: fail)", 2);
                this.append(sb, "Verify the runtime NetBeans module dependencies and Class-Path items generated from Maven dependencies. The check is done by matcing classes used in current project. Allowed values for the parameter are 'fail', 'warn' and 'skip'. The default is 'fail' in which case the validation failure results in a failed build, in the vast majority of cases the module would fail at runtime anyway.", 3);
                this.append(sb, "Expression: ${maven.nbm.verify}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "nbm".equals(this.goal)) {
            this.append(sb, "nbm:nbm", 0);
            this.append(sb, "Create the Netbeans module artifact (nbm file), part of 'nbm' lifecycle/packaging.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "cluster (Default: extra)", 2);
                this.append(sb, "Netbeans module's cluster. Replaces the cluster element in module descriptor.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "descriptor (Default: ${basedir}/src/main/nbm/module.xml)", 2);
                this.append(sb, "a netbeans module descriptor containing dependency information and more..", 3);
                this.append(sb, "", 0);
                this.append(sb, "distributionUrl", 2);
                this.append(sb, "Distribution base URL for the NBM at runtime deployment time. Note: Uselfulness of the parameter is questionable, it doesn't allow for mirrors and usually when downloading the nbm, one alreayd knows the location anyway. Please note that the netbeans.org Ant scripts put a dummy url here. The actual correct value used when constructing update site is explicitly set there. The general assuption there is that all modules from one update center come from one base URL.\nThe value is either a direct http protocol based URL that points to the location under which nbm file will be located, or\n\nit allows to create an update site based on maven repository content. The later created autoupdate site document can use this information and compose the application from one or multiple maven repositories.\nFormat: id::layout::url same as in maven-deploy-plugin\nwith the 'default' and 'legacy' layouts. (maven2 vs maven1 layout)\nIf the value doesn't contain :: characters, it's assumed to be the flat structure and the value is just the URL.\n", 3);
                this.append(sb, "Expression: ${maven.nbm.distributionURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The character encoding scheme to be applied when filtering nbm resources.", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName", 2);
                this.append(sb, "Name of the jar packaged by the jar:jar plugin", 3);
                this.append(sb, "Expression: ${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "keystore location for signing the nbm file", 3);
                this.append(sb, "Expression: ${keystore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystorealias", 2);
                this.append(sb, "keystore alias", 3);
                this.append(sb, "Expression: ${keystorealias}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystorepassword", 2);
                this.append(sb, "keystore password", 3);
                this.append(sb, "Expression: ${keystorepass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "nbmBuildDir (Default: ${project.build.directory}/nbm)", 2);
                this.append(sb, "Netbeans module assembly build directory. directory where the the netbeans jar and nbm file get constructed.", 3);
                this.append(sb, "Expression: ${maven.nbm.buildDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "nbmJavahelpSource (Default: ${basedir}/src/main/javahelp)", 2);
                this.append(sb, "The location of JavaHelp sources for the project. The documentation itself is expected to be in the directory structure based on codenamebase of the module. eg. if your codenamebase is 'org.netbeans.modules.apisupport', then the actual docs files shall go to ${basedir}/src/main/javahelp/org/netbeans/modules/apisupport/docs. Obsolete as of NetBeans 7.0 with @HelpSetRegistration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nbmResources", 2);
                this.append(sb, "The list of nbmResources we want to include in the nbm file (not in module jar, but as external content within the nbm. Replaces the same configuration in the module descriptor file. For example to include external dll files in the nbm: <nbmResource>\n\u00a0\u00a0<directory>src/main/libs</directory>\n\u00a0\u00a0<targetPath>lib</targetPath>\n\u00a0\u00a0<includes>\n\u00a0\u00a0\u00a0\u00a0<include>*.dll</include>\n\u00a0\u00a0\u00a0\u00a0<include>*.so</include>\n\u00a0\u00a0</includes>\n</nbmResource>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipNbm (Default: false)", 2);
                this.append(sb, "Boolean parameter denoting if creation of NBM file shall be skipped or not. If skipped, just the expanded directory for cluster is created", 3);
                this.append(sb, "Expression: ${maven.nbm.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "populate-repository".equals(this.goal)) {
            this.append(sb, "nbm:populate-repository", 0);
            this.append(sb, "A goal for identifying netbeans modules from the installation and populating the local repository with them. Optionally you can also deploy to a remote repository.\nIf you are looking for an existing remote repository for netbeans artifacts, check out http://bits.netbeans.org/maven2/, it contains API artifacts for multiple releases.\n\nSee this HOWTO on how to generate the NetBeans binaries required by this goal.\n\nCompatibility Note: The 3.0+ version puts all unrecognized, non-module, 3rd party jars in the org.netbeans.external group and adds them as dependencies to respective modules. That can cause backward incompatibility with earlier versions which generated incomplete (different) maven metadata.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deployUrl", 2);
                this.append(sb, "an url where to deploy the netbeans artifacts. Optional, if not specified, the artifacts will be only installed in local repository, if you need to give credentials to access remote repo, the id of the server is hardwired to 'netbeans'.", 3);
                this.append(sb, "Expression: ${deployUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "forcedVersion", 2);
                this.append(sb, "Optional parameter, when specified, will force all modules to have the designated version. Good when depending on releases. Then you would for example specify RELEASE50 in this parameter and all modules get this version in the repository. If not defined, the maven version is derived from the OpenIDE-Module-Specification-Version manifest attribute.\nHighly Recommended!\n", 3);
                this.append(sb, "Expression: ${forcedVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "netbeansInstallDirectory", 2);
                this.append(sb, "Location of netbeans installation", 3);
                this.append(sb, "Expression: ${netbeansInstallDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "netbeansJavadocDirectory", 2);
                this.append(sb, "If you want to install/deploy also netbeans api javadocs, download the javadoc zip file from netbeans.org expand it to a directory, it should contain multiple zip files. Define this parameter as absolute path to the zip files folder.", 3);
                this.append(sb, "Expression: ${netbeansJavadocDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "netbeansNbmDirectory", 2);
                this.append(sb, "If defined, will match the nbm files found in the designated folder with the modules and upload the nbm file next to the module jar in local and remote repositories. Assumes a folder with <code-name-base>.nbm files containing nbm files for modules.", 3);
                this.append(sb, "Expression: ${netbeansNbmDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "netbeansSourcesDirectory", 2);
                this.append(sb, "Assumes a folder with <code-name-base>.zip files containing sources for modules.", 3);
                this.append(sb, "Expression: ${netbeansSourcesDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "nexusIndexDirectory", 2);
                this.append(sb, "Optional parameter, when specified it shall point to a directory containing a Nexus Lucene index. This index will be used to find external libraries that are referenced by NetBeans modules and populate the POM metadata with correct dependencies. Any dependencies not found this way, will be generated a unique id under the org.netbeans.external groupId.\nThe Nexus Lucene index zip file for central repository can be found here: http:\n/repo1.maven.org/maven2/.index/nexus-maven-repository-index.zip Unzip it to a directory and use this parameter to point to it.", 3);
                this.append(sb, "Expression: ${nexusIndexDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipLocalInstall (Default: false)", 2);
                this.append(sb, "Optional parameter, by default the generated metadata is installed in local repository. Setting this parameter to false will avoid installing the bits. Only meaningful together with a defined 'deployUrl' parameter.", 3);
                this.append(sb, "Expression: ${skipInstall}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run-ide".equals(this.goal)) {
            this.append(sb, "nbm:run-ide", 0);
            this.append(sb, "Run NetBeans IDE with additional custom module clusters, to be used in conjunction with nbm:cluster.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalArguments", 2);
                this.append(sb, "additional command line arguments. Eg. -J-Xdebug -J-Xnoagent -J-Xrunjdwp:transport=dt_socket,suspend=n,server=n,address=8888 can be used to debug the IDE.", 3);
                this.append(sb, "Expression: ${netbeans.run.params}", 3);
                this.append(sb, "", 0);
                this.append(sb, "clusterBuildDir (Default: ${project.build.directory}/netbeans_clusters)", 2);
                this.append(sb, "directory where the module(s)' netbeans cluster(s) are located. is related to nbm:cluster goal.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "netbeansInstallation", 2);
                this.append(sb, "directory where the the netbeans platform/IDE installation is, denotes the root directory of netbeans installation.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${netbeans.installation}", 3);
                this.append(sb, "", 0);
                this.append(sb, "netbeansUserdir (Default: ${project.build.directory}/userdir)", 2);
                this.append(sb, "netbeans user directory for the executed instance.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${netbeans.userdir}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run-platform".equals(this.goal)) {
            this.append(sb, "nbm:run-platform", 0);
            this.append(sb, "Run a branded application on top of NetBeans Platform. To be used with projects with nbm-application packaging only and the project needs to be built first.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalArguments", 2);
                this.append(sb, "additional command line arguments. Eg. -J-Xdebug -J-Xnoagent -J-Xrunjdwp:transport=dt_socket,suspend=n,server=n,address=8888 can be used to debug the IDE.", 3);
                this.append(sb, "Expression: ${netbeans.run.params}", 3);
                this.append(sb, "", 0);
                this.append(sb, "brandingToken", 2);
                this.append(sb, "The branding token for the application based on NetBeans platform.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${netbeans.branding.token}", 3);
                this.append(sb, "", 0);
                this.append(sb, "netbeansUserdir (Default: ${project.build.directory}/userdir)", 2);
                this.append(sb, "netbeans user directory for the executed instance.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${netbeans.userdir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "output directory where the the netbeans application is created.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "standalone-zip".equals(this.goal)) {
            this.append(sb, "nbm:standalone-zip", 0);
            this.append(sb, "Create a standalone application out of the composed clusters of nbm-application", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "brandingToken", 2);
                this.append(sb, "The branding token for the application based on NetBeans platform.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${netbeans.branding.token}", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName", 2);
                this.append(sb, "Name of the jar packaged by the jar:jar plugin", 3);
                this.append(sb, "Expression: ${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "output directory where the the netbeans application will be created.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "webstart-app".equals(this.goal)) {
            this.append(sb, "nbm:webstart-app", 0);
            this.append(sb, "Create webstartable binaries for a 'nbm-application'.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalArguments", 2);
                this.append(sb, "additional command line arguments. Eg. -J-Xdebug -J-Xnoagent -J-Xrunjdwp:transport=dt_socket,suspend=n,server=n,address=8888 can be used to debug the IDE.", 3);
                this.append(sb, "Expression: ${netbeans.run.params}", 3);
                this.append(sb, "", 0);
                this.append(sb, "brandingToken", 2);
                this.append(sb, "The branding token for the application based on NetBeans platform.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${netbeans.branding.token}", 3);
                this.append(sb, "", 0);
                this.append(sb, "codebase", 2);
                this.append(sb, "Codebase value within *.jnlp files. Defining this parameter is generally a bad idea.", 3);
                this.append(sb, "Expression: ${nbm.webstart.codebase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "destinationFile (Default: ${project.build.directory}/${project.artifactId}-${project.version}-jnlp.war)", 2);
                this.append(sb, "Ready-to-deploy WAR containing application in JNLP packaging.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "keystore location for signing the nbm file", 3);
                this.append(sb, "Expression: ${keystore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystorealias", 2);
                this.append(sb, "keystore alias", 3);
                this.append(sb, "Expression: ${keystorealias}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystorepassword", 2);
                this.append(sb, "keystore password", 3);
                this.append(sb, "Expression: ${keystorepass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystoretype", 2);
                this.append(sb, "keystore type", 3);
                this.append(sb, "Expression: ${keystoretype}", 3);
                this.append(sb, "", 0);
                this.append(sb, "masterJnlpFile", 2);
                this.append(sb, "A custom master JNLP file. If not defined, the default one is used. The following expressions can be used within the file and will be replaced when generating content.\n-\t${jnlp.resources}\n-\t${jnlp.codebase} - the 'codebase' parameter value is passed in.\n-\t${app.name}\n-\t${app.title}\n-\t${app.vendor}\n-\t${app.description}\n-\t${branding.token} - the 'brandingToken' parameter value is passed in.\n-\t${netbeans.jnlp.fixPolicy}\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "masterJnlpFileName", 2);
                this.append(sb, "The basename (minus .jnlp extension) of the master JNLP file in the output. This file will be the entry point for javaws. Defaults to the branding token.", 3);
                this.append(sb, "Expression: ${master.jnlp.file.name}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "output directory where the the netbeans application will be created.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "processJarVersions (Default: false)", 2);
                this.append(sb, "If set true, build-jnlp target creates versioning info in jnlp descriptors and version.xml files. This allows for incremental updates of Webstart applications, but requires download via JnlpDownloadServlet Defaults to false, which means versioning info is not generated (see http://java.sun.com/j2se/1.5.0/docs/guide/javaws/developersguide/downloadservletguide.html#resources).", 3);
                this.append(sb, "Expression: ${nbm.webstart.versions}", 3);
                this.append(sb, "", 0);
                this.append(sb, "webstartClassifier (Default: webstart)", 2);
                this.append(sb, "Artifact Classifier to use for the webstart distributable zip file.", 3);
                this.append(sb, "Expression: ${nbm.webstart.classifier}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

