/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.codehaus.mojo.nbm.CollectLibrariesNodeVisitor;
import org.codehaus.mojo.nbm.ExamineManifest;
import org.codehaus.mojo.nbm.model.Dependency;
import org.codehaus.mojo.nbm.model.NetbeansModule;
import org.codehaus.mojo.nbm.model.io.xpp3.NetbeansModuleXpp3Reader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractNbmMojo
extends AbstractMojo {
    protected final Project registerNbmAntTasks() {
        Project antProject = new Project();
        antProject.init();
        Taskdef taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setClassname("org.netbeans.nbbuild.MakeListOfNBM");
        taskdef.setName("genlist");
        taskdef.execute();
        taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setClassname("org.netbeans.nbbuild.MakeNBM");
        taskdef.setName("makenbm");
        taskdef.execute();
        taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setClassname("org.netbeans.nbbuild.MakeUpdateDesc");
        taskdef.setName("updatedist");
        taskdef.execute();
        taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setClassname("org.netbeans.nbbuild.CreateModuleXML");
        taskdef.setName("createmodulexml");
        taskdef.execute();
        taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setClassname("org.netbeans.nbbuild.JHIndexer");
        taskdef.setName("jhindexer");
        taskdef.execute();
        return antProject;
    }

    static final boolean matchesLibrary(Artifact artifact, List<String> libraries, ExamineManifest depExaminator, Log log, boolean useOsgiDependencies) {
        String artId = artifact.getArtifactId();
        String grId = artifact.getGroupId();
        String id = grId + ":" + artId;
        boolean explicit = libraries.remove(id);
        if (explicit) {
            log.debug((CharSequence)(id + " included as module library, explicitly declared in module descriptor."));
            return explicit;
        }
        if ("provided".equals(artifact.getScope()) || "system".equals(artifact.getScope())) {
            log.debug((CharSequence)(id + " omitted as module library, has scope 'provided/system'"));
            return false;
        }
        if ("nbm".equals(artifact.getType())) {
            return false;
        }
        if (depExaminator.isNetbeansModule() || useOsgiDependencies && depExaminator.isOsgiBundle()) {
            return false;
        }
        log.debug((CharSequence)(id + " included as module library, squeezed through all the filters."));
        return true;
    }

    static Dependency resolveNetbeansDependency(Artifact artifact, List<Dependency> deps, ExamineManifest manifest, Log log) {
        Dependency dep;
        String artId = artifact.getArtifactId();
        String grId = artifact.getGroupId();
        String id = grId + ":" + artId;
        for (Dependency dep2 : deps) {
            if (!id.equals(dep2.getId())) continue;
            if (manifest.isNetbeansModule()) {
                return dep2;
            }
            if (dep2.getExplicitValue() != null) {
                return dep2;
            }
            log.warn((CharSequence)(id + " declared as module dependency in descriptor, but not a NetBeans module"));
            return null;
        }
        if ("nbm".equals(artifact.getType())) {
            dep = new Dependency();
            dep.setId(id);
            dep.setType("spec");
            log.debug((CharSequence)("Adding nbm module dependency - " + id));
            return dep;
        }
        if (manifest.isNetbeansModule()) {
            dep = new Dependency();
            dep.setId(id);
            dep.setType("spec");
            log.debug((CharSequence)("Adding direct NetBeans module dependency - " + id));
            return dep;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final NetbeansModule readModuleDescriptor(File descriptor) throws MojoExecutionException {
        NetbeansModule netbeansModule;
        if (descriptor == null) {
            throw new MojoExecutionException("The module descriptor has to be configured.");
        }
        if (!descriptor.exists()) {
            throw new MojoExecutionException("The module descriptor is missing: '" + descriptor + "'.");
        }
        FileReader r = null;
        try {
            NetbeansModule module;
            r = new FileReader(descriptor);
            NetbeansModuleXpp3Reader reader = new NetbeansModuleXpp3Reader();
            netbeansModule = module = reader.read(r);
        }
        catch (IOException exc) {
            try {
                throw new MojoExecutionException("Error while reading module descriptor '" + descriptor + "'.", (Exception)exc);
                catch (XmlPullParserException xml) {
                    throw new MojoExecutionException("Error while reading module descriptor '" + descriptor + "'.", (Exception)((Object)xml));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(r);
                throw throwable;
            }
        }
        IOUtil.close((Reader)r);
        return netbeansModule;
    }

    protected final NetbeansModule createDefaultDescriptor(MavenProject project, boolean log) {
        if (log) {
            this.getLog().info((CharSequence)"No Module Descriptor defined, trying to fallback to generated values:");
        }
        NetbeansModule module = new NetbeansModule();
        module.setAuthor("Nobody");
        module.setCluster("maven");
        if (log) {
            this.getLog().info((CharSequence)("   Cluster:" + module.getCluster()));
        }
        String codename = project.getGroupId() + "." + project.getArtifactId();
        codename = codename.replaceAll("-", ".");
        module.setCodeNameBase(codename);
        if (log) {
            this.getLog().info((CharSequence)("   Codenamebase:" + module.getCodeNameBase()));
        }
        module.setModuleType("normal");
        if (log) {
            this.getLog().info((CharSequence)("   Type:" + module.getModuleType()));
        }
        module.setRequiresRestart(false);
        return module;
    }

    static List<Artifact> getLibraryArtifacts(DependencyNode treeRoot, NetbeansModule module, List<Artifact> runtimeArtifacts, Map<Artifact, ExamineManifest> examinerCache, Log log, boolean useOsgiDependencies) throws MojoExecutionException {
        ArrayList<Artifact> include = new ArrayList<Artifact>();
        if (module != null) {
            ArrayList<String> librList = new ArrayList<String>();
            if (module.getLibraries() != null) {
                librList.addAll(module.getLibraries());
            }
            CollectLibrariesNodeVisitor visitor = new CollectLibrariesNodeVisitor(librList, runtimeArtifacts, examinerCache, log, treeRoot, useOsgiDependencies);
            treeRoot.accept((DependencyNodeVisitor)visitor);
            include.addAll(visitor.getArtifacts());
        }
        return include;
    }

    static List<ModuleWrapper> getModuleDependencyArtifacts(DependencyNode treeRoot, NetbeansModule module, MavenProject project, Map<Artifact, ExamineManifest> examinerCache, List<Artifact> libraryArtifacts, Log log, boolean useOsgiDependencies) throws MojoExecutionException {
        ArrayList<ModuleWrapper> include = new ArrayList<ModuleWrapper>();
        if (module != null) {
            List<Dependency> deps = module.getDependencies();
            List artifacts = project.getCompileArtifacts();
            for (Artifact artifact : artifacts) {
                ModuleWrapper wr;
                Dependency dep;
                if (libraryArtifacts.contains(artifact)) continue;
                ExamineManifest depExaminator = examinerCache.get(artifact);
                if (depExaminator == null) {
                    depExaminator = new ExamineManifest(log);
                    depExaminator.setArtifactFile(artifact.getFile());
                    depExaminator.checkFile();
                    examinerCache.put(artifact, depExaminator);
                }
                if ((dep = AbstractNbmMojo.resolveNetbeansDependency(artifact, deps, depExaminator, log)) != null) {
                    wr = new ModuleWrapper();
                    wr.dependency = dep;
                    wr.artifact = artifact;
                    wr.transitive = false;
                    if (depExaminator.isNetbeansModule() && artifact.getDependencyTrail().size() > 2) {
                        log.debug((CharSequence)(artifact.getId() + " omitted as NetBeans module dependency, not a direct one. Declare it in the pom for inclusion."));
                        wr.transitive = true;
                    }
                    include.add(wr);
                    continue;
                }
                if (!useOsgiDependencies || !depExaminator.isOsgiBundle()) continue;
                wr = new ModuleWrapper();
                String id = artifact.getGroupId() + ":" + artifact.getArtifactId();
                for (Dependency depe : deps) {
                    if (!id.equals(depe.getId())) continue;
                    wr.dependency = depe;
                }
                boolean print = false;
                if (wr.dependency == null) {
                    Dependency depe;
                    depe = new Dependency();
                    depe.setId(id);
                    depe.setType("spec");
                    wr.dependency = depe;
                    print = true;
                }
                wr.artifact = artifact;
                wr.transitive = false;
                if (artifact.getDependencyTrail().size() > 2) {
                    log.debug((CharSequence)(artifact.getId() + " omitted as NetBeans module OSGi dependency, not a direct one. Declare it in the pom for inclusion."));
                    wr.transitive = true;
                } else if (print) {
                    log.info((CharSequence)("Adding OSGi bundle dependency - " + id));
                }
                include.add(wr);
            }
        }
        return include;
    }

    protected DependencyNode createDependencyTree(MavenProject project, DependencyTreeBuilder dependencyTreeBuilder, ArtifactRepository localRepository, ArtifactFactory artifactFactory, ArtifactMetadataSource artifactMetadataSource, ArtifactCollector artifactCollector, String scope) throws MojoExecutionException {
        ArtifactFilter artifactFilter = this.createResolvingArtifactFilter(scope);
        try {
            return dependencyTreeBuilder.buildDependencyTree(project, localRepository, artifactFactory, artifactMetadataSource, artifactFilter, artifactCollector);
        }
        catch (DependencyTreeBuilderException exception) {
            throw new MojoExecutionException("Cannot build project dependency tree", (Exception)((Object)exception));
        }
    }

    private ArtifactFilter createResolvingArtifactFilter(String scope) {
        ScopeArtifactFilter filter;
        if (scope != null) {
            this.getLog().debug((CharSequence)("+ Resolving dependency tree for scope '" + scope + "'"));
            filter = new ScopeArtifactFilter(scope);
        } else {
            filter = null;
        }
        return filter;
    }

    protected final ArtifactResult turnJarToNbmFile(Artifact art, ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, MavenProject project, ArtifactRepository localRepository) throws MojoExecutionException {
        if ("jar".equals(art.getType()) || "nbm".equals(art.getType())) {
            ExamineManifest mnf = new ExamineManifest(this.getLog());
            File jar = art.getFile();
            if (!jar.isFile()) {
                this.getLog().warn((CharSequence)("MNBMODULE-131: need to at least run package phase on " + jar));
                return new ArtifactResult(null, null);
            }
            mnf.setJarFile(jar);
            mnf.checkFile();
            if (mnf.isNetbeansModule()) {
                Artifact nbmArt;
                block8: {
                    nbmArt = artifactFactory.createDependencyArtifact(art.getGroupId(), art.getArtifactId(), art.getVersionRange(), "nbm-file", art.getClassifier(), art.getScope());
                    try {
                        artifactResolver.resolve(nbmArt, project.getRemoteArtifactRepositories(), localRepository);
                    }
                    catch (ArtifactResolutionException ex) {
                        this.checkReactor(art, nbmArt);
                        if (!nbmArt.isResolved()) {
                            throw new MojoExecutionException("Failed to retrieve the nbm file from repository", (Exception)((Object)ex));
                        }
                    }
                    catch (ArtifactNotFoundException ex) {
                        this.checkReactor(art, nbmArt);
                        if (nbmArt.isResolved()) break block8;
                        throw new MojoExecutionException("Failed to retrieve the nbm file from repository", (Exception)((Object)ex));
                    }
                }
                return new ArtifactResult(nbmArt, mnf);
            }
            if (mnf.isOsgiBundle()) {
                return new ArtifactResult(null, mnf);
            }
        }
        return new ArtifactResult(null, null);
    }

    private void checkReactor(Artifact art, Artifact nbmArt) {
        if (art.getFile().getName().endsWith(".jar")) {
            String name = art.getFile().getName();
            name = name.substring(0, name.length() - ".jar".length()) + ".nbm";
            File fl = new File(art.getFile().getParentFile(), name);
            if (fl.exists()) {
                nbmArt.setFile(fl);
                nbmArt.setResolved(true);
            }
        }
    }

    protected final class ArtifactResult {
        private final Artifact converted;
        private final ExamineManifest manifest;

        ArtifactResult(Artifact conv, ExamineManifest manifest) {
            this.converted = conv;
            this.manifest = manifest;
        }

        boolean hasConvertedArtifact() {
            return this.converted != null;
        }

        Artifact getConvertedArtifact() {
            return this.converted;
        }

        public boolean isOSGiBundle() {
            return this.manifest != null && this.manifest.isOsgiBundle();
        }

        public ExamineManifest getExaminedManifest() {
            return this.manifest;
        }
    }

    static class ModuleWrapper {
        Dependency dependency;
        Artifact artifact;
        boolean transitive = true;

        ModuleWrapper() {
        }
    }
}

