/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.CkjmOutputHandler;
import gr.spinellis.ckjm.ClassMetricsContainer;
import gr.spinellis.ckjm.ClassVisitor;
import gr.spinellis.ckjm.PrintPlainResults;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class MetricsFilter {
    private static boolean includeJdk = false;
    private static boolean onlyPublic = false;

    public static boolean isJdkIncluded() {
        return includeJdk;
    }

    public static boolean includeAll() {
        return !onlyPublic;
    }

    static void processClass(ClassMetricsContainer cm, String clspec) {
        int spc;
        JavaClass jc = null;
        File file = new File(clspec);
        if (!file.exists() && (spc = clspec.indexOf(32)) != -1) {
            String jar = clspec.substring(0, spc);
            clspec = clspec.substring(spc + 1);
            try {
                jc = new ClassParser(jar, clspec).parse();
            }
            catch (IOException e) {
                System.err.println("Error loading " + clspec + " from " + jar + ": " + e);
            }
        } else {
            try {
                jc = new ClassParser(clspec).parse();
            }
            catch (IOException e) {
                System.err.println("Error loading " + clspec + ": " + e);
            }
        }
        if (jc != null) {
            ClassVisitor visitor = new ClassVisitor(jc, cm);
            visitor.start();
            visitor.end();
        }
    }

    public static void runMetrics(String[] files, CkjmOutputHandler outputHandler) {
        ClassMetricsContainer cm = new ClassMetricsContainer();
        for (int i = 0; i < files.length; ++i) {
            MetricsFilter.processClass(cm, files[i]);
        }
        cm.printMetrics(outputHandler);
    }

    public static void main(String[] argv) {
        int argp = 0;
        if (argv.length > argp && argv[argp].equals("-s")) {
            includeJdk = true;
            ++argp;
        }
        if (argv.length > argp && argv[argp].equals("-p")) {
            onlyPublic = true;
            ++argp;
        }
        ClassMetricsContainer cm = new ClassMetricsContainer();
        if (argv.length == argp) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                String s;
                while ((s = in.readLine()) != null) {
                    MetricsFilter.processClass(cm, s);
                }
            }
            catch (Exception e) {
                System.err.println("Error reading line: " + e);
                System.exit(1);
            }
        }
        for (int i = argp; i < argv.length; ++i) {
            MetricsFilter.processClass(cm, argv[i]);
        }
        PrintPlainResults handler = new PrintPlainResults(System.out);
        cm.printMetrics(handler);
    }
}

