/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.ClassMetrics;
import gr.spinellis.ckjm.ClassVisitor;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;

class MethodVisitor
extends EmptyVisitor {
    private MethodGen mg;
    private ConstantPoolGen cp;
    private ClassVisitor cv;
    private ClassMetrics cm;

    MethodVisitor(MethodGen m, ClassVisitor c) {
        this.mg = m;
        this.cv = c;
        this.cp = this.mg.getConstantPool();
        this.cm = this.cv.getMetrics();
    }

    public void start() {
        if (!this.mg.isAbstract() && !this.mg.isNative()) {
            for (InstructionHandle ih = this.mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (this.visitInstruction(i)) continue;
                i.accept((Visitor)this);
            }
            this.updateExceptionHandlers();
        }
    }

    private boolean visitInstruction(Instruction i) {
        short opcode = i.getOpcode();
        return InstructionConstants.INSTRUCTIONS[opcode] != null && !(i instanceof ConstantPushInstruction) && !(i instanceof ReturnInstruction);
    }

    public void visitLocalVariableInstruction(LocalVariableInstruction i) {
        if (i.getOpcode() != 132) {
            this.cv.registerCoupling(i.getType(this.cp));
        }
    }

    public void visitArrayInstruction(ArrayInstruction i) {
        this.cv.registerCoupling(i.getType(this.cp));
    }

    public void visitFieldInstruction(FieldInstruction i) {
        this.cv.registerFieldAccess(i.getClassName(this.cp), i.getFieldName(this.cp));
        this.cv.registerCoupling(i.getFieldType(this.cp));
    }

    public void visitInvokeInstruction(InvokeInstruction i) {
        Type[] argTypes = i.getArgumentTypes(this.cp);
        for (int j = 0; j < argTypes.length; ++j) {
            this.cv.registerCoupling(argTypes[j]);
        }
        this.cv.registerCoupling(i.getReturnType(this.cp));
        this.cv.registerMethodInvocation(i.getClassName(this.cp), i.getMethodName(this.cp), argTypes);
    }

    public void visitINSTANCEOF(INSTANCEOF i) {
        this.cv.registerCoupling(i.getType(this.cp));
    }

    public void visitCHECKCAST(CHECKCAST i) {
        this.cv.registerCoupling(i.getType(this.cp));
    }

    public void visitReturnInstruction(ReturnInstruction i) {
        this.cv.registerCoupling(i.getType(this.cp));
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] handlers = this.mg.getExceptionHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            ObjectType t = handlers[i].getCatchType();
            if (t == null) continue;
            this.cv.registerCoupling((Type)t);
        }
    }
}

