/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedPrivateFieldRule
extends AbstractRule {
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBody;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimarySuffix;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration;

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Map<VariableNameDeclaration, List<NameOccurrence>> vars = node.getScope().getVariableDeclarations();
        for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> entry : vars.entrySet()) {
            VariableNameDeclaration decl = entry.getKey();
            if (!decl.getAccessNodeParent().isPrivate() || this.isOK(decl.getImage()) || this.actuallyUsed(entry.getValue()) || this.usedInOuterClass(node, decl)) continue;
            this.addViolation(data, decl.getNode(), decl.getImage());
        }
        return super.visit(node, data);
    }

    private boolean usedInOuterClass(ASTClassOrInterfaceDeclaration node, VariableNameDeclaration decl) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        List outerClasses = node.getParentsOfType(clazz);
        for (ASTClassOrInterfaceDeclaration outerClass : outerClasses) {
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBody;
            if (clazz2 == null) {
                clazz2 = new ASTClassOrInterfaceBody[0].getClass().getComponentType();
            }
            ASTClassOrInterfaceBody classOrInterfaceBody = (ASTClassOrInterfaceBody)outerClass.getFirstChildOfType(clazz2);
            ArrayList classOrInterfaceBodyDeclarations = new ArrayList();
            Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration;
            if (clazz3 == null) {
                clazz3 = new ASTClassOrInterfaceBodyDeclaration[0].getClass().getComponentType();
            }
            classOrInterfaceBody.findChildrenOfType(clazz3, classOrInterfaceBodyDeclarations, false);
            for (ASTClassOrInterfaceBodyDeclaration classOrInterfaceBodyDeclaration : classOrInterfaceBodyDeclarations) {
                for (int i = 0; i < classOrInterfaceBodyDeclaration.jjtGetNumChildren(); ++i) {
                    if (classOrInterfaceBodyDeclaration.jjtGetChild(i) instanceof ASTClassOrInterfaceDeclaration) continue;
                    Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTPrimarySuffix;
                    if (clazz4 == null) {
                        clazz4 = new ASTPrimarySuffix[0].getClass().getComponentType();
                    }
                    List primarySuffixes = classOrInterfaceBodyDeclaration.findChildrenOfType(clazz4);
                    for (ASTPrimarySuffix primarySuffix : primarySuffixes) {
                        if (!decl.getImage().equals(primarySuffix.getImage())) continue;
                        return true;
                    }
                    Class<?> clazz5 = class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
                    if (clazz5 == null) {
                        clazz5 = new ASTPrimaryPrefix[0].getClass().getComponentType();
                    }
                    List primaryPrefixes = classOrInterfaceBodyDeclaration.findChildrenOfType(clazz5);
                    for (ASTPrimaryPrefix primaryPrefix : primaryPrefixes) {
                        ASTName name;
                        Class<?> clazz6 = class$net$sourceforge$pmd$ast$ASTName;
                        if (clazz6 == null) {
                            clazz6 = new ASTName[0].getClass().getComponentType();
                        }
                        if ((name = (ASTName)primaryPrefix.getFirstChildOfType(clazz6)) == null || !name.getImage().endsWith(decl.getImage())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean actuallyUsed(List<NameOccurrence> usages) {
        for (NameOccurrence nameOccurrence : usages) {
            if (nameOccurrence.isOnLeftHandSide()) continue;
            return true;
        }
        return false;
    }

    private boolean isOK(String image) {
        return image.equals("serialVersionUID") || image.equals("serialPersistentFields") || image.equals("IDENT");
    }
}

