/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa.variableaccess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTVariableInitializer;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.StartOrEndDataFlowNode;
import net.sourceforge.pmd.dfa.variableaccess.VariableAccess;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableAccessVisitor
extends JavaParserVisitorAdapter {
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTVariableInitializer;

    public void compute(ASTMethodDeclaration node) {
        if (node.jjtGetParent() instanceof ASTClassOrInterfaceBodyDeclaration) {
            this.computeNow(node);
        }
    }

    public void compute(ASTConstructorDeclaration node) {
        this.computeNow(node);
    }

    private void computeNow(SimpleNode node) {
        IDataFlowNode inode = node.getDataFlowNode();
        List<VariableAccess> undefinitions = this.markUsages(inode);
        IDataFlowNode firstINode = inode.getFlow().get(0);
        firstINode.setVariableAccess(undefinitions);
        IDataFlowNode lastINode = inode.getFlow().get(inode.getFlow().size() - 1);
        lastINode.setVariableAccess(undefinitions);
    }

    private List<VariableAccess> markUsages(IDataFlowNode inode) {
        ArrayList<VariableAccess> undefinitions = new ArrayList<VariableAccess>();
        Set<Map<VariableNameDeclaration, List<NameOccurrence>>> variableDeclarations = this.collectDeclarations(inode);
        for (Map<VariableNameDeclaration, List<NameOccurrence>> declarations : variableDeclarations) {
            for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> entry : declarations.entrySet()) {
                VariableNameDeclaration vnd = entry.getKey();
                if (vnd.getAccessNodeParent() instanceof ASTFormalParameter) continue;
                AccessNode accessNode = vnd.getAccessNodeParent();
                Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableInitializer;
                if (clazz == null) {
                    clazz = new ASTVariableInitializer[0].getClass().getComponentType();
                }
                if (accessNode.getFirstChildOfType(clazz) != null) {
                    this.addVariableAccess(vnd.getNode(), new VariableAccess(0, vnd.getImage()), inode.getFlow());
                }
                undefinitions.add(new VariableAccess(2, vnd.getImage()));
                for (NameOccurrence occurrence : entry.getValue()) {
                    this.addAccess(occurrence, inode);
                }
            }
        }
        return undefinitions;
    }

    private Set<Map<VariableNameDeclaration, List<NameOccurrence>>> collectDeclarations(IDataFlowNode inode) {
        HashSet<Map<VariableNameDeclaration, List<NameOccurrence>>> decls = new HashSet<Map<VariableNameDeclaration, List<NameOccurrence>>>();
        for (int i = 0; i < inode.getFlow().size(); ++i) {
            Map<VariableNameDeclaration, List<NameOccurrence>> varDecls;
            IDataFlowNode n = inode.getFlow().get(i);
            if (n instanceof StartOrEndDataFlowNode || decls.contains(varDecls = n.getSimpleNode().getScope().getVariableDeclarations())) continue;
            decls.add(varDecls);
        }
        return decls;
    }

    private void addAccess(NameOccurrence occurrence, IDataFlowNode inode) {
        if (occurrence.isOnLeftHandSide()) {
            this.addVariableAccess(occurrence.getLocation(), new VariableAccess(0, occurrence.getImage()), inode.getFlow());
        } else if (occurrence.isOnRightHandSide() || !occurrence.isOnLeftHandSide() && !occurrence.isOnRightHandSide()) {
            this.addVariableAccess(occurrence.getLocation(), new VariableAccess(1, occurrence.getImage()), inode.getFlow());
        }
    }

    private void addVariableAccess(SimpleNode node, VariableAccess va, List flow) {
        for (int i = flow.size() - 1; i > 0; --i) {
            IDataFlowNode inode = (IDataFlowNode)flow.get(i);
            if (inode.getSimpleNode() == null) continue;
            List<?> children = inode.getSimpleNode().findChildrenOfType(node.getClass());
            for (SimpleNode n : children) {
                if (!node.equals(n)) continue;
                ArrayList<VariableAccess> v = new ArrayList<VariableAccess>();
                v.add(va);
                inode.setVariableAccess(v);
                return;
            }
        }
    }
}

