/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugin;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.core.plugin.JpaPluginFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="plugins")
public class JpaPlugin
extends BaseIdentifiable {
    @Column(name="plugin_key", updatable=true, nullable=false, length=100)
    private String key;
    @Column(name="version", updatable=true, nullable=true, length=100)
    private String version;
    @Column(name="name", updatable=true, nullable=true, length=100)
    private String name;
    @Column(name="description", updatable=true, nullable=true, length=3000)
    private String description;
    @Column(name="organization", updatable=true, nullable=true, length=100)
    private String organization;
    @Column(name="organization_url", updatable=true, nullable=true, length=500)
    private String organizationUrl;
    @Column(name="license", updatable=true, nullable=true, length=50)
    private String license;
    @Column(name="installation_date", updatable=true, nullable=true)
    private Date installationDate;
    @Column(name="plugin_class", updatable=true, nullable=true, length=100)
    private String pluginClass;
    @Column(name="homepage", updatable=true, nullable=true, length=500)
    private String homepage;
    @Column(name="core", updatable=true, nullable=true)
    private Boolean core;
    @Column(name="child_first_classloader", updatable=true, nullable=true)
    private Boolean childFirstClassLoader = Boolean.FALSE;
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OneToMany(mappedBy="plugin", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<JpaPluginFile> files = new ArrayList<JpaPluginFile>();

    public JpaPlugin() {
    }

    public JpaPlugin(String pluginKey) {
        if (StringUtils.isBlank((String)pluginKey)) {
            throw new IllegalArgumentException("LocalExtension.pluginKey can not be blank");
        }
        this.key = pluginKey;
    }

    public String getKey() {
        return this.key;
    }

    public JpaPlugin setKey(String s) {
        this.key = s;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public JpaPlugin setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public JpaPlugin setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getOrganization() {
        return this.organization;
    }

    public JpaPlugin setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public JpaPlugin setOrganizationUrl(URI uri) {
        this.organizationUrl = uri != null ? uri.toString() : null;
        return this;
    }

    public JpaPlugin setOrganizationUrl(String s) {
        this.organizationUrl = s;
        return this;
    }

    public String getLicense() {
        return this.license;
    }

    public JpaPlugin setLicense(String license) {
        this.license = license;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public JpaPlugin setVersion(String s) {
        this.version = s;
        return this;
    }

    public Date getInstallationDate() {
        return this.installationDate;
    }

    public JpaPlugin setInstallationDate(Date installationDate) {
        this.installationDate = installationDate;
        return this;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public JpaPlugin setPluginClass(String s) {
        this.pluginClass = s;
        return this;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public JpaPlugin setHomepage(URI uri) {
        this.homepage = uri != null ? uri.toString() : null;
        return this;
    }

    public JpaPlugin setHomepage(String s) {
        this.homepage = s;
        return this;
    }

    public Boolean isCore() {
        return this.core;
    }

    public JpaPlugin setCore(Boolean b) {
        this.core = b;
        return this;
    }

    public Boolean isUseChildFirstClassLoader() {
        return this.childFirstClassLoader;
    }

    public JpaPlugin setUseChildFirstClassLoader(boolean use) {
        this.childFirstClassLoader = use;
        return this;
    }

    public void createFile(String filename) {
        JpaPluginFile file = new JpaPluginFile(this, filename);
        this.files.add(file);
    }

    public List<JpaPluginFile> getFiles() {
        return this.files;
    }

    public void removeFiles() {
        this.files.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JpaPlugin other = (JpaPlugin)((Object)o);
        return this.key.equals(other.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.getId()).append("key", (Object)this.key).append("version", (Object)this.version).append("homepage", (Object)this.homepage).append("installationDate", (Object)this.installationDate).toString();
    }

    public static JpaPlugin create(String pluginKey) {
        return new JpaPlugin(pluginKey);
    }
}

