/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.classloaders;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.sonar.api.utils.Logs;
import org.sonar.api.utils.SonarException;
import org.sonar.core.classloaders.ResourcesClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoadersCollection {
    private static final String[] PREFIXES_TO_EXPORT = new String[]{"org.sonar.plugins.", "com.sonar.plugins.", "com.sonarsource.plugins."};
    private ClassWorld world = new ClassWorld();
    private ClassLoader baseClassLoader;

    public ClassLoadersCollection(ClassLoader baseClassLoader) {
        this.baseClassLoader = baseClassLoader;
    }

    public ClassLoader createClassLoader(String key, Collection<URL> urls, boolean childFirst) {
        try {
            ClassRealm realm;
            ArrayList resources = Lists.newArrayList();
            ArrayList others = Lists.newArrayList();
            for (URL url : urls) {
                if (this.isResource(url)) {
                    resources.add(url);
                    continue;
                }
                others.add(url);
            }
            ClassLoader parent = resources.isEmpty() ? this.baseClassLoader : new ResourcesClassLoader(resources, this.baseClassLoader);
            if (childFirst) {
                ClassRealm parentRealm = this.world.newRealm(key + "-parent", parent);
                realm = parentRealm.createChildRealm(key);
            } else {
                realm = this.world.newRealm(key, parent);
            }
            for (URL url : others) {
                realm.addURL(url);
            }
            return realm;
        }
        catch (DuplicateRealmException e) {
            throw new SonarException((Throwable)e);
        }
    }

    public void done() {
        for (Object o : this.world.getRealms()) {
            ClassRealm realm = (ClassRealm)o;
            if (StringUtils.endsWith((String)realm.getId(), (String)"-parent")) continue;
            String[] packagesToExport = new String[PREFIXES_TO_EXPORT.length];
            for (int i = 0; i < PREFIXES_TO_EXPORT.length; ++i) {
                packagesToExport[i] = PREFIXES_TO_EXPORT[i] + realm.getId() + ".api";
            }
            this.export(realm, packagesToExport);
        }
    }

    private void export(ClassRealm realm, String ... packages) {
        Logs.INFO.debug("Exporting " + Arrays.toString(packages) + " from " + realm.getId());
        for (Object o : this.world.getRealms()) {
            ClassRealm dep = (ClassRealm)o;
            if (StringUtils.equals((String)dep.getId(), (String)realm.getId())) continue;
            try {
                for (String packageName : packages) {
                    dep.importFrom(realm.getId(), packageName);
                }
            }
            catch (NoSuchRealmException e) {
                throw new SonarException((Throwable)e);
            }
        }
    }

    public ClassLoader get(String key) {
        try {
            return this.world.getRealm(key);
        }
        catch (NoSuchRealmException e) {
            return null;
        }
    }

    private boolean isResource(URL url) {
        String path = url.getPath();
        return !StringUtils.endsWith((String)path, (String)".jar") && !StringUtils.endsWith((String)path, (String)"/");
    }
}

