/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.bcel;

import net.sf.clirr.core.internal.bcel.BcelJavaType;
import net.sf.clirr.core.internal.bcel.BcelScopeHelper;
import net.sf.clirr.core.spi.JavaType;
import net.sf.clirr.core.spi.Scope;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

final class BcelMethod
implements net.sf.clirr.core.spi.Method {
    private Method method;
    private JavaClass owningClass;

    public BcelMethod(JavaClass owningClass, Method method) {
        this.owningClass = owningClass;
        this.method = method;
    }

    public JavaType getReturnType() {
        return this.convertType(this.method.getReturnType());
    }

    public String getName() {
        return this.method.getName();
    }

    public boolean isFinal() {
        return this.method.isFinal();
    }

    public boolean isStatic() {
        return this.method.isStatic();
    }

    public boolean isAbstract() {
        return this.method.isAbstract();
    }

    public boolean isDeprecated() {
        Attribute[] attrs = this.method.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (!(attrs[i] instanceof Deprecated)) continue;
            return true;
        }
        return false;
    }

    public Scope getDeclaredScope() {
        return BcelScopeHelper.getScope(this.method.getAccessFlags());
    }

    public Scope getEffectiveScope() {
        return this.getDeclaredScope();
    }

    public JavaType[] getArgumentTypes() {
        Type[] types = this.method.getArgumentTypes();
        return this.convertTypes(types);
    }

    private JavaType convertType(Type bcelType) {
        return new BcelJavaType(bcelType, this.owningClass.getRepository());
    }

    private JavaType[] convertTypes(Type[] types) {
        JavaType[] retval = new JavaType[types.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = this.convertType(types[i]);
        }
        return retval;
    }
}

