/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.text.AnnotationProvider;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupportRedirector;
import org.openide.text.EditorSupportLineSet;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.FilterDocument;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.text.PrintPreferences;
import org.openide.text.UndoRedoManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserCancelException;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public abstract class CloneableEditorSupport
extends CloneableOpenSupport {
    private static final RequestProcessor RP = new RequestProcessor("org.openide.text Document Processing");
    public static final String EDITOR_MODE = "editor";
    public static final UndoableEdit BEGIN_COMMIT_GROUP = UndoRedoManager.BEGIN_COMMIT_GROUP;
    public static final UndoableEdit END_COMMIT_GROUP = UndoRedoManager.END_COMMIT_GROUP;
    public static final UndoableEdit MARK_COMMIT_GROUP = UndoRedoManager.MARK_COMMIT_GROUP;
    private static final String PROP_PANE = "CloneableEditorSupport.Pane";
    private static final int DOCUMENT_NO = 0;
    private static final int DOCUMENT_LOADING = 1;
    private static final int DOCUMENT_READY = 2;
    private static final int DOCUMENT_RELOADING = 3;
    private static final ThreadLocal<Boolean> LOCAL_LOAD_TASK = new ThreadLocal();
    private static final ThreadLocal<Boolean> LOCAL_CLOSE_DOCUMENT = new ThreadLocal();
    private static final Logger ERR = Logger.getLogger("org.openide.text.CloneableEditorSupport");
    private boolean inUserQuestionExceptionHandler;
    private Task prepareTask;
    private EditorKit kit;
    private StrongRef doc;
    private final Object LOCK_STRONG_REF = new Object();
    private boolean isStrongSet = false;
    private int counterGetDocument = 0;
    private int counterOpenDocument = 0;
    private int counterPrepareDocument = 0;
    private int counterOpenAtImpl = 0;
    private String mimeType;
    private Listener listener;
    private UndoRedo.Manager undoRedo;
    private Line.Set lineSet;
    private boolean printing;
    private final Object LOCK_PRINTING = new Object();
    private PositionRef.Manager positionManager;
    private Set<ChangeListener> listeners;
    private transient Reference<Pane> lastSelected;
    private long lastSaveTime = -1L;
    private boolean reloadDialogOpened;
    private PropertyChangeSupport propertyChangeSupport;
    private Lookup lookup;
    private boolean alreadyModified;
    private boolean documentReloading;
    private volatile int documentStatus = 0;
    private Throwable prepareDocumentRuntimeException;
    private Map<Line, Reference<Line>> lineSetWHM;
    private boolean annotationsLoaded;
    private DocFilter docFilter;
    private static final Set<Class> warnedClasses = new WeakSet();
    private boolean reloadDocumentFireDocumentChangeClose = false;
    private boolean reloadDocumentFireDocumentChangeOpen = false;
    private static Reference<CloneableTopComponent> lastReusable = new WeakReference<Object>(null);

    public CloneableEditorSupport(Env env) {
        this(env, Lookup.EMPTY);
    }

    public CloneableEditorSupport(Env env, Lookup l) {
        super((CloneableOpenSupport.Env)env);
        Parameters.notNull((CharSequence)"l", (Object)l);
        this.lookup = l;
    }

    protected abstract String messageSave();

    protected abstract String messageName();

    protected String messageHtmlName() {
        return null;
    }

    protected String documentID() {
        return this.messageName();
    }

    protected abstract String messageToolTip();

    protected String messageLine(Line line) {
        return NbBundle.getMessage(Line.class, (String)"FMT_CESLineDisplayName", (Object)this.messageName(), (Object)(line.getLineNumber() + 1));
    }

    final Env cesEnv() {
        return (Env)this.env;
    }

    final EditorKit cesKit() {
        return this.kit;
    }

    protected final synchronized UndoRedo.Manager getUndoRedo() {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.getUndoRedo();
        }
        if (this.undoRedo == null) {
            UndoRedo.Manager mgr;
            this.undoRedo = mgr = this.createUndoRedoManager();
        }
        return this.undoRedo;
    }

    final synchronized PositionRef.Manager getPositionManager() {
        if (this.positionManager == null) {
            this.positionManager = new PositionRef.Manager(this);
        }
        return this.positionManager;
    }

    void ensureAnnotationsLoaded() {
        if (!this.annotationsLoaded) {
            this.annotationsLoaded = true;
            Line.Set lines = this.getLineSet();
            for (AnnotationProvider act : Lookup.getDefault().lookupAll(AnnotationProvider.class)) {
                act.annotate(lines, this.lookup);
            }
        }
    }

    private void askUserAndDoOpen(UserQuestionException e, Callable<Void> run) {
        while (e != null) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)e.getLocalizedMessage(), 0);
            nd.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (NotifyDescriptor.OK_OPTION.equals(res)) {
                try {
                    e.confirmed();
                }
                catch (IOException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                    return;
                }
            } else {
                return;
            }
            e = null;
            try {
                run.call();
            }
            catch (UserQuestionException ex) {
                e = ex;
            }
            catch (IOException ex) {
                ERR.log(Level.INFO, null, ex);
            }
            catch (Exception ex) {
                ERR.log(Level.SEVERE, null, ex);
            }
        }
    }

    protected boolean asynchronousOpen() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (warnedClasses.add(clazz)) {
            ERR.warning(clazz.getName() + " should override asynchronousOpen()." + " See http://bits.netbeans.org/dev/javadoc/org-openide-text/apichanges.html#CloneableEditorSupport.asynchronousOpen");
        }
        return false;
    }

    public void open() {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            redirect.open();
            return;
        }
        if (this.getListener().loadExc instanceof UserQuestionException) {
            this.getListener().loadExc = null;
            this.documentStatus = 0;
        }
        if (this.asynchronousOpen()) {
            super.open();
        } else {
            try {
                StyledDocument doc = this.openDocument();
                super.open();
            }
            catch (UserQuestionException e) {
                class Query
                implements Runnable,
                Callable<Void> {
                    Query() {
                    }

                    @Override
                    public void run() {
                        CloneableEditorSupport.this.askUserAndDoOpen(e, this);
                    }

                    @Override
                    public Void call() throws IOException {
                        CloneableEditorSupport.this.getListener().loadExc = null;
                        CloneableEditorSupport.this.documentStatus = 0;
                        StyledDocument doc = CloneableEditorSupport.this.openDocument();
                        CloneableEditorSupport.super.open();
                        return null;
                    }
                }
                Query query = new Query();
                Mutex.EVENT.readAccess((Runnable)query);
            }
            catch (IOException e) {
                ERR.log(Level.INFO, null, e);
            }
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        return this.propertyChangeSupport;
    }

    private boolean canReleaseDoc() {
        return this.counterGetDocument == 0 && this.counterOpenDocument == 0 && this.counterPrepareDocument == 0 && this.counterOpenAtImpl == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task prepareDocument() {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.prepareDocument();
        }
        Object object = this.getLock();
        synchronized (object) {
            final StyledDocument doc = this.getDoc();
            if (doc == null && this.documentStatus != 0) {
                this.closeDocument();
            }
            switch (this.documentStatus) {
                case 0: {
                    Task t;
                    this.documentStatus = 1;
                    ++this.counterPrepareDocument;
                    this.prepareTask = t = this.prepareDocument(false);
                    t.addTaskListener(new TaskListener(){

                        public void taskFinished(Task task) {
                            CloneableEditorSupport.this.counterPrepareDocument--;
                            if (CloneableEditorSupport.this.isStrongSet && CloneableEditorSupport.this.canReleaseDoc()) {
                                CloneableEditorSupport.this.isStrongSet = false;
                                CloneableEditorSupport.this.setStrong(false, true);
                            }
                            task.removeTaskListener((TaskListener)this);
                        }
                    });
                    return t;
                }
                case 2: {
                    assert (doc != null);
                    Task tt = new Task(new Runnable(){
                        private final StyledDocument d;
                        {
                            this.d = doc;
                        }

                        @Override
                        public void run() {
                        }
                    });
                    tt.run();
                    return tt;
                }
            }
            if (this.prepareTask == null) {
                throw new IllegalStateException();
            }
            return this.prepareTask;
        }
    }

    private Task prepareDocument(boolean notUsed) {
        assert (Thread.holdsLock(this.getLock()));
        if (this.prepareTask != null) {
            return this.prepareTask;
        }
        boolean failed = true;
        Task prepareTaskReturn = null;
        try {
            this.env.removePropertyChangeListener((PropertyChangeListener)this.getListener());
            this.env.addPropertyChangeListener((PropertyChangeListener)this.getListener());
            this.kit = this.createEditorKit();
            final StyledDocument[] docToLoad = new StyledDocument[]{this.getDoc()};
            if (docToLoad[0] == null) {
                docToLoad[0] = this.createStyledDocument(this.kit);
                this.setDoc(docToLoad[0], true);
                this.isStrongSet = true;
            } else {
                this.setDoc(docToLoad[0], true);
                this.isStrongSet = true;
            }
            prepareTaskReturn = this.prepareTask = RP.create(new Runnable(){
                private boolean runningInAtomicLock;
                private boolean fireEvent;
                private StyledDocument d;

                @Override
                public void run() {
                    this.doRun();
                    docToLoad[0] = null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void doRun() {
                    if (!this.runningInAtomicLock) {
                        this.runningInAtomicLock = true;
                        NbDocument.runAtomic(docToLoad[0], this);
                        if (this.fireEvent) {
                            CloneableEditorSupport.this.fireDocumentChange(this.d, false);
                        }
                        return;
                    }
                    Object object = CloneableEditorSupport.this.getLock();
                    synchronized (object) {
                        if (CloneableEditorSupport.this.documentStatus == 0) {
                            CloneableEditorSupport.this.prepareTask = null;
                            return;
                        }
                        if (CloneableEditorSupport.this.getDoc() != docToLoad[0]) {
                            CloneableEditorSupport.this.prepareTask = null;
                            return;
                        }
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = null;
                        int targetStatus = 0;
                        try {
                            CloneableEditorSupport.this.getListener().run();
                            CloneableEditorSupport.this.documentStatus = 2;
                            this.fireEvent = true;
                            targetStatus = 2;
                            Object urm = CloneableEditorSupport.this.getUndoRedo();
                            if (urm instanceof UndoRedoManager) {
                                ((UndoRedoManager)((Object)urm)).markSavepoint();
                            }
                            CloneableEditorSupport.this.getDoc().addUndoableEditListener((UndoableEditListener)urm);
                            this.d = CloneableEditorSupport.this.getDoc();
                        }
                        catch (DelegateIOExc t) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = t;
                        }
                        catch (RuntimeException t) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = t;
                            Exceptions.printStackTrace((Throwable)t);
                            throw t;
                        }
                        catch (Error t) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = t;
                            Exceptions.printStackTrace((Throwable)t);
                            throw t;
                        }
                        finally {
                            Object t = CloneableEditorSupport.this.getLock();
                            synchronized (t) {
                                CloneableEditorSupport.this.documentStatus = targetStatus;
                                CloneableEditorSupport.this.getLock().notifyAll();
                                CloneableEditorSupport.this.prepareTask = null;
                            }
                        }
                    }
                }
            });
            ((RequestProcessor.Task)prepareTaskReturn).schedule(0);
            if (RP.isRequestProcessorThread()) {
                prepareTaskReturn.waitFinished();
            }
            failed = false;
        }
        catch (RuntimeException ex) {
            this.prepareDocumentRuntimeException = ex;
            throw ex;
        }
        catch (Error err) {
            this.prepareDocumentRuntimeException = err;
            throw err;
        }
        finally {
            if (failed) {
                this.documentStatus = 0;
                this.getLock().notifyAll();
            }
        }
        assert (prepareTaskReturn != null) : "CloneableEditorSupport.prepareDocument must return non null value";
        return prepareTaskReturn;
    }

    final void addRemoveDocListener(Document d, boolean add) {
        if (d == null) {
            return;
        }
        if (Boolean.TRUE.equals(d.getProperty("supportsModificationListener"))) {
            if (add) {
                d.putProperty("modificationListener", this.getListener());
            } else {
                d.putProperty("modificationListener", null);
            }
        }
        if (add) {
            if (d instanceof AbstractDocument) {
                AbstractDocument aDoc = (AbstractDocument)d;
                DocumentFilter origFilter = aDoc.getDocumentFilter();
                this.docFilter = new DocFilter(origFilter);
                aDoc.setDocumentFilter(this.docFilter);
            } else {
                DocumentFilter origFilter = (DocumentFilter)d.getProperty(DocumentFilter.class);
                this.docFilter = new DocFilter(origFilter);
                d.putProperty(DocumentFilter.class, this.docFilter);
            }
            d.addDocumentListener(this.getListener());
        } else {
            if (this.docFilter != null) {
                if (d instanceof AbstractDocument) {
                    AbstractDocument aDoc = (AbstractDocument)d;
                    aDoc.setDocumentFilter(this.docFilter.origFilter);
                } else {
                    d.putProperty(DocumentFilter.class, this.docFilter.origFilter);
                }
                this.docFilter = null;
            }
            d.removeDocumentListener(this.getListener());
        }
    }

    private void clearDocument() {
        NbDocument.runAtomic(this.getDoc(), new Runnable(){

            @Override
            public void run() {
                try {
                    CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), false);
                    CloneableEditorSupport.this.getDoc().remove(0, CloneableEditorSupport.this.getDoc().getLength());
                    CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), true);
                }
                catch (BadLocationException ble) {
                    ERR.log(Level.INFO, null, ble);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public StyledDocument openDocument() throws IOException {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.openDocument();
        }
        Object object = this.getLock();
        synchronized (object) {
            boolean wasCounterIncremented = false;
            try {
                StyledDocument styledDocument;
                StyledDocument doc = this.getDoc();
                if (doc == null && this.documentStatus != 0) {
                    this.closeDocument();
                }
                if (this.documentStatus == 2 || this.documentStatus == 1 || this.documentStatus == 3) {
                    ++this.counterOpenDocument;
                    wasCounterIncremented = true;
                    this.setStrong(true, true);
                }
                try {
                    ++this.counterOpenDocument;
                    styledDocument = doc = this.openDocumentCheckIOE();
                    --this.counterOpenDocument;
                }
                catch (Throwable throwable) {
                    --this.counterOpenDocument;
                    throw throwable;
                }
                return styledDocument;
            }
            finally {
                if (wasCounterIncremented) {
                    --this.counterOpenDocument;
                }
                if (this.isStrongSet && this.canReleaseDoc()) {
                    this.isStrongSet = false;
                    this.setStrong(false, true);
                }
            }
        }
    }

    private StyledDocument openDocumentCheckIOE() throws IOException {
        StyledDocument locDoc = this.openDocumentImpl();
        IOException ioe = this.getListener().checkLoadException();
        if (ioe != null) {
            throw ioe;
        }
        return locDoc;
    }

    private StyledDocument openDocumentImpl() throws IOException, InterruptedIOException {
        switch (this.documentStatus) {
            case 0: {
                this.documentStatus = 1;
                this.prepareDocument(false);
                return this.openDocumentImpl();
            }
            case 2: 
            case 3: {
                StyledDocument document = this.getDoc();
                assert (document != null) : "no document although status is " + this.documentStatus + "; doc=" + this.doc;
                return document;
            }
        }
        try {
            this.getLock().wait();
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        if (this.prepareDocumentRuntimeException != null) {
            if (this.prepareDocumentRuntimeException instanceof DelegateIOExc) {
                Exception ex = new Exception(this.prepareDocumentRuntimeException);
                ERR.log(Level.INFO, "Outer callstack", ex);
                throw (IOException)this.prepareDocumentRuntimeException.getCause();
            }
            if (this.prepareDocumentRuntimeException instanceof Error) {
                throw (Error)this.prepareDocumentRuntimeException;
            }
            throw (RuntimeException)this.prepareDocumentRuntimeException;
        }
        return this.openDocumentImpl();
    }

    Throwable getPrepareDocumentRuntimeException() {
        return this.prepareDocumentRuntimeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public StyledDocument getDocument() {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.getDocument();
        }
        if (this.documentStatus == 0 || this.documentStatus == 1) {
            return null;
        }
        Object object = this.getLock();
        synchronized (object) {
            StyledDocument doc = this.getDoc();
            if (doc == null && this.documentStatus != 0) {
                this.closeDocument();
            }
            switch (this.documentStatus) {
                case 0: {
                    return null;
                }
                case 1: {
                    return null;
                }
            }
            if (LOCAL_LOAD_TASK.get() != null) {
                return this.getDoc();
            }
            try {
                StyledDocument styledDocument;
                ++this.counterGetDocument;
                this.setStrong(true, true);
                try {
                    styledDocument = doc = this.openDocumentCheckIOE();
                }
                catch (IOException e) {
                    StyledDocument styledDocument2;
                    block18: {
                        styledDocument2 = null;
                        --this.counterGetDocument;
                        if (!this.isStrongSet || !this.canReleaseDoc()) break block18;
                        this.isStrongSet = false;
                        this.setStrong(false, true);
                    }
                    return styledDocument2;
                }
                return styledDocument;
            }
            finally {
                --this.counterGetDocument;
                if (this.isStrongSet && this.canReleaseDoc()) {
                    this.isStrongSet = false;
                    this.setStrong(false, true);
                }
            }
        }
    }

    public boolean isModified() {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.isModified();
        }
        return this.cesEnv().isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() throws IOException {
        long externalMod;
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            redirect.saveDocument();
            return;
        }
        if (!this.cesEnv().isModified()) {
            return;
        }
        final StyledDocument myDoc = this.getDocument();
        if (myDoc == null) {
            return;
        }
        long prevLST = this.lastSaveTime;
        if (prevLST != -1L && (externalMod = this.cesEnv().getTime().getTime()) > prevLST) {
            throw new UserQuestionException(this.mimeType){

                public String getLocalizedMessage() {
                    return NbBundle.getMessage(CloneableEditorSupport.class, (String)"FMT_External_change_write", (Object)myDoc.getProperty("title"));
                }

                public void confirmed() throws IOException {
                    CloneableEditorSupport.this.setLastSaveTime(externalMod);
                    CloneableEditorSupport.this.saveDocument();
                }
            };
        }
        Runnable beforeSaveRunnable = (Runnable)myDoc.getProperty("beforeSaveRunnable");
        if (beforeSaveRunnable != null) {
            UndoRedo.Manager urm = this.getUndoRedo();
            if (urm instanceof UndoRedoManager) {
                ((UndoRedoManager)this.undoRedo).setPerformingSaveActions(true);
            }
            try {
                beforeSaveRunnable.run();
            }
            finally {
                if (urm instanceof UndoRedoManager) {
                    ((UndoRedoManager)this.undoRedo).setPerformingSaveActions(false);
                }
            }
        }
        class SaveAsReader
        implements Runnable {
            private boolean doMarkAsUnmodified;
            private IOException ex;

            SaveAsReader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BufferedOutputStream os = null;
                    long oldSaveTime = CloneableEditorSupport.this.lastSaveTime;
                    try {
                        CloneableEditorSupport.this.setLastSaveTime(-1L);
                        os = new BufferedOutputStream(CloneableEditorSupport.this.cesEnv().outputStream());
                        CloneableEditorSupport.this.saveFromKitToStream(myDoc, CloneableEditorSupport.this.kit, os);
                        ((OutputStream)os).close();
                        os = null;
                        ERR.fine("Save ok, assign new time, while old was: " + oldSaveTime);
                        CloneableEditorSupport.this.setLastSaveTime(CloneableEditorSupport.this.cesEnv().getTime().getTime());
                        this.doMarkAsUnmodified = true;
                        ERR.fine("doMarkAsUnmodified");
                    }
                    catch (BadLocationException blex) {
                        Exceptions.printStackTrace((Throwable)blex);
                    }
                    finally {
                        if (CloneableEditorSupport.this.lastSaveTime == -1L) {
                            ERR.fine("restoring old save time");
                            CloneableEditorSupport.this.setLastSaveTime(oldSaveTime);
                        }
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                    UndoRedo.Manager urm = CloneableEditorSupport.this.getUndoRedo();
                    if (urm instanceof UndoRedoManager) {
                        ((UndoRedoManager)urm).markSavepoint();
                    }
                    CloneableEditorSupport.this.updateLineSet(true);
                }
                catch (IOException e) {
                    this.ex = e;
                }
            }

            public void after() throws IOException {
                if (this.doMarkAsUnmodified) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        SaveAsReader saveAsReader = new SaveAsReader();
        myDoc.render(saveAsReader);
        saveAsReader.after();
    }

    public JEditorPane[] getOpenedPanes() {
        assert (SwingUtilities.isEventDispatchThread()) : "CloneableEditorSupport.getOpenedPanes() must be called from AWT thread only";
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.getOpenedPanes();
        }
        LinkedList<JEditorPane> ll = new LinkedList<JEditorPane>();
        Enumeration en = this.allEditors.getComponents();
        Pane last = this.getLastSelected();
        while (en.hasMoreElements()) {
            CloneableTopComponent ctc = (CloneableTopComponent)en.nextElement();
            Pane ed = (Pane)ctc.getClientProperty((Object)PROP_PANE);
            if (ed == null && ctc instanceof Pane) {
                ed = (Pane)ctc;
            }
            if (ed != null) {
                JEditorPane p = ed.getEditorPane();
                if (p == null) continue;
                if (last == ed || last != null && last instanceof Component && ed instanceof Container && ((Container)((Object)ed)).isAncestorOf((Component)((Object)last))) {
                    ll.addFirst(p);
                    continue;
                }
                ll.add(p);
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return ll.isEmpty() ? null : ll.toArray(new JEditorPane[ll.size()]);
    }

    JEditorPane getRecentPane() {
        assert (SwingUtilities.isEventDispatchThread()) : "CloneableEditorSupport.getRecentPane must be called from AWT thread only";
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.getRecentPane();
        }
        Enumeration en = this.allEditors.getComponents();
        Pane last = this.getLastSelected();
        while (en.hasMoreElements()) {
            CloneableTopComponent ctc = (CloneableTopComponent)en.nextElement();
            Pane ed = (Pane)ctc.getClientProperty((Object)PROP_PANE);
            if (ed == null && ctc instanceof Pane) {
                ed = (Pane)ctc;
            }
            if (ed != null) {
                JEditorPane p = null;
                if (last == ed || last != null && last instanceof Component && ed instanceof Container && ((Container)((Object)ed)).isAncestorOf((Component)((Object)last))) {
                    if (ed instanceof CloneableEditor && ((CloneableEditor)ed).isEditorPaneReady()) {
                        p = ed.getEditorPane();
                    }
                    if (last instanceof CloneableEditor) {
                        if (((CloneableEditor)last).isEditorPaneReady()) {
                            p = ed.getEditorPane();
                        }
                    } else {
                        p = ed.getEditorPane();
                    }
                }
                if (p == null) continue;
                return p;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return null;
    }

    final Pane getLastSelected() {
        Reference<Pane> r = this.lastSelected;
        return r == null ? null : r.get();
    }

    final void setLastSelected(Pane lastSelected) {
        this.lastSelected = new WeakReference<Pane>(lastSelected);
    }

    public Line.Set getLineSet() {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.getLineSet();
        }
        return this.updateLineSet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<Line, Reference<Line>> findWeakHashMap() {
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.lineSetWHM != null) {
                return this.lineSetWHM;
            }
            this.lineSetWHM = new WeakHashMap<Line, Reference<Line>>();
            return this.lineSetWHM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            redirect.print();
            return;
        }
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.printing) {
                return;
            }
            this.printing = true;
        }
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            Object o = NbDocument.findPageable(this.openDocument());
            if (o instanceof Pageable) {
                job.setPageable((Pageable)o);
            } else {
                PageFormat pf = PrintPreferences.getPageFormat(job);
                job.setPrintable((Printable)o, pf);
            }
            if (job.printDialog()) {
                job.print();
            }
        }
        catch (FileNotFoundException e) {
            CloneableEditorSupport.notifyProblem(e, "CTL_Bad_File");
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        catch (PrinterAbortException e) {
            CloneableEditorSupport.notifyProblem(e, "CTL_Printer_Abort");
        }
        catch (PrinterException e) {
            CloneableEditorSupport.notifyProblem(e, "EXC_Printer_Problem");
        }
        finally {
            Object e = this.LOCK_PRINTING;
            synchronized (e) {
                this.printing = false;
            }
        }
    }

    private static void notifyProblem(Exception e, String key) {
        String msg = NbBundle.getMessage(CloneableEditorSupport.class, (String)key, (Object)e.getLocalizedMessage());
        Exceptions.attachLocalizedMessage((Throwable)e, (String)msg);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)e));
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        Pane pane = this.createPane();
        pane.getComponent().putClientProperty((Object)PROP_PANE, (Object)pane);
        return pane.getComponent();
    }

    protected Pane createPane() {
        CloneableEditor ed = this.createCloneableEditor();
        this.initializeCloneableEditor(ed);
        return ed;
    }

    protected Component wrapEditorComponent(Component editorComponent) {
        return editorComponent;
    }

    protected boolean canClose() {
        if (this.cesEnv().isModified()) {
            class SafeAWTAccess
            implements Runnable {
                boolean running;
                boolean finished;
                int ret;

                SafeAWTAccess() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SafeAWTAccess safeAWTAccess = this;
                    synchronized (safeAWTAccess) {
                        this.running = true;
                        this.notifyAll();
                    }
                    try {
                        this.ret = CloneableEditorSupport.this.canCloseImpl();
                    }
                    finally {
                        safeAWTAccess = this;
                        synchronized (safeAWTAccess) {
                            this.finished = true;
                            this.notifyAll();
                        }
                    }
                }

                public synchronized void waitForResult() throws InterruptedException {
                    if (!this.running) {
                        this.wait(10000L);
                    }
                    if (!this.running) {
                        throw new InterruptedException("Waiting 10s for AWT and nothing! Exiting to prevent deadlock");
                    }
                    while (!this.finished) {
                        this.wait();
                    }
                }
            }
            SafeAWTAccess safe = new SafeAWTAccess();
            if (SwingUtilities.isEventDispatchThread()) {
                safe.run();
            } else {
                SwingUtilities.invokeLater(safe);
                try {
                    safe.waitForResult();
                }
                catch (InterruptedException ex) {
                    ERR.log(Level.INFO, null, ex);
                    return false;
                }
            }
            if (safe.ret == 0) {
                return false;
            }
            if (safe.ret == 1) {
                try {
                    this.saveDocument();
                }
                catch (UserCancelException uce) {
                    return false;
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    private int canCloseImpl() {
        String msg = this.messageSave();
        ResourceBundle bundle = NbBundle.getBundle(CloneableEditorSupport.class);
        JButton saveOption = new JButton(bundle.getString("CTL_Save"));
        saveOption.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Save"));
        saveOption.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_CTL_Save"));
        JButton discardOption = new JButton(bundle.getString("CTL_Discard"));
        discardOption.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Discard"));
        discardOption.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_CTL_Discard"));
        discardOption.setMnemonic(bundle.getString("CTL_Discard_Mnemonic").charAt(0));
        NotifyDescriptor nd = new NotifyDescriptor((Object)msg, bundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{saveOption, discardOption, NotifyDescriptor.CANCEL_OPTION}, (Object)saveOption);
        Object ret = DialogDisplayer.getDefault().notify(nd);
        if (NotifyDescriptor.CANCEL_OPTION.equals(ret) || NotifyDescriptor.CLOSED_OPTION.equals(ret)) {
            return 0;
        }
        if (saveOption.equals(ret)) {
            return 1;
        }
        return -1;
    }

    public boolean isDocumentLoaded() {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.isDocumentLoaded();
        }
        return this.documentStatus != 0;
    }

    boolean isDocumentReady() {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.isDocumentReady();
        }
        return this.documentStatus == 2;
    }

    public void setMIMEType(String s) {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            redirect.setMIMEType(s);
            return;
        }
        this.mimeType = s;
    }

    @Deprecated
    public synchronized void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ChangeListener>(8);
        }
        this.listeners.add(l);
    }

    @Deprecated
    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public final PositionRef createPositionRef(int offset, Position.Bias bias) {
        return new PositionRef(this.getPositionManager(), offset, bias);
    }

    protected CloneableEditor createCloneableEditor() {
        return new CloneableEditor(this);
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedoManager(this);
    }

    public InputStream getInputStream() throws IOException {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.getInputStream();
        }
        StyledDocument tmpDoc = this.getDocument();
        if (tmpDoc == null) {
            return this.cesEnv().inputStream();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.saveFromKitToStream(tmpDoc, this.kit, baos);
        }
        catch (BadLocationException e) {
            ERR.log(Level.INFO, null, e);
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        kit.write(stream, (Document)doc, 0, doc.getLength());
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        kit.read(stream, (Document)doc, 0);
    }

    protected Task reloadDocument() {
        ERR.fine("reloadDocument in " + Thread.currentThread());
        if (this.getDoc() != null) {
            final JEditorPane[] panes = this.getOpenedPanes();
            NbDocument.runAtomic(this.getDoc(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] carets;
                    CloneableEditorSupport.this.getDoc().removeUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                    if (panes != null) {
                        carets = new int[panes.length];
                        for (int i = 0; i < panes.length; ++i) {
                            carets[i] = panes[i].getCaretPosition();
                        }
                    } else {
                        carets = new int[]{};
                    }
                    CloneableEditorSupport.this.documentStatus = 3;
                    CloneableEditorSupport.this.prepareDocumentRuntimeException = null;
                    class Query
                    implements Runnable,
                    Callable<Void> {
                        int targetStatus = 0;
                        UserQuestionException e;

                        Query() {
                        }

                        @Override
                        public void run() {
                            CloneableEditorSupport.this.askUserAndDoOpen(this.e, this);
                        }

                        @Override
                        public Void call() {
                            CloneableEditorSupport.this.getPositionManager().documentClosed();
                            CloneableEditorSupport.this.updateLineSet(true);
                            CloneableEditorSupport.this.reloadDocumentFireDocumentChangeClose = true;
                            ERR.fine("clearDocument");
                            CloneableEditorSupport.this.clearDocument();
                            CloneableEditorSupport.this.getListener().run();
                            CloneableEditorSupport.this.documentStatus = 2;
                            CloneableEditorSupport.this.reloadDocumentFireDocumentChangeOpen = true;
                            this.targetStatus = 2;
                            return null;
                        }
                    }
                    Query query = new Query();
                    try {
                        query.call();
                    }
                    catch (RuntimeException t) {
                        if (t.getCause() instanceof UserQuestionException) {
                            query.e = (UserQuestionException)t.getCause();
                            Mutex.EVENT.readAccess((Runnable)query);
                            return;
                        }
                        if (t.getCause() instanceof IOException) {
                            IOException ioe = (IOException)t.getCause();
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ioe.getLocalizedMessage(), 0));
                            return;
                        }
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = t;
                        throw t;
                    }
                    catch (Error t) {
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = t;
                        throw t;
                    }
                    finally {
                        Object object = CloneableEditorSupport.this.getLock();
                        synchronized (object) {
                            if (query.targetStatus == 0) {
                                CloneableEditorSupport.this.setDoc(null, false);
                            }
                            CloneableEditorSupport.this.documentStatus = query.targetStatus;
                            CloneableEditorSupport.this.getLock().notifyAll();
                        }
                    }
                    ERR.fine("post-reload task posting to AWT");
                    Runnable run1 = new Runnable(){

                        @Override
                        public void run() {
                            if (CloneableEditorSupport.this.getDoc() == null) {
                                return;
                            }
                            if (panes != null) {
                                for (int i = 0; i < panes.length; ++i) {
                                    int textLength = panes[i].getDocument().getLength();
                                    if (carets[i] > textLength) {
                                        carets[i] = textLength;
                                    }
                                    panes[i].setCaretPosition(carets[i]);
                                }
                            }
                        }
                    };
                    Runnable run2 = new Runnable(){

                        @Override
                        public void run() {
                            StyledDocument d = CloneableEditorSupport.this.getDoc();
                            if (d == null) {
                                return;
                            }
                            ERR.fine("task-discardAllEdits");
                            UndoRedo.Manager urm = CloneableEditorSupport.this.getUndoRedo();
                            urm.discardAllEdits();
                            if (urm instanceof UndoRedoManager) {
                                ((UndoRedoManager)urm).markSavepoint();
                            }
                            ERR.fine("task-check already modified");
                            if (CloneableEditorSupport.this.isAlreadyModified()) {
                                ERR.fine("task-callNotifyUnmodified");
                                CloneableEditorSupport.this.callNotifyUnmodified();
                            }
                            CloneableEditorSupport.this.updateLineSet(true);
                            ERR.fine("task-addUndoableEditListener");
                            d.addUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                        }
                    };
                    if (CloneableEditorSupport.this.getDoc() != null) {
                        ERR.fine("Posting the AWT runnable: " + run2);
                        run1.run();
                        SwingUtilities.invokeLater(run2);
                        ERR.fine("Posted in " + Thread.currentThread());
                    }
                }
            });
        }
        return this.prepareDocument();
    }

    public static EditorKit getEditorKit(String mimePath) {
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)mimePath));
        EditorKit kit = (EditorKit)lookup.lookup(EditorKit.class);
        if (kit == null) {
            lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/plain"));
            kit = (EditorKit)lookup.lookup(EditorKit.class);
        }
        return kit != null ? (EditorKit)kit.clone() : new PlainEditorKit();
    }

    protected EditorKit createEditorKit() {
        if (this.kit != null) {
            return this.kit;
        }
        if (this.mimeType != null) {
            this.kit = CloneableEditorSupport.getEditorKit(this.mimeType);
        } else {
            String defaultMIMEType = this.cesEnv().getMimeType();
            this.kit = CloneableEditorSupport.getEditorKit(defaultMIMEType);
        }
        return this.kit;
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument sd = CloneableEditorSupport.createNetBeansDocument(kit.createDefaultDocument());
        sd.putProperty("mimeType", this.mimeType != null ? this.mimeType : this.cesEnv().getMimeType());
        return sd;
    }

    protected void notifyUnmodified() {
        this.env.unmarkModified();
        if (!Boolean.TRUE.equals(LOCAL_CLOSE_DOCUMENT.get())) {
            this.updateTitles();
        }
    }

    final boolean callNotifyModified() {
        if (!this.isAlreadyModified() && !this.documentReloading) {
            this.setAlreadyModified(true);
            if (!this.notifyModified()) {
                this.setAlreadyModified(false);
                return false;
            }
        }
        return true;
    }

    final void callNotifyUnmodified() {
        this.setAlreadyModified(false);
        this.notifyUnmodified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyModified() {
        boolean locked = true;
        try {
            this.env.markModified();
        }
        catch (UserQuestionException ex) {
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                if (!this.inUserQuestionExceptionHandler) {
                    this.inUserQuestionExceptionHandler = true;
                    RP.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)ex.getLocalizedMessage(), 0);
                            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                            if (NotifyDescriptor.OK_OPTION.equals(res)) {
                                try {
                                    ex.confirmed();
                                }
                                catch (IOException ex1) {
                                    Exceptions.printStackTrace((Throwable)ex1);
                                }
                            }
                            CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupport.this;
                            synchronized (cloneableEditorSupport) {
                                CloneableEditorSupport.this.inUserQuestionExceptionHandler = false;
                            }
                        }
                    });
                }
            }
            locked = false;
            ERR.log(Level.FINE, "Could not lock document", ex);
        }
        catch (IOException e) {
            ERR.log(Level.FINE, "Could not lock document", e);
            String message = null;
            message = e.getMessage() != e.getLocalizedMessage() ? e.getLocalizedMessage() : Exceptions.findLocalizedMessage((Throwable)e);
            if (message != null) {
                StatusDisplayer.getDefault().setStatusText(message);
            }
            locked = false;
        }
        if (!locked) {
            Toolkit.getDefaultToolkit().beep();
            ERR.log(Level.FINE, "notifyModified returns false");
            return false;
        }
        lastReusable.clear();
        this.updateTitles();
        return true;
    }

    protected void notifyClosed() {
        this.closeDocument();
    }

    boolean isEnvReadOnly() {
        return false;
    }

    final StyledDocument getDocumentHack() {
        return this.getDoc();
    }

    final Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set updateLineSet(boolean clear) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.lineSet != null && !clear) {
                return this.lineSet;
            }
            Line.Set oldSet = this.lineSet;
            this.lineSet = this.getDoc() == null || this.documentStatus == 3 ? new EditorSupportLineSet.Closed(this) : new EditorSupportLineSet(this, this.getDoc());
            return this.lineSet;
        }
    }

    /*
     * Exception decompiling
     */
    private void loadDocument(EditorKit kit, StyledDocument doc) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean close(boolean ask) {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.close(ask);
        }
        if (!super.close(ask)) {
            return false;
        }
        this.notifyClosed();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void closeDocument() {
        boolean fireEvent = false;
        StyledDocument d = null;
        try {
            Object object = this.getLock();
            // MONITORENTER : object
            switch (this.documentStatus) {
                case 0: {
                    // MONITOREXIT : object
                    if (!fireEvent) return;
                    this.fireDocumentChange(d, true);
                    return;
                }
            }
            d = this.getDoc();
            fireEvent = this.doCloseDocument();
        }
        catch (Throwable throwable) {
            if (!fireEvent) throw throwable;
            this.fireDocumentChange(d, true);
            throw throwable;
        }
        if (!fireEvent) return;
        this.fireDocumentChange(d, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCloseDocument() {
        boolean fireEvent = false;
        this.cesEnv().removePropertyChangeListener(this.getListener());
        try {
            LOCAL_CLOSE_DOCUMENT.set(Boolean.TRUE);
            this.callNotifyUnmodified();
        }
        finally {
            LOCAL_CLOSE_DOCUMENT.set(Boolean.FALSE);
        }
        StyledDocument d = this.getDoc();
        if (d != null) {
            d.removeUndoableEditListener((UndoableEditListener)this.getUndoRedo());
            this.addRemoveDocListener(d, false);
        }
        if (this.positionManager != null) {
            this.positionManager.documentClosed();
        }
        this.documentStatus = 0;
        fireEvent = true;
        this.setDoc(null, false);
        this.kit = null;
        this.getUndoRedo().discardAllEdits();
        this.updateLineSet(true);
        return fireEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReload(boolean doReload) {
        StyledDocument d;
        Object object = this.getLock();
        synchronized (object) {
            if (this.documentStatus != 2) {
                return;
            }
            d = this.getDoc();
        }
        if (!doReload && !this.reloadDialogOpened) {
            String msg = NbBundle.getMessage(CloneableEditorSupport.class, (String)"FMT_External_change", (Object)d.getProperty("title"));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
            this.reloadDialogOpened = true;
            try {
                Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (NotifyDescriptor.YES_OPTION.equals(ret)) {
                    doReload = true;
                }
            }
            finally {
                this.reloadDialogOpened = false;
            }
        }
        object = this.getLock();
        synchronized (object) {
            if (this.documentStatus != 2) {
                return;
            }
            if (doReload) {
                this.reloadDocument();
            }
        }
        if (this.reloadDocumentFireDocumentChangeClose) {
            this.reloadDocumentFireDocumentChangeClose = false;
            this.fireDocumentChange(this.getDoc(), true);
        }
        if (this.reloadDocumentFireDocumentChangeOpen) {
            this.reloadDocumentFireDocumentChangeOpen = false;
            this.fireDocumentChange(this.getDoc(), false);
        }
    }

    private static StyledDocument createNetBeansDocument(Document d) {
        if (d instanceof StyledDocument) {
            return (StyledDocument)d;
        }
        return new FilterDocument(d);
    }

    private final void fireDocumentChange(StyledDocument document, boolean closing) {
        this.fireStateChangeEvent(document, closing);
        this.firePropertyChange("document", closing ? document : null, closing ? null : document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireStateChangeEvent(StyledDocument document, boolean closing) {
        if (this.listeners != null) {
            ChangeListener[] ls;
            EnhancedChangeEvent event = new EnhancedChangeEvent((Object)this, document, closing);
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            for (ChangeListener l : ls) {
                l.stateChanged(event);
            }
        }
    }

    protected void updateTitles() {
        Enumeration en = this.allEditors.getComponents();
        while (en.hasMoreElements()) {
            CloneableTopComponent o = (CloneableTopComponent)en.nextElement();
            Pane e = (Pane)o.getClientProperty((Object)PROP_PANE);
            if (e == null && o instanceof Pane) {
                e = (Pane)o;
            }
            if (e != null) {
                e.updateName();
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
    }

    private static void replaceTc(TopComponent orig, TopComponent open) {
        int pos = orig.getTabPosition();
        orig.close();
        open.openAtTabPosition(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pane openPane(boolean reuse) {
        String msg;
        Pane ce = null;
        boolean displayMsgOpened = false;
        Object object = this.getLock();
        synchronized (object) {
            ce = this.getAnyEditor();
            if (ce == null) {
                msg = this.messageOpening();
                if (msg != null) {
                    StatusDisplayer.getDefault().setStatusText(msg);
                }
                this.prepareDocument();
                ce = this.createPane();
                ce.getComponent().putClientProperty((Object)PROP_PANE, (Object)ce);
                ce.getComponent().setReference(this.allEditors);
                displayMsgOpened = true;
            }
        }
        CloneableTopComponent ctc = ce.getComponent();
        if (reuse && displayMsgOpened) {
            CloneableTopComponent last = lastReusable.get();
            if (last != null) {
                CloneableEditorSupport.replaceTc((TopComponent)last, (TopComponent)ctc);
            } else {
                ctc.open();
            }
            lastReusable = new WeakReference<CloneableTopComponent>(ctc);
        } else {
            ctc.open();
        }
        if (displayMsgOpened) {
            msg = this.messageOpened();
            if (msg == null) {
                msg = "";
            }
            StatusDisplayer.getDefault().setStatusText(msg);
        }
        return ce;
    }

    Pane getAnyEditor() {
        CloneableTopComponent ctc = this.allEditors.getArbitraryComponent();
        if (ctc == null) {
            return null;
        }
        Pane e = (Pane)ctc.getClientProperty((Object)PROP_PANE);
        if (e != null) {
            return e;
        }
        if (ctc instanceof Pane) {
            return (Pane)ctc;
        }
        Enumeration en = this.allEditors.getComponents();
        if (en.hasMoreElements()) {
            ctc = (CloneableTopComponent)en.nextElement();
            e = (Pane)ctc.getClientProperty((Object)PROP_PANE);
            if (e != null) {
                return e;
            }
            if (ctc instanceof Pane) {
                return (Pane)ctc;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return null;
    }

    @Deprecated
    final Pane openReuse(PositionRef pos, int column, int mode) {
        if (mode == 5) {
            lastReusable.clear();
        }
        return this.openAtImpl(pos, column, true);
    }

    final Pane openReuse(PositionRef pos, int column, Line.ShowOpenType mode) {
        if (mode == Line.ShowOpenType.REUSE_NEW) {
            lastReusable.clear();
        }
        return this.openAtImpl(pos, column, true);
    }

    protected final Pane openAt(PositionRef pos, int column) {
        return this.openAtImpl(pos, column, false);
    }

    private final Pane openAtImpl(final PositionRef pos, final int column, boolean reuse) {
        CloneableEditorSupport redirect = CloneableEditorSupportRedirector.findRedirect(this);
        if (redirect != null) {
            return redirect.openAtImpl(pos, column, reuse);
        }
        ++this.counterOpenAtImpl;
        final Pane e = this.openPane(reuse);
        Task t = this.prepareDocument();
        e.ensureVisible();
        class Selector
        implements TaskListener,
        Runnable {
            private boolean documentLocked = false;
            private int counterRun = 0;

            Selector() {
            }

            public void taskFinished(Task t2) {
                SwingUtilities.invokeLater(this);
                t2.removeTaskListener((TaskListener)this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block16: {
                    ++this.counterRun;
                    try {
                        JEditorPane ePane = e.getEditorPane();
                        if (ePane == null) {
                            return;
                        }
                        StyledDocument doc = CloneableEditorSupport.this.getDocument();
                        if (doc == null) {
                            return;
                        }
                        if (!this.documentLocked) {
                            this.documentLocked = true;
                            doc.render(this);
                            break block16;
                        }
                        Caret caret = ePane.getCaret();
                        if (caret == null) {
                            return;
                        }
                        Element el = NbDocument.findLineRootElement(doc);
                        int offset = (el = el.getElement(el.getElementIndex(pos.getOffset()))).getStartOffset() + Math.max(0, column);
                        if (offset > el.getEndOffset()) {
                            offset = Math.max(el.getStartOffset(), el.getEndOffset() - 1);
                        }
                        caret.setDot(offset);
                        try {
                            Rectangle r = ePane.modelToView(offset);
                            if (r != null) {
                                r.height *= 5;
                                ePane.scrollRectToVisible(r);
                            }
                        }
                        catch (BadLocationException ex) {
                            ERR.log(Level.WARNING, "Can't scroll to text: pos.getOffset=" + pos.getOffset() + ", column=" + column + ", offset=" + offset + ", doc.getLength=" + doc.getLength(), ex);
                        }
                    }
                    finally {
                        --this.counterRun;
                        if (this.counterRun == 0) {
                            CloneableEditorSupport.this.counterOpenAtImpl--;
                            if (CloneableEditorSupport.this.isStrongSet && CloneableEditorSupport.this.canReleaseDoc()) {
                                CloneableEditorSupport.this.isStrongSet = false;
                                CloneableEditorSupport.this.setStrong(false, true);
                            }
                        }
                    }
                }
            }
        }
        t.addTaskListener((TaskListener)new Selector());
        return e;
    }

    final Object getLock() {
        return this.allEditors;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    void howToReproduceDeadlock40766(boolean beforeLock) {
    }

    final void setLastSaveTime(long lst) {
        ERR.fine("Setting new lastSaveTime to " + lst);
        this.lastSaveTime = lst;
    }

    final boolean isAlreadyModified() {
        return this.alreadyModified;
    }

    final void setAlreadyModified(boolean alreadyModified) {
        ERR.log(Level.FINE, null, new Exception("Setting to modified: " + alreadyModified));
        this.alreadyModified = alreadyModified;
        this.setStrong(alreadyModified, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StyledDocument getDoc() {
        Object object = this.LOCK_STRONG_REF;
        synchronized (object) {
            StrongRef _doc = this.doc;
            return _doc != null ? _doc.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDoc(StyledDocument doc, boolean strong) {
        Object object = this.LOCK_STRONG_REF;
        synchronized (object) {
            if (doc == null) {
                this.doc = null;
                return;
            }
            this.doc = new StrongRef(doc, strong);
            Logger.getLogger("TIMER").log(Level.FINE, "TextDocument", doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStrong(boolean strong, boolean setFlag) {
        Object object = this.LOCK_STRONG_REF;
        synchronized (object) {
            if (this.doc != null) {
                if (strong) {
                    this.doc.setStrong(true);
                    if (setFlag) {
                        this.isStrongSet = true;
                    }
                } else if (!this.isAlreadyModified()) {
                    this.doc.setStrong(false);
                }
            }
        }
    }

    private final class DocFilter
    extends DocumentFilter {
        final DocumentFilter origFilter;

        DocFilter(DocumentFilter origFilter) {
            this.origFilter = origFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            boolean origModified = this.checkModificationAllowed(offset);
            boolean success = false;
            try {
                if (this.origFilter != null) {
                    this.origFilter.insertString(fb, offset, string, attr);
                } else {
                    super.insertString(fb, offset, string, attr);
                }
                success = true;
            }
            finally {
                if (!success && !origModified) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            boolean origModified = this.checkModificationAllowed(offset);
            boolean success = false;
            try {
                if (this.origFilter != null) {
                    this.origFilter.remove(fb, offset, length);
                } else {
                    super.remove(fb, offset, length);
                }
                success = true;
            }
            finally {
                if (!success && !origModified) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            boolean origModified = this.checkModificationAllowed(offset);
            boolean success = false;
            try {
                if (this.origFilter != null) {
                    this.origFilter.replace(fb, offset, length, text, attrs);
                } else {
                    super.replace(fb, offset, length, text, attrs);
                }
                success = true;
            }
            finally {
                if (!success && !origModified) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        private boolean checkModificationAllowed(int offset) throws BadLocationException {
            boolean alreadyModified = CloneableEditorSupport.this.isAlreadyModified();
            if (!CloneableEditorSupport.this.callNotifyModified()) {
                throw new BadLocationException("Modification not allowed", offset);
            }
            return alreadyModified;
        }
    }

    static final class DelegateIOExc
    extends IllegalStateException {
        public DelegateIOExc(IOException ex) {
            super(ex.getMessage());
            this.initCause(ex);
        }
    }

    private final class Listener
    implements PropertyChangeListener,
    DocumentListener,
    Runnable,
    VetoableChangeListener {
        private IOException loadExc;
        private boolean revertModifiedFlag;

        Listener() {
        }

        public IOException checkLoadException() {
            IOException ret = this.loadExc;
            return ret;
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if ("modified".equals(evt.getPropertyName())) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    boolean wasModified = CloneableEditorSupport.this.isAlreadyModified();
                    if (!CloneableEditorSupport.this.callNotifyModified()) {
                        throw new PropertyVetoException("Not allowed", evt);
                    }
                    this.revertModifiedFlag = !wasModified;
                } else if (this.revertModifiedFlag) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if ("expectedTime".equals(ev.getPropertyName())) {
                CloneableEditorSupport.this.lastSaveTime = ((Date)ev.getNewValue()).getTime();
            }
            if ("time".equals(ev.getPropertyName())) {
                final Date time = (Date)ev.getNewValue();
                ERR.fine("PROP_TIME new value: " + time + ", " + (time != null ? time.getTime() : -1L));
                ERR.fine("       lastSaveTime: " + new Date(CloneableEditorSupport.this.lastSaveTime) + ", " + CloneableEditorSupport.this.lastSaveTime);
                boolean reload = CloneableEditorSupport.this.lastSaveTime != -1L && (time == null || time.getTime() > CloneableEditorSupport.this.lastSaveTime);
                ERR.fine("             reload: " + reload);
                if (reload) {
                    SwingUtilities.invokeLater(new Runnable(){
                        boolean inWriteAccess;

                        @Override
                        public void run() {
                            if (!this.inWriteAccess) {
                                this.inWriteAccess = true;
                                StyledDocument sd = CloneableEditorSupport.this.getDoc();
                                if (sd == null) {
                                    return;
                                }
                                CloneableEditorSupport.this.documentReloading = true;
                                NbDocument.runAtomic(sd, this);
                                CloneableEditorSupport.this.documentReloading = false;
                                return;
                            }
                            ERR.fine("checkReload starting");
                            boolean noAsk = time == null || !CloneableEditorSupport.this.isModified();
                            ERR.fine("checkReload noAsk: " + noAsk);
                            CloneableEditorSupport.this.checkReload(noAsk);
                        }
                    });
                    ERR.fine("reload task posted");
                }
            }
            if ("modified".equals(ev.getPropertyName())) {
                CloneableEditorSupport.this.firePropertyChange("modified", ev.getOldValue(), ev.getNewValue());
            }
            if ("DataEditorSupport.read-only.changing".equals(ev.getPropertyName())) {
                CloneableEditorSupport.this.updateTitles();
            }
        }

        @Override
        public void run() {
            CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), false);
            try {
                this.loadExc = null;
                LOCAL_LOAD_TASK.set(true);
                CloneableEditorSupport.this.loadDocument(CloneableEditorSupport.this.kit, CloneableEditorSupport.this.getDoc());
            }
            catch (IOException e) {
                this.loadExc = e;
                throw new DelegateIOExc(e);
            }
            finally {
                LOCAL_LOAD_TASK.set(null);
            }
            CloneableEditorSupport.this.getPositionManager().documentOpened(CloneableEditorSupport.this.doc);
            CloneableEditorSupport.this.updateLineSet(true);
            CloneableEditorSupport.this.setLastSaveTime(CloneableEditorSupport.this.cesEnv().getTime().getTime());
            CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), true);
        }
    }

    private static final class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        static final long serialVersionUID = -5788777967029507963L;

        PlainEditorKit() {
        }

        @Override
        public Object clone() {
            return new PlainEditorKit();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this;
        }

        @Override
        public View create(Element elem) {
            return new WrappedPlainView(elem);
        }

        @Override
        public void install(JEditorPane pane) {
            super.install(pane);
            pane.setFont(new Font("Monospaced", 0, pane.getFont().getSize() + 1));
        }
    }

    public static interface Pane {
        public JEditorPane getEditorPane();

        public CloneableTopComponent getComponent();

        public void updateName();

        public void ensureVisible();
    }

    public static interface Env
    extends CloneableOpenSupport.Env {
        public static final String PROP_TIME = "time";

        public InputStream inputStream() throws IOException;

        public OutputStream outputStream() throws IOException;

        public Date getTime();

        public String getMimeType();
    }

    private final class StrongRef
    extends WeakReference<StyledDocument>
    implements Runnable {
        private StyledDocument doc;

        public StrongRef(StyledDocument doc, boolean strong) {
            super(doc, Utilities.activeReferenceQueue());
            if (strong) {
                this.doc = doc;
            }
        }

        @Override
        public StyledDocument get() {
            return this.doc != null ? this.doc : (StyledDocument)super.get();
        }

        @Override
        public void run() {
            if (this != CloneableEditorSupport.this.doc) {
                return;
            }
            CloneableEditorSupport.this.closeDocument();
        }

        private void setStrong(boolean alreadyModified) {
            this.doc = alreadyModified ? (StyledDocument)super.get() : null;
        }

        public String toString() {
            return "StrongRef@" + Integer.toHexString(System.identityHashCode(this)) + "[doc=" + this.doc + ",super.get=" + super.get() + "]";
        }
    }
}

