/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.Message;
import net.sf.clirr.core.ScopeSelector;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.internal.AbstractDiffReporter;
import net.sf.clirr.core.internal.ApiDiffDispatcher;
import net.sf.clirr.core.internal.ClassChangeCheck;
import net.sf.clirr.core.internal.CoIterator;
import net.sf.clirr.core.spi.JavaType;
import net.sf.clirr.core.spi.Method;
import net.sf.clirr.core.spi.Scope;

public class MethodSetCheck
extends AbstractDiffReporter
implements ClassChangeCheck {
    private static final Message MSG_METHOD_NOW_IN_SUPERCLASS = new Message(7000);
    private static final Message MSG_METHOD_NOW_IN_INTERFACE = new Message(7001);
    private static final Message MSG_METHOD_REMOVED = new Message(7002);
    private static final Message MSG_METHOD_OVERRIDE_REMOVED = new Message(7003);
    private static final Message MSG_METHOD_ARGCOUNT_CHANGED = new Message(7004);
    private static final Message MSG_METHOD_PARAMTYPE_CHANGED = new Message(7005);
    private static final Message MSG_METHOD_RETURNTYPE_CHANGED = new Message(7006);
    private static final Message MSG_METHOD_DEPRECATED = new Message(7007);
    private static final Message MSG_METHOD_UNDEPRECATED = new Message(7008);
    private static final Message MSG_METHOD_LESS_ACCESSIBLE = new Message(7009);
    private static final Message MSG_METHOD_MORE_ACCESSIBLE = new Message(7010);
    private static final Message MSG_METHOD_ADDED = new Message(7011);
    private static final Message MSG_METHOD_ADDED_TO_INTERFACE = new Message(7012);
    private static final Message MSG_ABSTRACT_METHOD_ADDED = new Message(7013);
    private static final Message MSG_METHOD_NOW_FINAL = new Message(7014);
    private static final Message MSG_METHOD_NOW_NONFINAL = new Message(7015);
    private ScopeSelector scopeSelector;

    public MethodSetCheck(ApiDiffDispatcher dispatcher, ScopeSelector scopeSelector) {
        super(dispatcher);
        this.scopeSelector = scopeSelector;
    }

    public final boolean check(JavaType compatBaseline, JavaType currentVersion) {
        if (compatBaseline.isInterface() ^ currentVersion.isInterface()) {
            return true;
        }
        Map bNameToMethod = this.buildNameToMethodMap(compatBaseline);
        Map cNameToMethod = this.buildNameToMethodMap(currentVersion);
        CoIterator iter = new CoIterator(null, bNameToMethod.keySet(), cNameToMethod.keySet());
        while (iter.hasNext()) {
            List baselineMethods;
            iter.next();
            String baselineMethodName = (String)iter.getLeft();
            String currentMethodName = (String)iter.getRight();
            if (baselineMethodName == null) {
                List currentMethods = (List)cNameToMethod.get(currentMethodName);
                this.reportMethodsAdded(currentVersion, currentMethods);
                continue;
            }
            if (currentMethodName == null) {
                baselineMethods = (List)bNameToMethod.get(baselineMethodName);
                this.reportMethodsRemoved(compatBaseline, baselineMethods, currentVersion);
                continue;
            }
            baselineMethods = (List)bNameToMethod.get(baselineMethodName);
            List currentMethods = (List)cNameToMethod.get(currentMethodName);
            this.filterSoftMatchedMethods(compatBaseline, baselineMethods, currentVersion, currentMethods);
            this.filterChangedMethods(baselineMethodName, compatBaseline, baselineMethods, currentVersion, currentMethods);
            if (!baselineMethods.isEmpty()) {
                this.reportMethodsRemoved(compatBaseline, baselineMethods, currentVersion);
            }
            if (currentMethods.isEmpty()) continue;
            this.reportMethodsAdded(currentVersion, currentMethods);
        }
        return true;
    }

    private void filterSoftMatchedMethods(JavaType compatBaseline, List baselineMethods, JavaType currentVersion, List currentMethods) {
        Iterator bIter = baselineMethods.iterator();
        block0: while (bIter.hasNext()) {
            Method bMethod = (Method)bIter.next();
            Iterator cIter = currentMethods.iterator();
            while (cIter.hasNext()) {
                Method cMethod = (Method)cIter.next();
                if (!this.isSoftMatch(bMethod, cMethod)) continue;
                this.check(compatBaseline, bMethod, cMethod);
                bIter.remove();
                cIter.remove();
                continue block0;
            }
        }
    }

    private boolean isSoftMatch(Method oldMethod, Method newMethod) {
        String newName;
        String oldName = oldMethod.getName();
        if (!oldName.equals(newName = newMethod.getName())) {
            return false;
        }
        StringBuffer buf = new StringBuffer();
        this.appendHumanReadableArgTypeList(oldMethod, buf);
        String oldArgs = buf.toString();
        buf.setLength(0);
        this.appendHumanReadableArgTypeList(newMethod, buf);
        String newArgs = buf.toString();
        return oldArgs.equals(newArgs);
    }

    private void filterChangedMethods(String methodName, JavaType compatBaseline, List baselineMethods, JavaType currentVersion, List currentMethods) {
        while (!baselineMethods.isEmpty() && !currentMethods.isEmpty()) {
            int[][] similarityTable = this.buildSimilarityTable(baselineMethods, currentMethods);
            int min = Integer.MAX_VALUE;
            int iMin = baselineMethods.size();
            int jMin = currentMethods.size();
            for (int i = 0; i < baselineMethods.size(); ++i) {
                for (int j = 0; j < currentMethods.size(); ++j) {
                    int tableEntry = similarityTable[i][j];
                    if (tableEntry >= min) continue;
                    min = tableEntry;
                    iMin = i;
                    jMin = j;
                }
            }
            Method iMethod = (Method)baselineMethods.remove(iMin);
            Method jMethod = (Method)currentMethods.remove(jMin);
            this.check(compatBaseline, iMethod, jMethod);
        }
    }

    private int[][] buildSimilarityTable(List baselineMethods, List currentMethods) {
        int[][] similarityTable = new int[baselineMethods.size()][currentMethods.size()];
        for (int i = 0; i < baselineMethods.size(); ++i) {
            for (int j = 0; j < currentMethods.size(); ++j) {
                Method iMethod = (Method)baselineMethods.get(i);
                Method jMethod = (Method)currentMethods.get(j);
                similarityTable[i][j] = this.distance(iMethod, jMethod);
            }
        }
        return similarityTable;
    }

    private int distance(Method m1, Method m2) {
        JavaType[] m2Args;
        JavaType[] m1Args = m1.getArgumentTypes();
        if (m1Args.length != (m2Args = m2.getArgumentTypes()).length) {
            return 1000 * Math.abs(m1Args.length - m2Args.length);
        }
        int retVal = 0;
        for (int i = 0; i < m1Args.length; ++i) {
            if (m1Args[i].toString().equals(m2Args[i].toString())) continue;
            ++retVal;
        }
        return retVal;
    }

    private String findSuperClassWithSignature(String methodSignature, JavaType clazz) {
        JavaType[] superClasses = clazz.getSuperClasses();
        for (int i = 0; i < superClasses.length; ++i) {
            JavaType superClass = superClasses[i];
            Method[] superMethods = superClass.getMethods();
            for (int j = 0; j < superMethods.length; ++j) {
                Method superMethod = superMethods[j];
                String superMethodSignature = this.getMethodId(superClass, superMethod);
                if (!methodSignature.equals(superMethodSignature)) continue;
                return superClass.getName();
            }
        }
        return null;
    }

    private String findSuperInterfaceWithSignature(String methodSignature, JavaType clazz) {
        JavaType[] superClasses = clazz.getAllInterfaces();
        for (int i = 0; i < superClasses.length; ++i) {
            JavaType superClass = superClasses[i];
            Method[] superMethods = superClass.getMethods();
            for (int j = 0; j < superMethods.length; ++j) {
                Method superMethod = superMethods[j];
                String superMethodSignature = this.getMethodId(superClass, superMethod);
                if (!methodSignature.equals(superMethodSignature)) continue;
                return superClass.getName();
            }
        }
        return null;
    }

    private void reportMethodsRemoved(JavaType baselineClass, List baselineMethods, JavaType currentClass) {
        Iterator i = baselineMethods.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            this.reportMethodRemoved(baselineClass, method, currentClass);
        }
    }

    private void reportMethodRemoved(JavaType oldClass, Method oldMethod, JavaType currentClass) {
        boolean newInheritedMethod;
        if (!this.scopeSelector.isSelected(oldMethod)) {
            return;
        }
        String signature = this.getMethodId(oldClass, oldMethod);
        String oldBaseClassForMethod = this.findSuperClassWithSignature(signature, oldClass);
        String oldInterfaceForMethod = this.findSuperInterfaceWithSignature(signature, oldClass);
        String newBaseClassForMethod = this.findSuperClassWithSignature(signature, currentClass);
        String newInterfaceForMethod = this.findSuperInterfaceWithSignature(signature, currentClass);
        boolean oldInheritedMethod = oldBaseClassForMethod != null || oldInterfaceForMethod != null;
        boolean bl = newInheritedMethod = newBaseClassForMethod != null || newInterfaceForMethod != null;
        if (oldInheritedMethod && newInheritedMethod) {
            this.fireDiff(MSG_METHOD_OVERRIDE_REMOVED, Severity.INFO, oldClass, oldMethod, null);
        } else if (oldInheritedMethod) {
            this.fireDiff(MSG_METHOD_REMOVED, this.getSeverity(oldClass, oldMethod, Severity.ERROR), oldClass, oldMethod, null);
        } else if (newBaseClassForMethod != null) {
            this.fireDiff(MSG_METHOD_NOW_IN_SUPERCLASS, Severity.INFO, oldClass, oldMethod, new String[]{newBaseClassForMethod});
        } else if (newInterfaceForMethod != null) {
            this.fireDiff(MSG_METHOD_NOW_IN_INTERFACE, Severity.INFO, oldClass, oldMethod, new String[]{newInterfaceForMethod});
        } else {
            this.fireDiff(MSG_METHOD_REMOVED, this.getSeverity(oldClass, oldMethod, Severity.ERROR), oldClass, oldMethod, null);
        }
    }

    private void reportMethodsAdded(JavaType currentClass, List currentMethods) {
        Iterator i = currentMethods.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            this.reportMethodAdded(currentClass, method);
        }
    }

    private void reportMethodAdded(JavaType newClass, Method newMethod) {
        if (!this.scopeSelector.isSelected(newMethod)) {
            return;
        }
        if (newClass.isInterface()) {
            this.fireDiff(MSG_METHOD_ADDED_TO_INTERFACE, this.getSeverity(newClass, newMethod, Severity.ERROR), newClass, newMethod, null);
        } else if (newMethod.isAbstract()) {
            this.fireDiff(MSG_ABSTRACT_METHOD_ADDED, Severity.ERROR, newClass, newMethod, null);
        } else {
            this.fireDiff(MSG_METHOD_ADDED, Severity.INFO, newClass, newMethod, null);
        }
    }

    private Map buildNameToMethodMap(JavaType clazz) {
        Method[] methods = clazz.getMethods();
        HashMap<String, ArrayList<Method>> retVal = new HashMap<String, ArrayList<Method>>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            ArrayList<Method> set = (ArrayList<Method>)retVal.get(name);
            if (set == null) {
                set = new ArrayList<Method>();
                retVal.put(name, set);
            }
            set.add(method);
        }
        return retVal;
    }

    private void check(JavaType compatBaseline, Method baselineMethod, Method currentMethod) {
        if (!this.scopeSelector.isSelected(baselineMethod) && !this.scopeSelector.isSelected(currentMethod)) {
            return;
        }
        this.checkParameterTypes(compatBaseline, baselineMethod, currentMethod);
        this.checkReturnType(compatBaseline, baselineMethod, currentMethod);
        this.checkDeclaredExceptions(compatBaseline, baselineMethod, currentMethod);
        this.checkDeprecated(compatBaseline, baselineMethod, currentMethod);
        this.checkVisibility(compatBaseline, baselineMethod, currentMethod);
        this.checkFinal(compatBaseline, baselineMethod, currentMethod);
    }

    private void checkParameterTypes(JavaType compatBaseline, Method baselineMethod, Method currentMethod) {
        JavaType[] cArgs;
        JavaType[] bArgs = baselineMethod.getArgumentTypes();
        if (bArgs.length != (cArgs = currentMethod.getArgumentTypes()).length) {
            this.fireDiff(MSG_METHOD_ARGCOUNT_CHANGED, this.getSeverity(compatBaseline, baselineMethod, Severity.ERROR), compatBaseline, baselineMethod, null);
            return;
        }
        for (int i = 0; i < bArgs.length; ++i) {
            JavaType bArg = bArgs[i];
            JavaType cArg = cArgs[i];
            if (bArg.getName().equals(cArg.getName())) continue;
            String[] args = new String[]{"" + (i + 1), cArg.toString()};
            this.fireDiff(MSG_METHOD_PARAMTYPE_CHANGED, this.getSeverity(compatBaseline, baselineMethod, Severity.ERROR), compatBaseline, baselineMethod, args);
        }
    }

    private void checkReturnType(JavaType compatBaseline, Method baselineMethod, Method currentMethod) {
        JavaType bReturnType = baselineMethod.getReturnType();
        JavaType cReturnType = currentMethod.getReturnType();
        if (!bReturnType.toString().equals(cReturnType.toString())) {
            this.fireDiff(MSG_METHOD_RETURNTYPE_CHANGED, this.getSeverity(compatBaseline, baselineMethod, Severity.ERROR), compatBaseline, baselineMethod, new String[]{cReturnType.toString()});
        }
    }

    private void checkDeclaredExceptions(JavaType compatBaseline, Method baselineMethod, Method currentMethod) {
    }

    private void checkDeprecated(JavaType compatBaseline, Method baselineMethod, Method currentMethod) {
        boolean bIsDeprecated = baselineMethod.isDeprecated();
        boolean cIsDeprecated = currentMethod.isDeprecated();
        if (bIsDeprecated && !cIsDeprecated) {
            this.fireDiff(MSG_METHOD_UNDEPRECATED, Severity.INFO, compatBaseline, baselineMethod, null);
        } else if (!bIsDeprecated && cIsDeprecated) {
            this.fireDiff(MSG_METHOD_DEPRECATED, Severity.INFO, compatBaseline, baselineMethod, null);
        }
    }

    private void checkVisibility(JavaType compatBaseline, Method baselineMethod, Method currentMethod) {
        Scope bScope = baselineMethod.getEffectiveScope();
        Scope cScope = currentMethod.getEffectiveScope();
        if (cScope.isLessVisibleThan(bScope)) {
            String[] args = new String[]{bScope.getDesc(), cScope.getDesc()};
            this.fireDiff(MSG_METHOD_LESS_ACCESSIBLE, this.getSeverity(compatBaseline, baselineMethod, Severity.ERROR), compatBaseline, baselineMethod, args);
        } else if (cScope.isMoreVisibleThan(bScope)) {
            String[] args = new String[]{bScope.getDesc(), cScope.getDesc()};
            this.fireDiff(MSG_METHOD_MORE_ACCESSIBLE, Severity.INFO, compatBaseline, baselineMethod, args);
        }
    }

    private void checkFinal(JavaType compatBaseline, Method baselineMethod, Method currentMethod) {
        boolean bIsFinal = baselineMethod.isFinal();
        boolean cIsFinal = currentMethod.isFinal();
        if (bIsFinal && !cIsFinal) {
            this.fireDiff(MSG_METHOD_NOW_NONFINAL, Severity.INFO, compatBaseline, baselineMethod, null);
        } else if (!bIsFinal && cIsFinal) {
            this.fireDiff(MSG_METHOD_NOW_FINAL, Severity.ERROR, compatBaseline, baselineMethod, null);
        }
    }

    private String getMethodId(JavaType clazz, Method method) {
        String name;
        StringBuffer buf = new StringBuffer();
        String scopeDecl = method.getDeclaredScope().getDecl();
        if (scopeDecl.length() > 0) {
            buf.append(scopeDecl);
            buf.append(" ");
        }
        if ("<init>".equals(name = method.getName())) {
            String className = clazz.getName();
            int idx = className.lastIndexOf(46);
            name = className.substring(idx + 1);
        } else {
            buf.append(method.getReturnType());
            buf.append(' ');
        }
        buf.append(name);
        buf.append('(');
        this.appendHumanReadableArgTypeList(method, buf);
        buf.append(')');
        return buf.toString();
    }

    private void appendHumanReadableArgTypeList(Method method, StringBuffer buf) {
        JavaType[] argTypes = method.getArgumentTypes();
        String argSeparator = "";
        for (int i = 0; i < argTypes.length; ++i) {
            buf.append(argSeparator);
            buf.append(argTypes[i].getName());
            argSeparator = ", ";
        }
    }

    private void fireDiff(Message msg, Severity severity, JavaType clazz, Method method, String[] args) {
        String className = clazz.getName();
        ApiDifference diff = new ApiDifference(msg, severity, className, this.getMethodId(clazz, method), null, args);
        this.getApiDiffDispatcher().fireDiff(diff);
    }
}

