/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.Circumstance;
import jason.asSemantics.CircumstanceListener;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.Event;
import jason.asSemantics.Intention;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.InternalActionLiteral;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PlanBodyImpl;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class wait
extends DefaultInternalAction {
    public static final String waitAtom = ".wait";

    public boolean canBeUsedInContext() {
        return false;
    }

    public boolean suspendIntention() {
        return true;
    }

    public int getMinArgs() {
        return 1;
    }

    public int getMaxArgs() {
        return 3;
    }

    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        long timeout = -1L;
        Trigger te = null;
        Term elapsedTime = null;
        if (args[0].isNumeric()) {
            NumberTerm time2 = (NumberTerm)args[0];
            timeout = (long)time2.solve();
        } else {
            te = Trigger.tryToGetTrigger(args[0]);
            if (args.length >= 2) {
                timeout = (long)((NumberTerm)args[1]).solve();
            }
            if (args.length == 3) {
                elapsedTime = args[2];
            }
        }
        new WaitEvent(te, un, ts, timeout, elapsedTime);
        return true;
    }

    class WaitEvent
    implements CircumstanceListener {
        private Trigger te;
        private String sTE;
        private Unifier un;
        private Intention si;
        private TransitionSystem ts;
        private Circumstance c;
        private boolean dropped = false;
        private Term elapsedTimeTerm;
        private long startTime;

        WaitEvent(Trigger te, Unifier un, TransitionSystem ts, long timeout, Term elapsedTimeTerm) {
            this.te = te;
            this.un = un;
            this.ts = ts;
            this.c = ts.getC();
            this.si = this.c.getSelectedIntention();
            this.elapsedTimeTerm = elapsedTimeTerm;
            this.c.addEventListener(this);
            this.sTE = te != null ? te.toString() : "time" + timeout;
            this.sTE = this.si.getId() + "/" + this.sTE;
            this.c.addPendingIntention(this.sTE, this.si);
            this.startTime = System.currentTimeMillis();
            if (timeout > 0L) {
                ts.getAg().getScheduler().schedule(new Runnable(){

                    public void run() {
                        WaitEvent.this.resume(true);
                    }
                }, timeout, TimeUnit.MILLISECONDS);
            }
        }

        void resume(final boolean stopByTimeout) {
            this.c.removeEventListener(this);
            this.ts.runAtBeginOfNextCycle(new Runnable(){

                public void run() {
                    try {
                        if (WaitEvent.this.c.removePendingIntention(WaitEvent.this.sTE) == WaitEvent.this.si && !WaitEvent.this.c.getIntentions().contains(WaitEvent.this.si) && !WaitEvent.this.dropped) {
                            if (stopByTimeout && WaitEvent.this.te != null && WaitEvent.this.elapsedTimeTerm == null) {
                                if (WaitEvent.this.si.isSuspended()) {
                                    PlanBody body = WaitEvent.this.si.peek().getPlan().getBody();
                                    body.add(1, new PlanBodyImpl(PlanBody.BodyType.internalAction, new InternalActionLiteral(".fail")));
                                    WaitEvent.this.c.addPendingIntention("suspended-" + WaitEvent.this.si.getId(), WaitEvent.this.si);
                                } else {
                                    WaitEvent.this.ts.generateGoalDeletion(WaitEvent.this.si, JasonException.createBasicErrorAnnots("wait_timeout", "timeout in .wait"));
                                }
                            } else {
                                WaitEvent.this.si.peek().removeCurrentStep();
                                if (WaitEvent.this.elapsedTimeTerm != null) {
                                    long elapsedTime = System.currentTimeMillis() - WaitEvent.this.startTime;
                                    WaitEvent.this.un.unifies(WaitEvent.this.elapsedTimeTerm, new NumberTermImpl(elapsedTime));
                                }
                                if (WaitEvent.this.si.isSuspended()) {
                                    WaitEvent.this.c.addPendingIntention("suspended-" + WaitEvent.this.si.getId(), WaitEvent.this.si);
                                } else {
                                    WaitEvent.this.c.resumeIntention(WaitEvent.this.si);
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        WaitEvent.this.ts.getLogger().log(Level.SEVERE, "Error at .wait thread", e2);
                    }
                }
            });
            this.ts.getUserAgArch().getArchInfraTier().wake();
        }

        public void eventAdded(Event e2) {
            if (this.te != null && !this.dropped && this.un.unifies(this.te, e2.getTrigger())) {
                this.resume(false);
            }
        }

        public void intentionDropped(Intention i) {
            if (i.equals(this.si)) {
                this.dropped = true;
                this.resume(false);
            }
        }

        public void intentionAdded(Intention i) {
        }

        public void intentionResumed(Intention i) {
        }

        public void intentionSuspended(Intention i, String reason) {
        }

        public String toString() {
            return this.sTE;
        }
    }
}

