/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.ActionExec;
import jason.asSemantics.Circumstance;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.Event;
import jason.asSemantics.Intention;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;

public class suspend
extends DefaultInternalAction {
    boolean suspendIntention = false;
    public static final String SUSPENDED_INT = "suspended-";
    public static final String SELF_SUSPENDED_INT = "suspended-self";

    public int getMinArgs() {
        return 0;
    }

    public int getMaxArgs() {
        return 1;
    }

    protected void checkArguments(Term[] args) throws JasonException {
        super.checkArguments(args);
        if (args.length == 1 && !args[0].isLiteral()) {
            throw JasonException.createWrongArgument(this, "first argument must be a literal");
        }
    }

    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        this.suspendIntention = false;
        Circumstance C = ts.getC();
        if (args.length == 0) {
            Intention i = C.getSelectedIntention();
            this.suspendIntention = true;
            i.setSuspended(true);
            C.addPendingIntention(SELF_SUSPENDED_INT, i);
            return true;
        }
        Trigger g = new Trigger(Trigger.TEOperator.add, Trigger.TEType.achieve, (Literal)args[0]);
        String k = SUSPENDED_INT + g.getLiteral();
        for (ActionExec a : C.getPendingActions().values()) {
            Intention i = a.getIntention();
            if (!i.hasTrigger(g, un)) continue;
            i.setSuspended(true);
            C.addPendingIntention(k, i);
        }
        for (Intention i : C.getPendingIntentions().values()) {
            if (!i.hasTrigger(g, un)) continue;
            i.setSuspended(true);
        }
        for (Intention i : C.getIntentions()) {
            if (!i.hasTrigger(g, un)) continue;
            i.setSuspended(true);
            C.removeIntention(i);
            C.addPendingIntention(k, i);
        }
        Intention i = C.getSelectedIntention();
        if (i.hasTrigger(g, un)) {
            this.suspendIntention = true;
            i.setSuspended(true);
            C.addPendingIntention(SELF_SUSPENDED_INT, i);
        }
        for (Event e2 : C.getEvents()) {
            i = e2.getIntention();
            if (i != null && i.hasTrigger(g, un) || un.unifies(e2.getTrigger(), g)) {
                i.setSuspended(true);
                C.removeEvent(e2);
                C.addPendingIntention(k, i);
                continue;
            }
            if (i != Intention.EmptyInt || !un.unifies(e2.getTrigger(), g)) continue;
            ts.getLogger().warning("** NOT IMPLEMENTED ** (suspend of !!)");
        }
        return true;
    }

    public boolean suspendIntention() {
        return this.suspendIntention;
    }
}

