/*
 * Decompiled with CFR 0.152.
 */
package jason.jeditplugin;

import jason.jeditplugin.Config;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CheckVersion
extends Thread {
    public static final String JasonSite = "http://jason.sf.net";
    String download;
    String version;
    String release;
    static boolean alreadyRun = false;

    String getLatestVersion() {
        try {
            Properties p = new Properties();
            p.load(new URL("http://jason.sf.net/latest.properties").openStream());
            this.download = p.getProperty("download");
            this.version = p.getProperty("version");
            this.release = p.getProperty("release");
            return this.version + "." + this.release;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return null;
        }
    }

    boolean isLatestVersion() {
        String cVersion = Config.get().getJasonRunningVersion();
        String lv = this.getLatestVersion();
        return lv == null || cVersion.compareTo(lv) >= 0;
    }

    String whatsNew() {
        try {
            StringBuilder out = new StringBuilder();
            InputStream in = new URL("http://jason.sf.net/whatsnew.txt").openStream();
            int c = in.read();
            while (c != -1) {
                out.append((char)c);
                c = in.read();
            }
            return out.toString();
        }
        catch (Exception e2) {
            System.err.println("Error reading what's new!" + e2);
            return null;
        }
    }

    void show() {
        final JFrame f = new JFrame("Jason update");
        f.setLayout(new BorderLayout());
        JTextArea ta = new JTextArea(20, 90);
        f.add("Center", new JScrollPane(ta));
        JPanel sp = new JPanel(new FlowLayout(1));
        JButton ok = new JButton("Ok");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                f.setVisible(false);
            }
        });
        JButton notShow = new JButton("Do not show this message again");
        notShow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                f.setVisible(false);
                Config.get().setProperty("checkLatestVersion", "false");
                Config.get().store();
            }
        });
        sp.add(ok);
        sp.add(notShow);
        f.add("South", sp);
        f.pack();
        ta.append("A new version of Jason (" + this.getLatestVersion() + ") is available at\n\n");
        ta.append("      " + this.download + "\n\n");
        String wn = this.whatsNew();
        if (wn != null) {
            ta.append("\nRelease notes:\n");
            ta.append(wn);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        f.setLocation((screenSize.width - f.getWidth()) / 2, (screenSize.height - f.getHeight()) / 2);
        f.setVisible(true);
    }

    public void run() {
        if (alreadyRun) {
            return;
        }
        alreadyRun = true;
        try {
            if (Config.get().getProperty("checkLatestVersion", "true").equals("true") && !this.isLatestVersion()) {
                this.show();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] a) {
        CheckVersion cv = new CheckVersion();
        cv.start();
    }
}

