/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.saci;

import jason.infra.centralised.CentralisedMASLauncherAnt;
import jason.jeditplugin.Config;
import jason.mas2j.MAS2JProject;
import java.io.File;
import javax.swing.JOptionPane;
import saci.launcher.Launcher;
import saci.launcher.LauncherD;

class StartSaci
extends Thread {
    boolean saciOk = false;
    Process saciProcess;
    MAS2JProject project;
    boolean stop = false;

    StartSaci(MAS2JProject project) {
        super("StartSaci");
        this.project = project;
    }

    Launcher getLauncher() {
        Launcher l = null;
        try {
            l = LauncherD.getLauncher();
            return l;
        }
        catch (Exception e2) {
            return null;
        }
    }

    void stopSaci() {
        try {
            this.getLauncher().stop();
        }
        catch (Exception e2) {
            try {
                this.saciProcess.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.saciProcess = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String[] command = this.getStartCommandArray();
            String cmdstr = command[0];
            for (int i = 1; i < command.length; ++i) {
                cmdstr = cmdstr + " " + command[i];
            }
            System.out.println("Running saci with " + cmdstr);
            this.saciProcess = Runtime.getRuntime().exec(command, null, new File(this.project.getDirectory()));
            for (int tryCont = 0; tryCont < 30 && !this.stop; ++tryCont) {
                StartSaci.sleep(1000L);
                Launcher l = this.getLauncher();
                if (l == null) continue;
                this.saciOk = true;
                this.stopWaitSaciOk();
                break;
            }
        }
        catch (Exception ex) {
            System.err.println("error running saci:" + ex);
        }
        finally {
            this.stopWaitSaciOk();
        }
    }

    public String[] getStartCommandArray() {
        String build = CentralisedMASLauncherAnt.bindir + "build.xml";
        if (this.hasCBuild()) {
            build = CentralisedMASLauncherAnt.bindir + "c-build.xml";
        }
        return new String[]{Config.get().getJavaHome() + "bin" + File.separator + "java", "-classpath", Config.get().getAntLib() + "ant-launcher.jar", "org.apache.tools.ant.launch.Launcher", "-e", "-f", build, "saci"};
    }

    protected boolean hasCBuild() {
        return new File(this.project.getDirectory() + File.separator + CentralisedMASLauncherAnt.bindir + "c-build.xml").exists();
    }

    synchronized void stopWaitSaciOk() {
        this.stop = true;
        this.notifyAll();
    }

    synchronized boolean waitSaciOk() {
        try {
            this.wait(20000L);
            if (!this.saciOk && !this.stop) {
                JOptionPane.showMessageDialog(null, "Failed to automatically start saci! \nGo to \"" + this.project.getDirectory() + "\" directory and run 'ant saci'" + " to start saci.\n\nClick 'ok' when saci is running.");
                this.wait(1000L);
                if (!this.saciOk) {
                    JOptionPane.showMessageDialog(null, "Saci might not be properly installed or configure. Use the centralised architecture to run your MAS");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.saciOk;
    }
}

