/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.saci;

import jason.architecture.AgArch;
import jason.asSemantics.Agent;
import jason.bb.DefaultBeliefBase;
import jason.control.ExecutionControlGUI;
import jason.environment.Environment;
import jason.infra.centralised.CentralisedMASLauncherAnt;
import jason.infra.saci.SaciRuntimeServices;
import jason.infra.saci.StartSaci;
import jason.jeditplugin.Config;
import jason.jeditplugin.MASLauncherInfraTier;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import saci.launcher.Launcher;

public class SaciMASLauncherAnt
extends CentralisedMASLauncherAnt
implements MASLauncherInfraTier {
    StartSaci saciThread;
    Launcher l;
    boolean iHaveStartedSaci = false;
    private static Logger logger = Logger.getLogger(SaciMASLauncherAnt.class.getName());

    public void run() {
        this.saciThread = new StartSaci(this.project);
        this.l = this.saciThread.getLauncher();
        if (this.l == null) {
            this.saciThread.start();
            if (!this.saciThread.waitSaciOk()) {
                return;
            }
            this.iHaveStartedSaci = true;
        }
        this.l = this.saciThread.getLauncher();
        super.run();
    }

    public void stopMAS() {
        if (this.saciThread.saciOk) {
            new Thread(){

                public void run() {
                    try {
                        new SaciRuntimeServices(SaciMASLauncherAnt.this.project.getSocName()).stopMAS();
                        if (SaciMASLauncherAnt.this.iHaveStartedSaci) {
                            SaciMASLauncherAnt.this.saciThread.stopSaci();
                        }
                    }
                    catch (Exception e2) {
                        logger.log(Level.SEVERE, "Error stoping saci MAS", e2);
                    }
                }
            }.start();
        } else {
            try {
                this.saciThread.stopWaitSaciOk();
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Error stoping saci MAS", e2);
            }
        }
        super.stopMAS();
    }

    protected String replaceMarks(String script, boolean debug) {
        String saciJar = Config.get().getSaciJar();
        if (!Config.checkJar(saciJar)) {
            System.err.println("The path to the saci.jar file (" + saciJar + ") was not correctly set. Go to menu Plugin->Options->Jason to configure the path.");
        }
        this.writeSaciXMLScript(debug);
        script = SaciMASLauncherAnt.replace(script, "<PROJECT-RUNNER-CLASS>", "saci.tools.runApplicationScript");
        script = SaciMASLauncherAnt.replace(script, "<PROJECT-FILE>", this.project.getSocName() + ".xml");
        script = SaciMASLauncherAnt.replace(script, "<DEBUG>", "");
        String sacipath = "        <pathelement location=\"" + Config.get().getSaciJar() + "\"/>";
        script = SaciMASLauncherAnt.replace(script, "<PATH-LIB>", sacipath + "<PATH-LIB>");
        String startsaci = "    <property name=\"saci.main\" value=\"saci.tools.SaciMenu\"/> <!-- use \"saci.launcher.LauncherD\" to run saci without a GUI -->\n    <property name=\"saci.remote.host\" value=\"localhost\"/>\n\n    <target name=\"saci\">\n       <java classname=\"${saci.main}\" failonerror=\"true\" fork=\"yes\" dir=\"${basedir}\">\n          <classpath refid=\"project.classpath\"/>\n          <jvmarg value=\"-Djava.security.policy=jar:file:" + Config.get().getSaciJar() + "!/policy\"/>\n" + "       </java>\n" + "    </target>\n\n" + "    <target name=\"stop-saci\" >\n" + "       <java classname=\"saci.launcher.StopLauncherD\" >\n" + "          <classpath refid=\"project.classpath\"/>\n" + "       </java>\n" + "    </target>\n" + "    <target name=\"saci-client\" >\n" + "       <java classname=\"saci.launcher.LauncherD\" failonerror=\"true\" fork=\"yes\" dir=\"${basedir}\">\n" + "          <classpath refid=\"project.classpath\"/>\n" + "          <jvmarg value=\"-Djava.security.policy=jar:file:" + Config.get().getSaciJar() + "!/policy\"/>\n" + "          <arg line=\"-connect ${saci.remote.host}\"/>\n" + "       </java>\n" + "    </target>\n";
        script = SaciMASLauncherAnt.replace(script, "<OTHER-TASK>", startsaci);
        return super.replaceMarks(script, debug);
    }

    public void writeSaciXMLScript(boolean debug) {
        try {
            String file = this.project.getDirectory() + File.separator + this.project.getSocName() + ".xml";
            this.writeSaciXMLScript(new PrintStream(new FileOutputStream(file)), debug);
        }
        catch (Exception e2) {
            System.err.println("Error writing XML script!" + e2);
        }
    }

    public void writeSaciXMLScript(PrintStream out, boolean debug) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!-- this file was generated by Jason -->");
        out.println("<?xml-stylesheet href=\"http://www.das.ufsc.br/~jomi/jason/saci/applications.xsl\" type=\"text/xsl\" ?>");
        out.println("<saci>");
        out.println("<application id=\"" + this.project.getSocName() + "\">");
        out.println("<script id=\"run\">\n");
        out.println("\t<killSocietyAgents society.name=\"" + this.project.getSocName() + "\" />");
        out.println("\t<killFacilitator society.name=\"" + this.project.getSocName() + "\" />");
        out.println("\t<startSociety society.name=\"" + this.project.getSocName() + "\" />\n");
        out.println("\t<killSocietyAgents society.name=\"" + this.project.getSocName() + "-env\" />");
        out.println("\t<killFacilitator society.name=\"" + this.project.getSocName() + "-env\" />");
        out.println("\t<startSociety society.name=\"" + this.project.getSocName() + "-env\" />\n");
        out.println("\t<startAgent ");
        out.println("\t\tname=\"environment\" ");
        out.println("\t\tsociety.name=\"" + this.project.getSocName() + "-env\" ");
        ClassParameters tmpEnvClass = this.project.getEnvClass() == null ? new ClassParameters(Environment.class.getName()) : this.project.getEnvClass();
        String pars = tmpEnvClass.getParametersStr(" ").replaceAll("\"", "'");
        out.println("\t\targs=\"" + tmpEnvClass.getClassName() + " " + pars + "\" ");
        out.println("\t\tclass=\"jason.infra.saci.SaciEnvironment\" ");
        if (tmpEnvClass.getHost() != null) {
            out.println("\t\thost=\"" + tmpEnvClass.getHost() + "\"");
        }
        out.println("\t/>");
        this.project.fixAgentsSrc(null);
        for (AgentParameters agp : this.project.getAgents()) {
            out.println(this.getAgSaciXMLScript(agp, debug, this.project.getControlClass() != null));
        }
        ClassParameters fControlClass = this.project.getControlClass();
        if (debug && fControlClass == null) {
            fControlClass = new ClassParameters(ExecutionControlGUI.class.getName());
        }
        if (fControlClass != null) {
            out.println("\t<startAgent ");
            out.println("\t\tname=\"controller\" ");
            out.println("\t\tsociety.name=\"" + this.project.getSocName() + "-env\" ");
            out.println("\t\targs=\"" + fControlClass + " " + fControlClass.getParametersStr(" ") + "\"");
            if (fControlClass.getHost() != null) {
                out.println("\t\thost=" + fControlClass.getHost());
            }
            out.println("\t\tclass=\"jason.infra.saci.SaciExecutionControl\" ");
            out.println("\t/>");
        }
        out.println("\n</script>");
        out.println("</application>");
        out.println("</saci>");
        out.close();
    }

    public String getAgSaciXMLScript(AgentParameters agp, boolean debug, boolean forceSync) {
        ClassParameters tmpBBClass;
        ClassParameters tmpAgArchClass;
        StringBuilder s = new StringBuilder("\t<startAgent ");
        s.append("\n\t\tname=\"" + agp.name + "\" ");
        s.append("\n\t\tsociety.name=\"" + this.project.getSocName() + "\" ");
        s.append("\n\t\tclass=\"jason.infra.saci.SaciAgArch\"");
        ClassParameters tmpAgClass = agp.agClass;
        if (tmpAgClass == null) {
            tmpAgClass = new ClassParameters(Agent.class.getName());
        }
        if ((tmpAgArchClass = agp.archClass) == null) {
            tmpAgArchClass = new ClassParameters(AgArch.class.getName());
        }
        if ((tmpBBClass = agp.getBBClass()) == null) {
            tmpBBClass = new ClassParameters(DefaultBeliefBase.class.getName());
        }
        String sBBClass = tmpBBClass.toString().replace('\"', '$');
        String fname = agp.asSource.toString();
        if (!fname.startsWith(File.separator) && !fname.startsWith(this.project.getDirectory())) {
            fname = this.project.getDirectory() + File.separator + fname;
        }
        File tmpAsSrc = new File(fname);
        s.append("\n\t\targs=\"" + tmpAgArchClass.getClassName() + " " + tmpAgClass.getClassName() + " '" + sBBClass + "' " + " '" + tmpAsSrc.getAbsolutePath() + "'" + this.getSaciOptsStr(agp, debug, forceSync) + "\"");
        if (agp.qty > 1) {
            s.append("\n\t\tqty=\"" + agp.qty + "\" ");
        }
        if (agp.getHost() != null) {
            s.append("\n\t\thost=\"" + agp.getHost() + "\"");
        }
        s.append(" />");
        return s.toString().trim();
    }

    String getSaciOptsStr(AgentParameters agp, boolean debug, boolean forceSync) {
        String s = "";
        String v = "";
        if (debug) {
            s = s + "verbose=2";
            v = ",";
        }
        if (forceSync || debug) {
            s = s + v + "synchronised=true";
            v = ",";
        }
        for (String key : agp.getOptions().keySet()) {
            if (debug && key.equals("verbose") || (forceSync || debug) && key.equals("synchronised")) continue;
            s = s + v + key + "=" + this.changeQuotes(agp.getOptions().get(key));
            v = ",";
        }
        if (s.length() > 0) {
            s = " options " + s;
        }
        return s;
    }

    String changeQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return "'" + s.substring(1, s.length() - 1) + "'";
        }
        return s;
    }
}

