/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.saci;

import jason.JasonException;
import jason.control.ExecutionControl;
import jason.control.ExecutionControlInfraTier;
import jason.infra.saci.SaciRuntimeServices;
import jason.runtime.RuntimeServicesInfraTier;
import org.w3c.dom.Document;
import saci.Agent;
import saci.Message;
import saci.MessageHandler;

public class SaciExecutionControl
extends Agent
implements ExecutionControlInfraTier {
    private static final long serialVersionUID = 1L;
    private ExecutionControl fUserControl;

    public void initAg(String[] args) throws JasonException {
        try {
            System.out.println("Creating controller from " + args[0]);
            this.fUserControl = (ExecutionControl)Class.forName(args[0]).newInstance();
            this.fUserControl.setExecutionControlInfraTier(this);
            String[] p = new String[args.length - 1];
            for (int i = 0; i < p.length; ++i) {
                p[i] = args[i + 1];
            }
            this.fUserControl.init(p);
        }
        catch (Exception e2) {
            System.err.println("Error " + e2);
            e2.printStackTrace();
            throw new JasonException("The user execution control class instantiation '" + args[1] + "' has failed!" + e2.getMessage());
        }
        try {
            this.mbox.addMessageHandler("cycleFinished", "tell", null, "AS-ExecControl", new MessageHandler(){

                public boolean processMessage(Message m) {
                    String sender = (String)m.get((Object)"sender");
                    boolean breakpoint = false;
                    if (m.get((Object)"breakpoint") != null) {
                        breakpoint = m.get((Object)"breakpoint").equals("true");
                    }
                    int cycle = Integer.parseInt(m.get((Object)"cycle").toString());
                    SaciExecutionControl.this.fUserControl.receiveFinishedCycle(sender, breakpoint, cycle);
                    return true;
                }
            });
        }
        catch (Exception e3) {
            System.err.println("Error adding message handler for agent:" + e3);
            e3.printStackTrace();
        }
    }

    public void stopAg() {
        this.fUserControl.stop();
        super.stopAg();
    }

    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.informAllAgsToPerformCycle(0);
    }

    public ExecutionControl getUserControl() {
        return this.fUserControl;
    }

    public void informAgToPerformCycle(String agName, int cycle) {
        Message m = new Message("(tell)");
        m.put((Object)"ontology", (Object)"AS-ExecControl");
        m.put((Object)"receiver", (Object)agName);
        m.put((Object)"content", (Object)"performCycle");
        m.put((Object)"cycle", (Object)String.valueOf(cycle));
        try {
            this.mbox.sendMsg(m);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void informAllAgsToPerformCycle(int cycle) {
        Message m = new Message("(tell)");
        m.put((Object)"ontology", (Object)"AS-ExecControl");
        m.put((Object)"content", (Object)"performCycle");
        m.put((Object)"cycle", (Object)String.valueOf(cycle));
        try {
            this.mbox.broadcast(m);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public Document getAgState(String agName) {
        Message m = new Message("(ask)");
        m.put((Object)"ontology", (Object)"AS-ExecControl");
        m.put((Object)"receiver", (Object)agName);
        m.put((Object)"content", (Object)"agState");
        try {
            Message r = this.mbox.ask(m);
            if (r != null) {
                return (Document)r.get((Object)"content");
            }
            System.err.println("No agent state received! (possibly timeout in ask)");
        }
        catch (Exception e2) {
            System.err.println("Error receiving agent state " + e2);
            e2.printStackTrace();
        }
        return null;
    }

    public RuntimeServicesInfraTier getRuntimeServices() {
        return new SaciRuntimeServices(this.getSociety());
    }
}

