/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.BootProfileImpl;
import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.tools.rma.rma;
import jade.tools.sniffer.Sniffer;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerController;
import jade.wrapper.StaleProxyException;
import jason.JasonException;
import jason.asSyntax.directives.DirectiveProcessor;
import jason.asSyntax.directives.Include;
import jason.control.ExecutionControlGUI;
import jason.infra.centralised.RunCentralisedMAS;
import jason.infra.jade.JadeAgArch;
import jason.infra.jade.JadeEnvironment;
import jason.infra.jade.JadeExecutionControl;
import jason.infra.jade.JadeRuntimeServices;
import jason.jeditplugin.Config;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.mas2j.MAS2JProject;
import jason.runtime.MASConsoleGUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class RunJadeMAS
extends RunCentralisedMAS {
    public static String controllerName = "j_controller";
    public static String environmentName = "j_environment";
    private static Logger logger = Logger.getLogger(RunJadeMAS.class.getName());
    private AgentController envc;
    private AgentController crtc;
    private Map<String, AgentController> ags = new HashMap<String, AgentController>();
    private ContainerController cc;
    private String targetContainer = null;
    private ArrayList<String> initArgs = new ArrayList();
    private ProfileImpl profile;

    public static void main(String[] args) {
        runner = new RunJadeMAS();
        runner.init(args);
    }

    public void init(String[] args) {
        for (int i = 1; i < args.length; ++i) {
            this.initArgs.add(args[i]);
            if (!args[i].equals("-container-name")) continue;
            this.targetContainer = args[i + 1];
        }
        super.init(args);
    }

    protected void createButtons() {
        this.createStopButton();
        this.createPauseButton();
        JButton btRMA = new JButton("Management Agent", new ImageIcon(Sniffer.class.getResource("/jade/tools/sniffer/images/jadelogo.jpg")));
        btRMA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    RunJadeMAS.this.cc.createNewAgent("RMA", rma.class.getName(), null).start();
                }
                catch (StaleProxyException e2) {
                    e2.printStackTrace();
                }
            }
        });
        MASConsoleGUI.get().addButton(btRMA);
        JButton btSniffer = new JButton("JADE Sniffer", new ImageIcon(Sniffer.class.getResource("/jade/tools/sniffer/images/sniffer.gif")));
        btSniffer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    RunJadeMAS.this.cc.createNewAgent("Sniffer", Sniffer.class.getName(), null).start();
                }
                catch (StaleProxyException e2) {
                    e2.printStackTrace();
                }
            }
        });
        MASConsoleGUI.get().addButton(btSniffer);
    }

    protected boolean startContainer() {
        try {
            this.profile = new BootProfileImpl(this.prepareArgs(this.initArgs.toArray(new String[0])));
            this.cc = this.profile.getBooleanProperty("main", true) ? Runtime.instance().createMainContainer((Profile)this.profile) : Runtime.instance().createAgentContainer((Profile)this.profile);
            return this.cc != null;
        }
        catch (Throwable e2) {
            logger.log(Level.WARNING, "Error starting JADE", e2);
            return false;
        }
    }

    protected void createAgs(MAS2JProject project, boolean debug) throws JasonException {
        if (!this.startContainer()) {
            return;
        }
        if (this.profile.getBooleanProperty("main", true)) {
            try {
                logger.fine("Creating environment " + project.getEnvClass());
                this.envc = this.cc.createNewAgent(environmentName, JadeEnvironment.class.getName(), new Object[]{project.getEnvClass()});
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Error creating the environment: ", e2);
                return;
            }
            try {
                ClassParameters controlClass = project.getControlClass();
                if (debug && controlClass == null) {
                    controlClass = new ClassParameters(ExecutionControlGUI.class.getName());
                }
                if (controlClass != null) {
                    logger.fine("Creating controller " + controlClass);
                    this.crtc = this.cc.createNewAgent(controllerName, JadeExecutionControl.class.getName(), new Object[]{controlClass});
                }
            }
            catch (Exception e3) {
                logger.log(Level.SEVERE, "Error creating the controller: ", e3);
                return;
            }
        }
        try {
            project.fixAgentsSrc(null);
            ((Include)DirectiveProcessor.getDirective("include")).setSourcePath(project.getSourcePaths());
            for (AgentParameters ap : project.getAgents()) {
                try {
                    String agName = ap.name;
                    if (ap.getHost() != null && this.targetContainer != null && !ap.getHost().equals(this.targetContainer) || ap.getHost() == null && !this.profile.getBooleanProperty("main", true)) continue;
                    for (int cAg = 0; cAg < ap.qty; ++cAg) {
                        String numberedAg = agName;
                        if (ap.qty > 1) {
                            numberedAg = numberedAg + (cAg + 1);
                        }
                        logger.fine("Creating agent " + numberedAg + " (" + (cAg + 1) + "/" + ap.qty + ")");
                        AgentController ac = this.cc.createNewAgent(numberedAg, JadeAgArch.class.getName(), new Object[]{ap, debug, project.getControlClass() != null});
                        this.ags.put(numberedAg, ac);
                    }
                }
                catch (Exception e4) {
                    logger.log(Level.SEVERE, "Error creating agent " + ap.name, e4);
                }
            }
            if (this.profile.getBooleanProperty("main", true)) {
                if (Config.get().getBoolean("jadeRMA")) {
                    this.cc.createNewAgent("RMA", rma.class.getName(), null).start();
                }
                if (Config.get().getBoolean("jadeSniffer")) {
                    this.cc.createNewAgent("Sniffer", Sniffer.class.getName(), null).start();
                    Thread.sleep(1000L);
                }
            }
        }
        catch (Throwable e5) {
            logger.log(Level.SEVERE, "Error creating agents: ", e5);
        }
    }

    protected void startAgs() {
        if (this.envc == null) {
            return;
        }
        try {
            this.envc.start();
            if (this.crtc != null) {
                this.crtc.start();
            }
            for (AgentController ag : this.ags.values()) {
                ag.start();
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error starting agents.", e2);
        }
    }

    public void finish() {
        try {
            logger.info("Finishing the system.");
            new JadeRuntimeServices(this.cc, null).stopMAS();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error stopping system.", e2);
        }
        System.exit(0);
    }

    protected String[] prepareArgs(String[] args) {
        boolean printUsageInfo = false;
        if (args != null && args.length != 0) {
            boolean isNew = false;
            boolean likely = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("import:")) {
                    int j = args[i].indexOf(58);
                    isNew = j < args[i].length() - 1 && this.isFileName(args[i].substring(j + 1));
                    likely = !isNew;
                    continue;
                }
                if (args[i].startsWith("agents:")) {
                    isNew = true;
                    continue;
                }
                if (!args[i].startsWith("-") || !likely) continue;
                isNew = true;
            }
            if (isNew) {
                return args;
            }
        }
        boolean endCommand = false;
        Vector<String> results = new Vector<String>();
        for (int n = 0; n < args.length && !endCommand; ++n) {
            String theArg = args[n];
            if (theArg.equalsIgnoreCase("-conf")) {
                if (++n == args.length) {
                    results.add(theArg);
                    continue;
                }
                String nextArg = args[n];
                if (this.isFileName(nextArg)) {
                    results.add("import:" + nextArg);
                    continue;
                }
                results.add(theArg);
                --n;
                continue;
            }
            if (theArg.equalsIgnoreCase("-host")) {
                if (++n == args.length) {
                    System.err.println("Missing host name ");
                    printUsageInfo = true;
                    continue;
                }
                results.add("host:" + args[n]);
                continue;
            }
            if (theArg.equalsIgnoreCase("-owner")) {
                if (++n == args.length) {
                    results.add("owner::");
                    continue;
                }
                results.add("owner:" + args[n]);
                continue;
            }
            if (theArg.equalsIgnoreCase("-name")) {
                if (++n == args.length) {
                    System.err.println("Missing platform name");
                    printUsageInfo = true;
                    continue;
                }
                results.add("name:" + args[n]);
                continue;
            }
            if (theArg.equalsIgnoreCase("-container-name")) {
                if (++n == args.length) {
                    System.err.println("Missing container name");
                    printUsageInfo = true;
                    continue;
                }
                results.add("container-name:" + args[n]);
                continue;
            }
            if (theArg.equalsIgnoreCase("-imtp")) {
                if (++n == args.length) {
                    System.err.println("Missing IMTP class");
                    printUsageInfo = true;
                    continue;
                }
                results.add("imtp:" + args[n]);
                continue;
            }
            if (theArg.equalsIgnoreCase("-port")) {
                if (++n == args.length) {
                    System.err.println("Missing port number");
                    printUsageInfo = true;
                    continue;
                }
                try {
                    Integer.parseInt(args[n]);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Wrong int for the port number");
                    printUsageInfo = true;
                }
                results.add("port:" + args[n]);
                continue;
            }
            if (theArg.equalsIgnoreCase("-container")) {
                results.add(theArg);
                continue;
            }
            if (theArg.equalsIgnoreCase("-backupmain")) {
                results.add(theArg);
                continue;
            }
            if (theArg.equalsIgnoreCase("-gui")) {
                results.add(theArg);
                continue;
            }
            if (theArg.equalsIgnoreCase("-version") || theArg.equalsIgnoreCase("-v")) {
                results.add("-version");
                continue;
            }
            if (theArg.equalsIgnoreCase("-help") || theArg.equalsIgnoreCase("-h")) {
                results.add("-help");
                continue;
            }
            if (theArg.equalsIgnoreCase("-nomtp")) {
                results.add(theArg);
                continue;
            }
            if (theArg.equalsIgnoreCase("-nomobility")) {
                results.add(theArg);
                continue;
            }
            if (theArg.equalsIgnoreCase("-dump")) {
                results.add(theArg);
                continue;
            }
            if (theArg.equalsIgnoreCase("-mtp")) {
                if (++n == args.length) {
                    System.err.println("Missing mtp specifiers");
                    printUsageInfo = true;
                    continue;
                }
                results.add("mtp:" + args[n]);
                continue;
            }
            if (theArg.equalsIgnoreCase("-aclcodec")) {
                if (++n == args.length) {
                    System.err.println("Missing aclcodec specifiers");
                    printUsageInfo = true;
                    continue;
                }
                results.add("aclcodec:" + args[n]);
                continue;
            }
            if (theArg.startsWith("-") && n + 1 < args.length) {
                results.add(theArg.substring(1) + ":" + args[++n]);
                continue;
            }
            endCommand = true;
        }
        if (endCommand) {
            StringBuffer sb = new StringBuffer();
            for (int i = --n; i < args.length; ++i) {
                sb.append(args[i] + " ");
            }
            results.add("agents:" + sb.toString());
        }
        if (printUsageInfo) {
            results.add("-help");
        }
        String[] newArgs = new String[results.size()];
        for (int i = 0; i < newArgs.length; ++i) {
            newArgs[i] = (String)results.elementAt(i);
        }
        return newArgs;
    }

    protected boolean isFileName(String arg) {
        File testFile = new File(arg);
        return testFile.exists();
    }
}

