/*
 * Decompiled with CFR 0.152.
 */
package jason.environment.grid;

import jason.environment.grid.GridWorldView;
import jason.environment.grid.Location;
import java.util.Random;

public class GridWorldModel {
    public static final int CLEAN = 0;
    public static final int AGENT = 2;
    public static final int OBSTACLE = 4;
    protected int width;
    protected int height;
    protected int[][] data = null;
    protected Location[] agPos;
    protected GridWorldView view;
    protected Random random = new Random();

    protected GridWorldModel(int w, int h, int nbAgs) {
        int i;
        this.width = w;
        this.height = h;
        this.data = new int[this.width][this.height];
        for (i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.data[i][j] = 0;
            }
        }
        this.agPos = new Location[nbAgs];
        for (i = 0; i < this.agPos.length; ++i) {
            this.agPos[i] = new Location(-1, -1);
        }
    }

    public void setView(GridWorldView v) {
        this.view = v;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNbOfAgs() {
        return this.agPos.length;
    }

    public boolean inGrid(Location l) {
        return this.inGrid(l.x, l.y);
    }

    public boolean inGrid(int x, int y) {
        return y >= 0 && y < this.height && x >= 0 && x < this.width;
    }

    public boolean hasObject(int obj, Location l) {
        return this.inGrid(l.x, l.y) && (this.data[l.x][l.y] & obj) != 0;
    }

    public boolean hasObject(int obj, int x, int y) {
        return this.inGrid(x, y) && (this.data[x][y] & obj) != 0;
    }

    public int countObjects(int obj) {
        int c = 0;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (!this.hasObject(obj, i, j)) continue;
                ++c;
            }
        }
        return c;
    }

    public void set(int value, int x, int y) {
        this.data[x][y] = value;
        if (this.view != null) {
            this.view.update(x, y);
        }
    }

    public void add(int value, Location l) {
        this.add(value, l.x, l.y);
    }

    public void add(int value, int x, int y) {
        int[] nArray = this.data[x];
        int n = y;
        nArray[n] = nArray[n] | value;
        if (this.view != null) {
            this.view.update(x, y);
        }
    }

    public void addWall(int x1, int y1, int x2, int y2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                this.add(4, x, y);
            }
        }
    }

    public void remove(int value, Location l) {
        this.remove(value, l.x, l.y);
    }

    public void remove(int value, int x, int y) {
        int[] nArray = this.data[x];
        int n = y;
        nArray[n] = nArray[n] & ~value;
        if (this.view != null) {
            this.view.update(x, y);
        }
    }

    public void setAgPos(int ag, Location l) {
        Location oldLoc = this.getAgPos(ag);
        if (oldLoc != null) {
            this.remove(2, oldLoc.x, oldLoc.y);
        }
        this.agPos[ag] = l;
        this.add(2, l.x, l.y);
    }

    public void setAgPos(int ag, int x, int y) {
        this.setAgPos(ag, new Location(x, y));
    }

    public Location getAgPos(int ag) {
        try {
            if (this.agPos[ag].x == -1) {
                return null;
            }
            return (Location)this.agPos[ag].clone();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public int getAgAtPos(Location l) {
        return this.getAgAtPos(l.x, l.y);
    }

    public int getAgAtPos(int x, int y) {
        for (int i = 0; i < this.agPos.length; ++i) {
            if (this.agPos[i].x != x || this.agPos[i].y != y) continue;
            return i;
        }
        return -1;
    }

    public boolean isFree(Location l) {
        return this.isFree(l.x, l.y);
    }

    public boolean isFree(int x, int y) {
        return this.inGrid(x, y) && (this.data[x][y] & 4) == 0 && (this.data[x][y] & 2) == 0;
    }

    public boolean isFree(int obj, Location l) {
        return this.inGrid(l.x, l.y) && (this.data[l.x][l.y] & obj) == 0;
    }

    public boolean isFree(int obj, int x, int y) {
        return this.inGrid(x, y) && (this.data[x][y] & obj) == 0;
    }

    public boolean isFreeOfObstacle(Location l) {
        return this.isFree(4, l);
    }

    public boolean isFreeOfObstacle(int x, int y) {
        return this.isFree(4, x, y);
    }

    protected Location getFreePos() {
        for (int i = 0; i < this.getWidth() * this.getHeight() * 5; ++i) {
            int y;
            int x = this.random.nextInt(this.getWidth());
            Location l = new Location(x, y = this.random.nextInt(this.getHeight()));
            if (!this.isFree(l)) continue;
            return l;
        }
        return null;
    }

    protected Location getFreePos(int obj) {
        for (int i = 0; i < this.getWidth() * this.getHeight() * 5; ++i) {
            int y;
            int x = this.random.nextInt(this.getWidth());
            Location l = new Location(x, y = this.random.nextInt(this.getHeight()));
            if (!this.isFree(obj, l)) continue;
            return l;
        }
        return null;
    }
}

