/*
 * Decompiled with CFR 0.152.
 */
package jason.control;

import jason.control.ExecutionControlInfraTier;
import jason.runtime.RuntimeServicesInfraTier;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionControl {
    protected ExecutionControlInfraTier infraControl = null;
    private Set<String> finished = new HashSet<String>();
    private int cycleNumber = 0;
    private boolean runningCycle = true;
    private int nbAgs = -1;
    private Lock lock = new ReentrantLock();
    private Condition agFinishedCond = this.lock.newCondition();
    private RuntimeServicesInfraTier runtime;
    protected static Logger logger = Logger.getLogger(ExecutionControl.class.getName());

    public ExecutionControl() {
        new Thread("ExecControlWaitAgFinish"){

            public void run() {
                ExecutionControl.this.lock.lock();
                try {
                    while (true) {
                        try {
                            while (true) {
                                boolean to;
                                boolean bl = to = !ExecutionControl.this.agFinishedCond.await(ExecutionControl.this.getCycleTimeout(), TimeUnit.MILLISECONDS);
                                if (ExecutionControl.this.runtime != null && ExecutionControl.this.runningCycle) {
                                    ExecutionControl.this.runningCycle = false;
                                    ExecutionControl.this.allAgsFinished();
                                }
                                if (!to) continue;
                                ExecutionControl.this.updateNumberOfAgents();
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    ExecutionControl.this.lock.unlock();
                    throw throwable;
                }
            }
        }.start();
    }

    protected int getCycleTimeout() {
        return 5000;
    }

    protected void startNewCycle() {
        this.runningCycle = true;
        this.finished.clear();
        ++this.cycleNumber;
    }

    public void updateNumberOfAgents() {
        this.setNbAgs(this.runtime.getAgentsQty());
    }

    public int getNbAgs() {
        return this.nbAgs;
    }

    public void setNbAgs(int n) {
        this.nbAgs = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFinishedCycle(String agName, boolean breakpoint, int cycle) {
        if (this.nbAgs < 0 || cycle != this.cycleNumber) {
            this.updateNumberOfAgents();
        }
        if (cycle == this.cycleNumber && this.runningCycle) {
            this.lock.lock();
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Agent " + agName + " has finished cycle " + cycle + ", # of finished agents is " + (this.finished.size() + 1) + "/" + this.nbAgs);
                    if (breakpoint) {
                        logger.fine("Agent " + agName + " reached a breakpoint");
                    }
                }
                this.finished.add(agName);
                if (this.testEndCycle(this.finished)) {
                    this.agFinishedCond.signal();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected boolean testEndCycle(Set<String> finishedAgs) {
        return finishedAgs.size() >= this.getNbAgs();
    }

    public void setExecutionControlInfraTier(ExecutionControlInfraTier jasonControl) {
        this.infraControl = jasonControl;
        this.runtime = this.infraControl.getRuntimeServices();
    }

    public ExecutionControlInfraTier getExecutionControlInfraTier() {
        return this.infraControl;
    }

    public void init(String[] args) {
    }

    public void stop() {
    }

    protected void allAgsFinished() {
        this.startNewCycle();
        this.infraControl.informAllAgsToPerformCycle(this.cycleNumber);
        logger.fine("starting cycle " + this.cycleNumber);
    }

    public int getCycleNumber() {
        return this.cycleNumber;
    }

    public void setRunningCycle(boolean rc) {
        this.runningCycle = rc;
    }

    public String toString() {
        return "Synchronous execution control.";
    }
}

