/*
 * Decompiled with CFR 0.152.
 */
package jason.bb;

import jason.asSemantics.Agent;
import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.PredicateIndicator;
import jason.bb.BeliefBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBeliefBase
implements BeliefBase {
    private static Logger logger = Logger.getLogger(DefaultBeliefBase.class.getSimpleName());
    private Map<PredicateIndicator, BelEntry> belsMap = new ConcurrentHashMap<PredicateIndicator, BelEntry>();
    private int size = 0;
    protected Set<Literal> percepts = new HashSet<Literal>();

    @Override
    public void init(Agent ag, String[] args) {
        if (ag != null) {
            logger = Logger.getLogger(ag.getTS().getUserAgArch().getAgName() + "-" + DefaultBeliefBase.class.getSimpleName());
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Literal> getPercepts() {
        final Iterator<Literal> i = this.percepts.iterator();
        return new Iterator<Literal>(){
            Literal current = null;

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Literal next() {
                this.current = (Literal)i.next();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    logger.warning("Trying to remove a perception, but the the next() from the iterator is not called before!");
                }
                i.remove();
                this.current.delAnnot(BeliefBase.TPercept);
                DefaultBeliefBase.this.removeFromEntry(this.current);
            }
        };
    }

    Set<Literal> getPerceptsSet() {
        return this.percepts;
    }

    @Override
    public boolean add(Literal l) {
        return this.add(l, false);
    }

    @Override
    public boolean add(int index, Literal l) {
        return this.add(l, index != 0);
    }

    protected boolean add(Literal l, boolean addInEnd) {
        if (!l.canBeAddedInBB()) {
            logger.log(Level.SEVERE, "Error: '" + l + "' can not be added in the belief base.");
            return false;
        }
        Literal bl = this.contains(l);
        if (bl != null && !bl.isRule()) {
            if (bl.importAnnots(l)) {
                if (l.hasAnnot(TPercept)) {
                    this.percepts.add(bl);
                }
                return true;
            }
        } else {
            BelEntry entry = this.belsMap.get(l.getPredicateIndicator());
            if (entry == null) {
                entry = new BelEntry();
                this.belsMap.put(l.getPredicateIndicator(), entry);
            }
            entry.add(l, addInEnd);
            if (l.hasAnnot(TPercept)) {
                this.percepts.add(l);
            }
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Literal l) {
        Literal bl = this.contains(l);
        if (bl != null) {
            if (l.hasSubsetAnnot(bl)) {
                if (l.hasAnnot(TPercept)) {
                    this.percepts.remove(bl);
                }
                boolean result = bl.delAnnots(l.getAnnots());
                return this.removeFromEntry(bl) || result;
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Does not contain " + l + " in " + this.belsMap);
        }
        return false;
    }

    private boolean removeFromEntry(Literal l) {
        if (l.hasSource()) {
            return false;
        }
        PredicateIndicator key = l.getPredicateIndicator();
        BelEntry entry = this.belsMap.get(key);
        entry.remove(l);
        if (entry.isEmpty()) {
            this.belsMap.remove(key);
        }
        --this.size;
        return true;
    }

    @Override
    public Iterator<Literal> iterator() {
        final Iterator<BelEntry> ibe = this.belsMap.values().iterator();
        if (ibe.hasNext()) {
            return new Iterator<Literal>(){
                Iterator<Literal> il;
                {
                    this.il = ((BelEntry)ibe.next()).list.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.il.hasNext();
                }

                @Override
                public Literal next() {
                    Literal l = this.il.next();
                    if (!this.il.hasNext() && ibe.hasNext()) {
                        this.il = ((BelEntry)ibe.next()).list.iterator();
                    }
                    return l;
                }

                @Override
                public void remove() {
                    logger.warning("remove is not implemented for BB.iterator().");
                }
            };
        }
        return new ArrayList(0).iterator();
    }

    @Override
    public Iterator<Literal> getAll() {
        return this.iterator();
    }

    @Override
    public boolean abolish(PredicateIndicator pi2) {
        return this.belsMap.remove(pi2) != null;
    }

    @Override
    public Literal contains(Literal l) {
        BelEntry entry = this.belsMap.get(l.getPredicateIndicator());
        if (entry == null) {
            return null;
        }
        return entry.contains(l);
    }

    @Override
    public Iterator<Literal> getCandidateBeliefs(PredicateIndicator pi2) {
        BelEntry entry = this.belsMap.get(pi2);
        if (entry != null) {
            return Collections.unmodifiableList(entry.list).iterator();
        }
        return null;
    }

    @Override
    public Iterator<Literal> getCandidateBeliefs(Literal l, Unifier u) {
        if (l.isVar()) {
            return this.iterator();
        }
        BelEntry entry = this.belsMap.get(l.getPredicateIndicator());
        if (entry != null) {
            return Collections.unmodifiableList(entry.list).iterator();
        }
        return null;
    }

    @Override
    public Iterator<Literal> getRelevant(Literal l) {
        return this.getCandidateBeliefs(l, null);
    }

    public String toString() {
        return this.belsMap.toString();
    }

    @Override
    public BeliefBase clone() {
        DefaultBeliefBase bb = new DefaultBeliefBase();
        for (Literal b : this) {
            bb.add(1, b.copy());
        }
        return bb;
    }

    @Override
    public Element getAsDOM(Document document) {
        Element ebels = null;
        for (int tries = 0; tries < 10; ++tries) {
            ebels = document.createElement("beliefs");
            try {
                for (Literal l : this) {
                    ebels.appendChild(l.getAsDOM(document));
                }
                break;
            }
            catch (Exception e2) {
                continue;
            }
        }
        return ebels;
    }

    final class BelEntry {
        private final List<Literal> list = new LinkedList<Literal>();
        private final Map<LiteralWrapper, Literal> map = new HashMap<LiteralWrapper, Literal>();

        BelEntry() {
        }

        public void add(Literal l, boolean addInEnd) {
            this.map.put(new LiteralWrapper(l), l);
            if (addInEnd) {
                this.list.add(l);
            } else {
                this.list.add(0, l);
            }
        }

        public void remove(Literal l) {
            Literal linmap = this.map.remove(new LiteralWrapper(l));
            if (linmap != null) {
                this.list.remove(linmap);
            }
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Literal contains(Literal l) {
            return this.map.get(new LiteralWrapper(l));
        }

        protected Object clone() {
            BelEntry be = new BelEntry();
            for (Literal l : this.list) {
                be.add(l.copy(), false);
            }
            return be;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (Literal l : this.list) {
                s.append(l + ":" + l.hashCode() + ",");
            }
            return s.toString();
        }

        final class LiteralWrapper {
            private final Literal l;

            public LiteralWrapper(Literal l) {
                this.l = l;
            }

            public int hashCode() {
                return this.l.hashCode();
            }

            public boolean equals(Object o) {
                return o instanceof LiteralWrapper && this.l.equalsAsStructure(((LiteralWrapper)o).l);
            }

            public String toString() {
                return this.l.toString();
            }
        }
    }
}

