/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax.directives;

import jason.asSemantics.Agent;
import jason.asSyntax.Pred;
import jason.asSyntax.StringTerm;
import jason.asSyntax.directives.Directive;
import jason.asSyntax.parser.as2j;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Include
implements Directive {
    static Logger logger = Logger.getLogger(Include.class.getName());
    public static final String CRPrefix = "ClassResource:";
    private List<String> aslSourcePath = null;

    @Override
    public Agent process(Pred directive, Agent outerContent, Agent innerContent) {
        if (outerContent == null) {
            return null;
        }
        String file = ((StringTerm)directive.getTerm(0)).getString().replaceAll("\\\\", "/");
        try {
            InputStream in;
            String outerPrefix = outerContent.getASLSrc();
            if (outerContent != null && outerPrefix != null) {
                if (outerPrefix.startsWith("jar")) {
                    outerPrefix = outerPrefix.substring(0, outerPrefix.indexOf("!") + 1) + "/";
                    file = Include.checkPathAndFixWithSourcePath(file, this.aslSourcePath, outerPrefix);
                    InputStream inputStream = new URL(file).openStream();
                }
                if (outerPrefix.startsWith(CRPrefix)) {
                    int posSlash = outerPrefix.lastIndexOf("/");
                    ArrayList<String> newpath = new ArrayList<String>();
                    if (outerPrefix.indexOf("/") != posSlash) {
                        newpath.add(outerPrefix.substring(CRPrefix.length() + 1, posSlash));
                    }
                    newpath.addAll(this.aslSourcePath);
                    file = Include.checkPathAndFixWithSourcePath(file, newpath, "ClassResource:/");
                    in = Agent.class.getResource(file.substring(CRPrefix.length())).openStream();
                } else {
                    ArrayList<String> newpath = new ArrayList<String>();
                    newpath.add(new File(outerPrefix).getAbsoluteFile().getParent());
                    if (this.aslSourcePath != null) {
                        newpath.addAll(this.aslSourcePath);
                    }
                    file = Include.checkPathAndFixWithSourcePath(file, newpath, null);
                    in = new FileInputStream(file);
                }
            } else {
                in = new FileInputStream(Include.checkPathAndFixWithSourcePath(file, this.aslSourcePath, null));
            }
            Agent ag = new Agent();
            ag.initAg();
            ag.setASLSrc(file);
            as2j parser = new as2j(in);
            parser.agent(ag);
            logger.fine("as2j: AgentSpeak program '" + file + "' parsed successfully!");
            return ag;
        }
        catch (FileNotFoundException e2) {
            logger.log(Level.SEVERE, "The included file '" + file + "' was not found! (it is being included in the agent '" + outerContent.getASLSrc() + "')");
        }
        catch (Exception e3) {
            logger.log(Level.SEVERE, "as2j: error parsing \"" + file + "\"", e3);
        }
        return null;
    }

    public void setSourcePath(List<String> sp) {
        this.aslSourcePath = sp;
    }

    public static String checkPathAndFixWithSourcePath(String f, List<String> srcpath, String urlPrefix) {
        block8: {
            block7: {
                if (urlPrefix != null && urlPrefix.length() != 0) break block7;
                if (new File(f).exists()) {
                    return f;
                }
                if (srcpath == null) break block8;
                for (String path : srcpath) {
                    try {
                        File newname = new File(path + "/" + f.toString());
                        if (!newname.exists()) continue;
                        return newname.getCanonicalFile().toString();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                break block8;
            }
            if (Include.testURLSrc(urlPrefix + f)) {
                return urlPrefix + f;
            }
            if (srcpath != null) {
                for (String path : srcpath) {
                    String newname = urlPrefix + path + "/" + f;
                    if (!Include.testURLSrc(newname)) continue;
                    return newname;
                }
            }
        }
        return f;
    }

    private static boolean testURLSrc(String asSrc) {
        try {
            if (asSrc.startsWith(CRPrefix)) {
                Agent.class.getResource(asSrc.substring(CRPrefix.length())).openStream();
                return true;
            }
            Agent.class.getResource(asSrc).openStream();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

