/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax.directives;

import jason.asSemantics.Agent;
import jason.asSyntax.Pred;
import jason.asSyntax.directives.Directive;
import jason.asSyntax.directives.FunctionRegister;
import jason.asSyntax.directives.Include;
import jason.asSyntax.patterns.goal.BC;
import jason.asSyntax.patterns.goal.BDG;
import jason.asSyntax.patterns.goal.DG;
import jason.asSyntax.patterns.goal.EBDG;
import jason.asSyntax.patterns.goal.MG;
import jason.asSyntax.patterns.goal.OMC;
import jason.asSyntax.patterns.goal.RC;
import jason.asSyntax.patterns.goal.SGA;
import jason.asSyntax.patterns.goal.SMC;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectiveProcessor {
    static Logger logger = Logger.getLogger(DirectiveProcessor.class.getName());
    private static Map<String, Directive> directives = new HashMap<String, Directive>();

    public static void addDirective(String id, Directive d) {
        directives.put(id, d);
    }

    public static Directive getDirective(String id) {
        return directives.get(id);
    }

    public static Directive removeDirective(String id) {
        return directives.remove(id);
    }

    public static Agent process(Pred directive, Agent outerAg, Agent innerAg) {
        try {
            logger.fine("Processing directive " + directive);
            Directive d = directives.get(directive.getFunctor());
            if (d != null) {
                return d.process(directive, outerAg, innerAg);
            }
            logger.log(Level.SEVERE, "Unknown directive " + directive);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error processing directive " + directive, e2);
        }
        return null;
    }

    static {
        DirectiveProcessor.addDirective("include", new Include());
        DirectiveProcessor.addDirective("register_function", new FunctionRegister());
        DirectiveProcessor.addDirective("dg", new DG());
        DirectiveProcessor.addDirective("bdg", new BDG());
        DirectiveProcessor.addDirective("ebdg", new EBDG());
        DirectiveProcessor.addDirective("bc", new BC());
        DirectiveProcessor.addDirective("smc", new SMC());
        DirectiveProcessor.addDirective("rc", new RC());
        DirectiveProcessor.addDirective("omc", new OMC());
        DirectiveProcessor.addDirective("mg", new MG());
        DirectiveProcessor.addDirective("sga", new SGA());
    }
}

