/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Literal;
import jason.asSyntax.Plan;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PredicateIndicator;
import jason.asSyntax.StringTerm;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.ParseException;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Trigger
extends Structure
implements Cloneable {
    private static Logger logger = Logger.getLogger(Trigger.class.getName());
    private TEOperator operator = TEOperator.add;
    private TEType type = TEType.belief;
    private Literal literal;
    private boolean isTerm = false;

    public Trigger(TEOperator op, TEType t, Literal l) {
        super("te", 0);
        this.literal = l;
        this.type = t;
        this.setTrigOp(op);
        this.setSrcInfo(l.getSrcInfo());
    }

    public static Trigger parseTrigger(String sTe) {
        as2j parser = new as2j(new StringReader(sTe));
        try {
            return parser.trigger();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing trigger" + sTe, e2);
            return null;
        }
    }

    public int getArity() {
        return 2;
    }

    public Term getTerm(int i) {
        switch (i) {
            case 0: {
                return new StringTermImpl(this.operator.toString() + this.type.toString());
            }
            case 1: {
                return this.literal;
            }
        }
        return null;
    }

    public void setTerm(int i, Term t) {
        switch (i) {
            case 0: {
                logger.warning("setTerm(i,t) for i=0 -- the operator -- , IS NOT IMPLEMENTED YET!!!");
                break;
            }
            case 1: {
                this.literal = (Literal)t;
            }
        }
    }

    public void setTrigOp(TEOperator op) {
        this.operator = op;
        this.predicateIndicatorCache = null;
    }

    public boolean sameType(Trigger e2) {
        return this.operator == e2.operator && this.type == e2.type;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Trigger) {
            Trigger t = (Trigger)o;
            return this.operator == t.operator && this.type == t.type && this.literal.equals(t.getLiteral());
        }
        return false;
    }

    public boolean isAchvGoal() {
        return this.type == TEType.achieve;
    }

    public boolean isGoal() {
        return this.type == TEType.achieve || this.type == TEType.test;
    }

    public TEOperator getOperator() {
        return this.operator;
    }

    public TEType getType() {
        return this.type;
    }

    public boolean isAddition() {
        return this.operator == TEOperator.add;
    }

    public Trigger clone() {
        Trigger c = new Trigger(this.operator, this.type, this.literal.copy());
        c.predicateIndicatorCache = this.predicateIndicatorCache;
        c.isTerm = this.isTerm;
        return c;
    }

    public PredicateIndicator getPredicateIndicator() {
        if (this.predicateIndicatorCache == null) {
            this.predicateIndicatorCache = new PredicateIndicator(this.operator.toString() + (Object)((Object)this.type) + this.literal.getFunctor(), this.literal.getArity());
        }
        return this.predicateIndicatorCache;
    }

    public boolean apply(Unifier u) {
        return this.literal.apply(u);
    }

    public Literal getLiteral() {
        return this.literal;
    }

    public void setLiteral(Literal literal2) {
        this.literal = literal2;
        this.predicateIndicatorCache = null;
    }

    public void setAsTriggerTerm(boolean b) {
        this.isTerm = b;
    }

    public String toString() {
        String e2;
        String b;
        if (this.isTerm) {
            b = "{ ";
            e2 = " }";
        } else {
            b = "";
            e2 = "";
        }
        return b + (Object)((Object)this.operator) + (Object)((Object)this.type) + this.literal + e2;
    }

    public static Trigger tryToGetTrigger(Term t) throws ParseException {
        PlanBody p;
        if (t instanceof Trigger) {
            return (Trigger)t;
        }
        if (t instanceof VarTerm) {
            VarTerm v = (VarTerm)t;
            if (v.hasValue() && v.getValue() instanceof Trigger) {
                return (Trigger)v.getValue();
            }
            if (v.hasValue() && v.getValue() instanceof Plan) {
                return ((Plan)v.getValue()).getTrigger();
            }
        }
        if (t.isString()) {
            return ASSyntax.parseTrigger(((StringTerm)t).getString());
        }
        if (t.isPlanBody() && (p = (PlanBody)t).getPlanSize() == 1) {
            if (p.getBodyType() == PlanBody.BodyType.addBel) {
                return new Trigger(TEOperator.add, TEType.belief, (Literal)p.getBodyTerm());
            }
            if (p.getBodyType() == PlanBody.BodyType.delBel) {
                return new Trigger(TEOperator.del, TEType.belief, (Literal)p.getBodyTerm());
            }
        }
        return null;
    }

    public Element getAsDOM(Document document) {
        Element e2 = document.createElement("trigger");
        e2.setAttribute("operator", this.operator.toString());
        e2.setAttribute("type", this.type.toString());
        e2.appendChild(this.literal.getAsDOM(document));
        return e2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TEType {
        belief{

            public String toString() {
                return "";
            }
        }
        ,
        achieve{

            public String toString() {
                return "!";
            }
        }
        ,
        test{

            public String toString() {
                return "?";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TEOperator {
        add{

            public String toString() {
                return "+";
            }
        }
        ,
        del{

            public String toString() {
                return "-";
            }
        }
        ,
        goalState{

            public String toString() {
                return "^";
            }
        };

    }
}

