/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PlanBodyImpl;
import jason.asSyntax.Pred;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.parser.as2j;
import java.io.Serializable;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Plan
extends Structure
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Term TAtomic = ASSyntax.createAtom("atomic");
    private static final Term TBreakPoint = ASSyntax.createAtom("breakpoint");
    private static final Term TAllUnifs = ASSyntax.createAtom("all_unifs");
    private static Logger logger = Logger.getLogger(Plan.class.getName());
    private Pred label = null;
    private Trigger tevent = null;
    private LogicalFormula context;
    private PlanBody body;
    private boolean isAtomic = false;
    private boolean isAllUnifs = false;
    private boolean hasBreakpoint = false;
    private boolean isTerm = false;
    private static final Term noLabelAtom = new Atom("nolabel");

    public Plan() {
        super("plan", 0);
    }

    public Plan(Pred label, Trigger te, LogicalFormula ct, PlanBody bd) {
        super("plan", 0);
        this.tevent = te;
        this.tevent.setAsTriggerTerm(false);
        this.setLabel(label);
        this.setContext(ct);
        if (bd == null) {
            this.body = new PlanBodyImpl();
        } else {
            this.body = bd;
            this.body.setAsBodyTerm(false);
        }
    }

    public int getArity() {
        return 4;
    }

    public Term getTerm(int i) {
        switch (i) {
            case 0: {
                return this.label == null ? noLabelAtom : this.label;
            }
            case 1: {
                return this.tevent;
            }
            case 2: {
                return this.context == null ? Literal.LTrue : this.context;
            }
            case 3: {
                return this.body;
            }
        }
        return null;
    }

    public void setTerm(int i, Term t) {
        switch (i) {
            case 0: {
                this.label = (Pred)t;
                break;
            }
            case 1: {
                this.tevent = (Trigger)t;
                break;
            }
            case 2: {
                this.context = (LogicalFormula)t;
                break;
            }
            case 3: {
                this.body = (PlanBody)t;
            }
        }
    }

    public void setLabel(Pred p) {
        this.label = p;
        if (p != null && p.hasAnnot()) {
            for (Term t : this.label.getAnnots()) {
                if (((Object)t).equals(TAtomic)) {
                    this.isAtomic = true;
                }
                if (((Object)t).equals(TBreakPoint)) {
                    this.hasBreakpoint = true;
                }
                if (!((Object)t).equals(TAllUnifs)) continue;
                this.isAllUnifs = true;
            }
        }
    }

    public Pred getLabel() {
        return this.label;
    }

    public void setContext(LogicalFormula le) {
        this.context = le;
        if (Literal.LTrue.equals(le)) {
            this.context = null;
        }
    }

    public void setAsPlanTerm(boolean b) {
        this.isTerm = b;
    }

    public static Plan parse(String sPlan) {
        as2j parser = new as2j(new StringReader(sPlan));
        try {
            return parser.plan();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing plan " + sPlan, e2);
            return null;
        }
    }

    public Trigger getTriggerEvent() {
        return this.tevent;
    }

    public Trigger getTrigger() {
        return this.tevent;
    }

    public LogicalFormula getContext() {
        return this.context;
    }

    public PlanBody getBody() {
        return this.body;
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    public boolean hasBreakpoint() {
        return this.hasBreakpoint;
    }

    public boolean isAllUnifs() {
        return this.isAllUnifs;
    }

    public Unifier isRelevant(Trigger te) {
        Unifier u = new Unifier();
        if (u.unifiesNoUndo(this.tevent, te)) {
            return u;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Plan) {
            Plan p = (Plan)o;
            if (this.context == null && p.context != null) {
                return false;
            }
            if (this.context != null && p.context != null && !this.context.equals(p.context)) {
                return false;
            }
            return this.tevent.equals(p.tevent) && this.body.equals(p.body);
        }
        return false;
    }

    public Term clone() {
        Plan p = new Plan();
        if (this.label != null) {
            p.label = (Pred)this.label.clone();
            p.isAtomic = this.isAtomic;
            p.hasBreakpoint = this.hasBreakpoint;
            p.isAllUnifs = this.isAllUnifs;
        }
        p.tevent = this.tevent.clone();
        if (this.context != null) {
            p.context = (LogicalFormula)this.context.clone();
        }
        p.body = this.body.clonePB();
        p.setSrcInfo(this.srcInfo);
        p.isTerm = this.isTerm;
        return p;
    }

    public Plan cloneOnlyBody() {
        Plan p = new Plan();
        if (this.label != null) {
            p.label = this.label;
            p.isAtomic = this.isAtomic;
            p.hasBreakpoint = this.hasBreakpoint;
            p.isAllUnifs = this.isAllUnifs;
        }
        p.tevent = this.tevent.clone();
        p.context = this.context;
        p.body = this.body.clonePB();
        p.setSrcInfo(this.srcInfo);
        p.isTerm = this.isTerm;
        return p;
    }

    public String toString() {
        return this.toASString();
    }

    public String toASString() {
        String e2;
        String b;
        if (this.isTerm) {
            b = "{ ";
            e2 = " }";
        } else {
            b = "";
            e2 = ".";
        }
        return b + (this.label == null ? "" : "@" + this.label + " ") + this.tevent + (this.context == null ? "" : " : " + this.context) + (this.body.isEmptyBody() ? "" : " <- " + this.body) + e2;
    }

    public Element getAsDOM(Document document) {
        Element u = document.createElement("plan");
        if (this.label != null) {
            Element l = document.createElement("label");
            l.appendChild(new LiteralImpl(this.label).getAsDOM(document));
            u.appendChild(l);
        }
        u.appendChild(this.tevent.getAsDOM(document));
        if (this.context != null) {
            Element ec = document.createElement("context");
            ec.appendChild(this.context.getAsDOM(document));
            u.appendChild(ec);
        }
        if (!this.body.isEmptyBody()) {
            u.appendChild(this.body.getAsDOM(document));
        }
        return u;
    }
}

