/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.Pred;
import jason.asSyntax.PredicateIndicator;
import jason.asSyntax.Term;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LiteralImpl
extends Pred
implements LogicalFormula {
    private static final long serialVersionUID = 1L;
    private boolean type = true;

    public LiteralImpl(String functor) {
        super(functor);
    }

    public LiteralImpl(boolean pos, String functor) {
        super(functor);
        this.type = pos;
    }

    public LiteralImpl(Literal l) {
        super(l);
        this.type = !l.negated();
    }

    public LiteralImpl(boolean pos, Literal l) {
        super(l);
        this.type = pos;
    }

    protected LiteralImpl(String functor, int terms) {
        super(functor, terms);
    }

    public boolean isAtom() {
        return super.isAtom() && !this.negated();
    }

    public boolean canBeAddedInBB() {
        return true;
    }

    public boolean negated() {
        return !this.type;
    }

    public Literal setNegated(boolean b) {
        this.type = b;
        this.resetHashCodeCache();
        return this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof LiteralImpl) {
            LiteralImpl l = (LiteralImpl)o;
            return this.type == l.type && this.hashCode() == l.hashCode() && super.equals(l);
        }
        if (o instanceof Atom && !this.negated()) {
            return super.equals(o);
        }
        return false;
    }

    public String getErrorMsg() {
        String src = this.getSrcInfo() == null ? "" : " (" + this.getSrcInfo() + ")";
        return "Error in '" + this + "'" + src;
    }

    public int compareTo(Term t) {
        if (t == null) {
            return -1;
        }
        if (t.isLiteral()) {
            Literal tl = (Literal)t;
            if (!this.negated() && tl.negated()) {
                return -1;
            }
            if (this.negated() && !tl.negated()) {
                return 1;
            }
        }
        return super.compareTo(t);
    }

    public Term clone() {
        return new LiteralImpl(this);
    }

    protected int calcHashCode() {
        int result = super.calcHashCode();
        if (this.negated()) {
            result += 3271;
        }
        return result;
    }

    public PredicateIndicator getPredicateIndicator() {
        if (this.predicateIndicatorCache == null) {
            this.predicateIndicatorCache = new PredicateIndicator(this.type ? this.getFunctor() : "~" + this.getFunctor(), this.getArity());
        }
        return this.predicateIndicatorCache;
    }

    public String toString() {
        if (this.type) {
            return super.toString();
        }
        return "~" + super.toString();
    }

    public Element getAsDOM(Document document) {
        Element u = document.createElement("literal");
        if (this.negated()) {
            u.setAttribute("negated", this.negated() + "");
        }
        u.appendChild(super.getAsDOM(document));
        return u;
    }
}

