/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Agent;
import jason.asSemantics.ArithFunction;
import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.LogExpr;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithFunctionTerm
extends Structure
implements NumberTerm {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ArithFunctionTerm.class.getName());
    private NumberTerm value = null;
    private ArithFunction function = null;
    private Agent agent = null;

    public ArithFunctionTerm(String functor, int termsSize) {
        super(functor, termsSize);
    }

    public ArithFunctionTerm(ArithFunction function) {
        super(function.getName(), 2);
        this.function = function;
    }

    public ArithFunctionTerm(ArithFunctionTerm af) {
        super(af);
        this.value = af.value;
        this.function = af.function;
        this.agent = af.agent;
    }

    public NumberTerm getValue() {
        return this.value;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean isStructure() {
        return false;
    }

    @Override
    public Literal makeVarsAnnon(Unifier un) {
        if (this.isEvaluated()) {
            return null;
        }
        return super.makeVarsAnnon(un);
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isArithExpr() {
        return !this.isEvaluated();
    }

    public boolean isEvaluated() {
        return this.value != null;
    }

    @Override
    public boolean isGround() {
        return this.isEvaluated() || super.isGround();
    }

    public boolean isUnary() {
        return this.getArity() == 1;
    }

    @Override
    public boolean apply(Unifier u) {
        if (this.isEvaluated()) {
            return false;
        }
        super.apply(u);
        if (this.function != null && this.function.allowUngroundTerms() || this.isGround()) {
            try {
                this.value = new NumberTermImpl(this.solve());
                return true;
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, this.getErrorMsg() + " -- " + e2);
            }
        }
        return false;
    }

    public void setAgent(Agent ag) {
        this.agent = ag;
    }

    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public double solve() {
        if (this.isEvaluated()) {
            return this.value.solve();
        }
        if (this.function != null) {
            try {
                return this.function.evaluate(this.agent == null ? null : this.agent.getTS(), this.getTermsArray());
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, this.getErrorMsg() + " -- error in evaluate!", e2);
            }
        } else {
            logger.log(Level.SEVERE, this.getErrorMsg() + " -- the function can not be evalutated, it has no function assigned to it!", new Exception());
        }
        return 0.0;
    }

    public boolean checkArity(int a) {
        return this.function != null && this.function.checkArity(a);
    }

    @Override
    public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
        logger.log(Level.WARNING, "Arithmetic term cannot be used for logical consequence!", new Exception());
        return LogExpr.EMPTY_UNIF_LIST.iterator();
    }

    @Override
    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (this.isEvaluated()) {
            return this.value.equals(t);
        }
        return super.equals(t);
    }

    @Override
    public int compareTo(Term o) {
        if (o instanceof VarTerm) {
            return o.compareTo(this) * -1;
        }
        if (o instanceof NumberTerm) {
            NumberTerm st = (NumberTerm)o;
            if (this.solve() > st.solve()) {
                return 1;
            }
            if (this.solve() < st.solve()) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    protected int calcHashCode() {
        if (this.isEvaluated()) {
            return this.value.hashCode();
        }
        return super.calcHashCode();
    }

    @Override
    public String toString() {
        if (this.isEvaluated()) {
            return this.value.toString();
        }
        return super.toString();
    }

    @Override
    public String getErrorMsg() {
        return "Error in '" + this + "' (" + super.getErrorMsg() + ")";
    }

    @Override
    public NumberTerm clone() {
        if (this.isEvaluated()) {
            return this.value;
        }
        return new ArithFunctionTerm(this);
    }

    @Override
    public Element getAsDOM(Document document) {
        if (this.isEvaluated()) {
            return this.value.getAsDOM(document);
        }
        Element u = document.createElement("expression");
        u.setAttribute("type", "arithmetic");
        Element r = document.createElement("right");
        r.appendChild(super.getAsDOM(document));
        u.appendChild(r);
        return u;
    }
}

