/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSyntax.ASSyntax;
import jason.asSyntax.parser.ParseException;
import java.io.Serializable;

public class Message
implements Serializable {
    private String ilForce = null;
    private String sender = null;
    private String receiver = null;
    private Object propCont = null;
    private String msgId = null;
    private String inReplyTo = null;
    private static int idCount = 1;
    public static final String[] knownPerformatives = new String[]{"tell", "untell", "achieve", "unachieve", "askOne", "askAll", "tellHow", "untellHow", "askHow"};

    public Message() {
    }

    public Message(String ilf, String s, String r, Object c) {
        this(ilf, s, r, c, "mid" + idCount++);
    }

    public Message(String ilf, String s, String r, Object c, String id) {
        this.setIlForce(ilf);
        this.sender = s;
        this.receiver = r;
        this.propCont = c;
        this.msgId = id;
    }

    public Message(Message m) {
        this.ilForce = m.ilForce;
        this.sender = m.sender;
        this.receiver = m.receiver;
        this.propCont = m.propCont;
        this.msgId = m.msgId;
        this.inReplyTo = m.inReplyTo;
    }

    public String getIlForce() {
        return this.ilForce;
    }

    public void setIlForce(String ilf) {
        if (ilf.equals("ask-one")) {
            ilf = "askOne";
        }
        if (ilf.equals("ask-all")) {
            ilf = "askAll";
        }
        if (ilf.equals("tell-how")) {
            ilf = "tellHow";
        }
        if (ilf.equals("ask-how")) {
            ilf = "askHow";
        }
        if (ilf.equals("untell-how")) {
            ilf = "untellHow";
        }
        this.ilForce = ilf;
    }

    public boolean isAsk() {
        return this.ilForce.startsWith("ask");
    }

    public boolean isTell() {
        return this.ilForce.startsWith("tell");
    }

    public boolean isUnTell() {
        return this.ilForce.startsWith("untell");
    }

    public boolean isKnownPerformative() {
        for (String s : knownPerformatives) {
            if (!this.ilForce.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void setPropCont(Object o) {
        this.propCont = o;
    }

    public Object getPropCont() {
        return this.propCont;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setSender(String agName) {
        this.sender = agName;
    }

    public String getSender() {
        return this.sender;
    }

    public void setReceiver(String agName) {
        this.receiver = agName;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String id) {
        this.msgId = id;
    }

    public String getInReplyTo() {
        return this.inReplyTo;
    }

    public void setInReplyTo(String inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public Message clone() {
        return new Message(this);
    }

    public static Message parseMsg(String msg) throws ParseException {
        Message newmsg = new Message();
        if (msg.startsWith("<")) {
            int arrowIndex;
            int one = msg.indexOf(",");
            if (one < (arrowIndex = msg.indexOf("->"))) {
                newmsg.msgId = msg.substring(1, arrowIndex);
                newmsg.inReplyTo = msg.substring(arrowIndex + 2, one);
            } else {
                newmsg.msgId = msg.substring(1, one);
            }
            int two = msg.indexOf(",", one + 1);
            newmsg.sender = msg.substring(one + 1, two);
            one = msg.indexOf(",", two + 1);
            newmsg.ilForce = msg.substring(two + 1, one);
            two = msg.indexOf(",", one + 1);
            newmsg.receiver = msg.substring(one + 1, two);
            one = msg.indexOf(">", two + 1);
            String content = msg.substring(two + 1, one);
            newmsg.propCont = ASSyntax.parseTerm(content);
        }
        return newmsg;
    }

    public String toString() {
        String irt = this.inReplyTo == null ? "" : "->" + this.inReplyTo;
        return "<" + this.msgId + irt + "," + this.sender + "," + this.ilForce + "," + this.receiver + "," + this.propCont + ">";
    }
}

