/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSemantics.Event;
import jason.asSemantics.GoalListener;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Trigger;

public class GoalListenerForMetaEvents
implements GoalListener {
    private TransitionSystem ts;

    public GoalListenerForMetaEvents(TransitionSystem ts) {
        this.ts = ts;
    }

    public void goalStarted(Event goal) {
        this.generateGoalStateEvent(goal.getTrigger().getLiteral(), Trigger.TEType.achieve, GoalListener.GoalStates.started, null);
    }

    public void goalFailed(Trigger goal) {
        this.generateGoalStateEvent(goal.getLiteral(), goal.getType(), GoalListener.GoalStates.failed, null);
    }

    public void goalFinished(Trigger goal) {
        this.generateGoalStateEvent(goal.getLiteral(), goal.getType(), GoalListener.GoalStates.finished, null);
    }

    public void goalResumed(Trigger goal) {
        this.generateGoalStateEvent(goal.getLiteral(), goal.getType(), GoalListener.GoalStates.resumed, null);
    }

    public void goalSuspended(Trigger goal, String reason) {
        this.generateGoalStateEvent(goal.getLiteral(), goal.getType(), GoalListener.GoalStates.suspended, reason);
    }

    private void generateGoalStateEvent(Literal goal, Trigger.TEType type, GoalListener.GoalStates state, String reason) {
        goal = goal.forceFullLiteralImpl().copy();
        Literal stateAnnot = ASSyntax.createLiteral("state", new Atom(state.toString()));
        if (reason != null) {
            stateAnnot.addAnnot(ASSyntax.createStructure("reason", new StringTermImpl(reason)));
        }
        goal.addAnnot(stateAnnot);
        Trigger eEnd = new Trigger(Trigger.TEOperator.goalState, type, goal);
        if (this.ts.getAg().getPL().hasCandidatePlan(eEnd)) {
            this.ts.getC().addEvent(new Event(eEnd, null));
        }
    }
}

