/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSemantics.ActionExec;
import jason.asSemantics.CircumstanceListener;
import jason.asSemantics.Event;
import jason.asSemantics.Intention;
import jason.asSemantics.Message;
import jason.asSemantics.Option;
import jason.asSyntax.Literal;
import jason.asSyntax.Trigger;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Circumstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Queue<Event> E;
    private Queue<Intention> I;
    protected ActionExec A;
    protected Queue<Message> MB;
    protected List<Option> RP;
    protected List<Option> AP;
    protected Event SE;
    protected Option SO;
    protected Intention SI;
    private Intention AI;
    private boolean atomicIntSuspended = false;
    private Map<Integer, ActionExec> PA;
    private List<ActionExec> FA;
    private Map<String, Intention> PI;
    private List<CircumstanceListener> listeners = new CopyOnWriteArrayList<CircumstanceListener>();

    public Circumstance() {
        this.create();
        this.reset();
    }

    public void create() {
        this.E = new ConcurrentLinkedQueue<Event>();
        this.I = new ConcurrentLinkedQueue<Intention>();
        this.MB = new LinkedList<Message>();
        this.PA = new ConcurrentHashMap<Integer, ActionExec>();
        this.PI = new ConcurrentHashMap<String, Intention>();
        this.FA = new ArrayList<ActionExec>();
    }

    public void reset() {
        this.A = null;
        this.RP = null;
        this.AP = null;
        this.SE = null;
        this.SO = null;
        this.SI = null;
    }

    public Event addAchvGoal(Literal l, Intention i) {
        Event evt = new Event(new Trigger(Trigger.TEOperator.add, Trigger.TEType.achieve, l), i);
        this.addEvent(evt);
        return evt;
    }

    public void addExternalEv(Trigger trig) {
        this.addEvent(new Event(trig, Intention.EmptyInt));
    }

    public void addEvent(Event ev) {
        this.E.add(ev);
        if (this.listeners != null) {
            for (CircumstanceListener el : this.listeners) {
                el.eventAdded(ev);
            }
        }
    }

    public boolean removeEvent(Event ev) {
        return this.E.remove(ev);
    }

    public void clearEvents() {
        if (this.listeners != null) {
            for (CircumstanceListener el : this.listeners) {
                for (Event ev : this.E) {
                    el.intentionDropped(ev.getIntention());
                }
            }
        }
        this.E.clear();
    }

    public Queue<Event> getEvents() {
        return this.E;
    }

    public boolean hasEvent() {
        return !this.E.isEmpty();
    }

    public Event removeAtomicEvent() {
        Iterator i = this.E.iterator();
        while (i.hasNext()) {
            Event e2 = (Event)i.next();
            if (e2.getIntention() == null || !e2.getIntention().isAtomic()) continue;
            i.remove();
            return e2;
        }
        return null;
    }

    public void addEventListener(CircumstanceListener el) {
        this.listeners.add(el);
    }

    public void removeEventListener(CircumstanceListener el) {
        if (el != null) {
            this.listeners.remove(el);
        }
    }

    public boolean hasListener() {
        return !this.listeners.isEmpty();
    }

    public Collection<CircumstanceListener> getListeners() {
        return this.listeners;
    }

    public Queue<Message> getMailBox() {
        return this.MB;
    }

    public Queue<Intention> getIntentions() {
        return this.I;
    }

    public boolean hasIntention() {
        return this.I != null && !this.I.isEmpty();
    }

    public void addIntention(Intention intention) {
        this.I.offer(intention);
        if (intention.isAtomic()) {
            this.setAtomicIntention(intention);
        }
        if (this.listeners != null) {
            for (CircumstanceListener el : this.listeners) {
                el.intentionAdded(intention);
            }
        }
    }

    public void resumeIntention(Intention intention) {
        this.addIntention(intention);
        if (this.listeners != null) {
            for (CircumstanceListener el : this.listeners) {
                el.intentionResumed(intention);
            }
        }
    }

    public boolean removeIntention(Intention i) {
        if (i == this.AI) {
            this.setAtomicIntention(null);
        }
        return this.I.remove(i);
    }

    public boolean dropIntention(Intention i) {
        if (this.removeIntention(i)) {
            if (this.listeners != null) {
                for (CircumstanceListener el : this.listeners) {
                    el.intentionDropped(i);
                }
            }
            return true;
        }
        return false;
    }

    public void clearIntentions() {
        this.setAtomicIntention(null);
        if (this.listeners != null) {
            for (CircumstanceListener el : this.listeners) {
                for (Intention i : this.I) {
                    el.intentionDropped(i);
                }
            }
        }
        this.I.clear();
    }

    public void setAtomicIntention(Intention i) {
        this.AI = i;
    }

    public Intention removeAtomicIntention() {
        if (this.AI != null) {
            if (this.atomicIntSuspended) {
                return null;
            }
            Intention tmp = this.AI;
            this.removeIntention(this.AI);
            return tmp;
        }
        return null;
    }

    public boolean hasAtomicIntention() {
        return this.AI != null;
    }

    public boolean isAtomicIntentionSuspended() {
        return this.AI != null && this.atomicIntSuspended;
    }

    public Map<String, Intention> getPendingIntentions() {
        return this.PI;
    }

    public boolean hasPendingIntention() {
        return this.PI != null && this.PI.size() > 0;
    }

    public void clearPendingIntentions() {
        if (this.listeners != null) {
            for (CircumstanceListener el : this.listeners) {
                for (Intention i : this.PI.values()) {
                    el.intentionDropped(i);
                }
            }
        }
        this.PI.clear();
    }

    public void addPendingIntention(String id, Intention i) {
        if (i.isAtomic()) {
            this.setAtomicIntention(i);
            this.atomicIntSuspended = true;
        }
        this.PI.put(id, i);
        if (this.listeners != null) {
            for (CircumstanceListener el : this.listeners) {
                el.intentionSuspended(i, id);
            }
        }
    }

    public Intention removePendingIntention(String pendingId) {
        Intention i = this.PI.remove(pendingId);
        if (i != null && i.isAtomic()) {
            this.atomicIntSuspended = false;
        }
        return i;
    }

    public Intention removePendingIntention(int intentionId) {
        for (String key : this.PI.keySet()) {
            Intention pii = this.PI.get(key);
            if (pii.getId() != intentionId) continue;
            return this.removePendingIntention(key);
        }
        return null;
    }

    public boolean dropPendingIntention(Intention i) {
        for (String key : this.PI.keySet()) {
            Intention pii = this.PI.get(key);
            if (!pii.equals(i)) continue;
            this.removePendingIntention(key);
            if (this.listeners != null) {
                for (CircumstanceListener el : this.listeners) {
                    el.intentionDropped(i);
                }
            }
            return true;
        }
        return false;
    }

    public ActionExec getAction() {
        return this.A;
    }

    public void setAction(ActionExec a) {
        this.A = a;
    }

    public List<Option> getApplicablePlans() {
        return this.AP;
    }

    public boolean hasFeedbackAction() {
        return !this.FA.isEmpty();
    }

    public List<ActionExec> getFeedbackActions() {
        return this.FA;
    }

    public List<ActionExec> getFeedbackActionsWrapper() {
        return new AbstractList<ActionExec>(){

            @Override
            public boolean add(ActionExec act) {
                Circumstance.this.addFeedbackAction(act);
                return true;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public ActionExec get(int index) {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeedbackAction(ActionExec act) {
        if (act.getIntention() != null) {
            List<ActionExec> list2 = this.FA;
            synchronized (list2) {
                this.FA.add(act);
            }
            if (act.getIntention().isAtomic()) {
                this.atomicIntSuspended = false;
            }
        }
    }

    public Map<Integer, ActionExec> getPendingActions() {
        return this.PA;
    }

    public void addPendingAction(ActionExec a) {
        Intention i = a.getIntention();
        if (i.isAtomic()) {
            this.setAtomicIntention(i);
            this.atomicIntSuspended = true;
        }
        this.PA.put(i.getId(), a);
        if (this.listeners != null) {
            for (CircumstanceListener el : this.listeners) {
                el.intentionSuspended(i, "action " + a.getActionTerm());
            }
        }
    }

    public void clearPendingActions() {
        if (this.listeners != null) {
            for (CircumstanceListener el : this.listeners) {
                for (ActionExec act : this.PA.values()) {
                    el.intentionDropped(act.getIntention());
                }
            }
        }
        this.PA.clear();
    }

    public boolean hasPendingAction() {
        return this.PA != null && this.PA.size() > 0;
    }

    public ActionExec removePendingAction(int intentionId) {
        ActionExec a = this.PA.remove(intentionId);
        if (a != null && a.getIntention().isAtomic()) {
            this.atomicIntSuspended = false;
        }
        return a;
    }

    public boolean dropPendingAction(Intention i) {
        ActionExec act = this.removePendingAction(i.getId());
        if (act != null) {
            if (this.listeners != null) {
                for (CircumstanceListener el : this.listeners) {
                    el.intentionDropped(i);
                }
            }
            return true;
        }
        return false;
    }

    public List<Option> getRelevantPlans() {
        return this.RP;
    }

    public Event getSelectedEvent() {
        return this.SE;
    }

    public Intention getSelectedIntention() {
        return this.SI;
    }

    public Option getSelectedOption() {
        return this.SO;
    }

    public Circumstance clone() {
        Circumstance c = new Circumstance();
        for (Event e2 : this.E) {
            c.E.add((Event)e2.clone());
        }
        for (Intention i : this.I) {
            c.I.add(i.clone());
        }
        for (Message m : this.MB) {
            c.MB.add(m.clone());
        }
        Iterator<Object> i$ = this.PA.keySet().iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            c.PA.put(k, this.PA.get(k).clone());
        }
        for (String k : this.PI.keySet()) {
            c.PI.put(k, this.PI.get(k).clone());
        }
        for (ActionExec ae : this.FA) {
            c.FA.add(ae.clone());
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getAsDOM(Document document) {
        Element e2;
        Iterator<Object> i;
        Element c = document.createElement("circumstance");
        if (this.getMailBox() != null && !this.getMailBox().isEmpty()) {
            Element ms = document.createElement("mailbox");
            i = this.getMailBox().iterator();
            while (i.hasNext()) {
                e2 = document.createElement("message");
                e2.appendChild(document.createTextNode(i.next().toString()));
                ms.appendChild(e2);
            }
            c.appendChild(ms);
        }
        Element events = document.createElement("events");
        boolean add = false;
        if (this.E != null && !this.E.isEmpty()) {
            i = this.E.iterator();
            while (i.hasNext()) {
                add = true;
                Event evt = (Event)i.next();
                e2 = evt.getAsDOM(document);
                events.appendChild(e2);
            }
        }
        if (this.getSelectedEvent() != null) {
            add = true;
            e2 = this.getSelectedEvent().getAsDOM(document);
            e2.setAttribute("selected", "true");
            events.appendChild(e2);
        }
        if (add) {
            c.appendChild(events);
        }
        Element plans = document.createElement("options");
        ArrayList<Serializable> alreadyIn = new ArrayList<Serializable>();
        if (this.getSelectedOption() != null) {
            alreadyIn.add(this.getSelectedOption());
            e2 = this.getSelectedOption().getAsDOM(document);
            e2.setAttribute("relevant", "true");
            e2.setAttribute("applicable", "true");
            e2.setAttribute("selected", "true");
            plans.appendChild(e2);
        }
        if (this.getApplicablePlans() != null && !this.getApplicablePlans().isEmpty()) {
            for (Option o : this.getApplicablePlans()) {
                if (alreadyIn.contains(o)) continue;
                alreadyIn.add(o);
                e2 = o.getAsDOM(document);
                e2.setAttribute("relevant", "true");
                e2.setAttribute("applicable", "true");
                plans.appendChild(e2);
            }
        }
        if (this.getRelevantPlans() != null && !this.getRelevantPlans().isEmpty()) {
            for (Option o : this.getRelevantPlans()) {
                if (alreadyIn.contains(o)) continue;
                alreadyIn.add(o);
                e2 = o.getAsDOM(document);
                e2.setAttribute("relevant", "true");
                plans.appendChild(e2);
            }
        }
        if (!alreadyIn.isEmpty()) {
            c.appendChild(plans);
        }
        Element ints = document.createElement("intentions");
        Element selIntEle = null;
        Intention ci = this.getSelectedIntention();
        if (ci != null && !ci.isFinished()) {
            selIntEle = ci.getAsDOM(document);
            selIntEle.setAttribute("selected", "true");
            ints.appendChild(selIntEle);
        }
        for (Intention in : this.getIntentions()) {
            if (this.getSelectedIntention() == in || in.isFinished()) continue;
            ints.appendChild(in.getAsDOM(document));
        }
        for (String wip : this.getPendingIntentions().keySet()) {
            Intention ip = this.getPendingIntentions().get(wip);
            if (this.getSelectedIntention() == ip) continue;
            e2 = ip.getAsDOM(document);
            e2.setAttribute("pending", wip);
            ints.appendChild(e2);
        }
        if (this.hasPendingAction()) {
            Iterator<Object> i$ = this.getPendingActions().keySet().iterator();
            while (i$.hasNext()) {
                int key = (Integer)i$.next();
                ActionExec ac = this.getPendingActions().get(key);
                Intention aci = ac.getIntention();
                if (this.getSelectedIntention() != null && this.getSelectedIntention().equals(aci)) {
                    selIntEle.setAttribute("pending", ac.getActionTerm().toString());
                    continue;
                }
                if (aci == null) continue;
                e2 = aci.getAsDOM(document);
                e2.setAttribute("pending", ac.getActionTerm().toString());
                ints.appendChild(e2);
            }
        }
        Element acts = document.createElement("actions");
        alreadyIn = new ArrayList();
        if (this.getAction() != null) {
            alreadyIn.add(this.getAction());
            e2 = this.getAction().getAsDOM(document);
            e2.setAttribute("selected", "true");
            if (this.getPendingActions().values().contains(this.getAction())) {
                e2.setAttribute("pending", "true");
            }
            List<ActionExec> key = this.getFeedbackActions();
            synchronized (key) {
                if (this.getFeedbackActions().contains(this.getAction())) {
                    e2.setAttribute("feedback", "true");
                }
            }
            acts.appendChild(e2);
        }
        if (this.hasPendingAction()) {
            for (int key : this.getPendingActions().keySet()) {
                ActionExec ac = this.getPendingActions().get(key);
                if (alreadyIn.contains(ac)) continue;
                e2 = ac.getAsDOM(document);
                e2.setAttribute("pending", key + "");
                acts.appendChild(e2);
                alreadyIn.add(ac);
            }
        }
        if (this.hasFeedbackAction()) {
            for (ActionExec o : this.getFeedbackActions()) {
                if (alreadyIn.contains(o)) continue;
                alreadyIn.add(o);
                e2 = o.getAsDOM(document);
                e2.setAttribute("feedback", "true");
                acts.appendChild(e2);
            }
        }
        if (ints.getChildNodes().getLength() > 0) {
            c.appendChild(ints);
        }
        if (acts.getChildNodes().getLength() > 0) {
            c.appendChild(acts);
        }
        return c;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Circumstance:\n");
        s.append("  E =" + this.E + "\n");
        s.append("  I =" + this.I + "\n");
        s.append("  A =" + this.A + "\n");
        s.append("  MB=" + this.MB + "\n");
        s.append("  RP=" + this.RP + "\n");
        s.append("  AP=" + this.AP + "\n");
        s.append("  SE=" + this.SE + "\n");
        s.append("  SO=" + this.SO + "\n");
        s.append("  SI=" + this.SI + "\n");
        s.append("  AI=" + this.AI + "\n");
        s.append("  PA=" + this.PA + "\n");
        s.append("  PI=" + this.PI + "\n");
        s.append("  FA=" + this.FA + ".");
        return s.toString();
    }
}

