/*
 * Decompiled with CFR 0.152.
 */
package jason.architecture;

import jason.JasonException;
import jason.architecture.AgArchInfraTier;
import jason.asSemantics.ActionExec;
import jason.asSemantics.Agent;
import jason.asSemantics.Circumstance;
import jason.asSemantics.Message;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.Literal;
import jason.bb.BeliefBase;
import jason.mas2j.ClassParameters;
import jason.runtime.Settings;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgArch {
    private TransitionSystem ts = null;
    private AgArchInfraTier archTier;
    private int cycleNumber = 0;

    public void initAg(String agClass, ClassParameters bbPars, String asSrc, Settings stts) throws JasonException {
        try {
            Agent ag = (Agent)Class.forName(agClass).newInstance();
            new TransitionSystem(ag, new Circumstance(), stts, this);
            BeliefBase bb = (BeliefBase)Class.forName(bbPars.getClassName()).newInstance();
            ag.setBB(bb);
            ag.initAg(asSrc);
            bb.init(ag, bbPars.getParametersArray());
        }
        catch (Exception e2) {
            throw new JasonException("as2j: error creating the customised Agent class! - ", e2);
        }
    }

    public void stopAg() {
        this.ts.getAg().stopAg();
    }

    public void setArchInfraTier(AgArchInfraTier ai) {
        this.archTier = ai;
    }

    public AgArchInfraTier getArchInfraTier() {
        return this.archTier;
    }

    public TransitionSystem getTS() {
        return this.ts;
    }

    public void setTS(TransitionSystem ts) {
        this.ts = ts;
    }

    public List<Literal> perceive() {
        return this.archTier.perceive();
    }

    public void checkMail() {
        this.archTier.checkMail();
    }

    public void act(ActionExec action, List<ActionExec> feedback) {
        this.archTier.act(action, feedback);
    }

    public boolean canSleep() {
        return this.archTier.canSleep();
    }

    public void sleep() {
        this.archTier.sleep();
    }

    public String getAgName() {
        if (this.archTier == null) {
            return "no-named";
        }
        return this.archTier.getAgName();
    }

    public void sendMsg(Message m) throws Exception {
        this.archTier.sendMsg(m);
    }

    public void broadcast(Message m) throws Exception {
        this.archTier.broadcast(m);
    }

    public boolean isRunning() {
        return this.archTier == null || this.archTier.isRunning();
    }

    public void setCycleNumber(int cycle) {
        this.cycleNumber = cycle;
    }

    public int getCycleNumber() {
        return this.cycleNumber;
    }
}

