/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeywordsHighlighter
extends Highlighter {
    private Collection<String> keywords;
    private boolean ignoreCase = false;

    KeywordsHighlighter(Params params) {
        this.ignoreCase = params.isSet("ignoreCase");
        this.keywords = this.ignoreCase ? new TreeSet<String>(new Highlighter.IgnoreCaseComparator()) : new TreeSet<String>();
        params.load("keyword", this.keywords);
    }

    @Override
    boolean startsWith(CharIter charIter) {
        return Character.isJavaIdentifierStart(charIter.current().charValue()) && (charIter.prev() == null || !Character.isJavaIdentifierPart(charIter.prev().charValue()));
    }

    @Override
    boolean highlight(CharIter charIter, List<Block> list) {
        while (!charIter.finished() && Character.isJavaIdentifierPart(charIter.current().charValue())) {
            charIter.moveNext();
        }
        if (this.keywords.contains(charIter.getMarked())) {
            list.add(charIter.markedToStyledBlock("keyword"));
            return true;
        }
        return false;
    }
}

